/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.actions.AbstractDsmAction;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModel;
import com.intellij.dsm.ui.DsmTable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.jetbrains.annotations.NotNull;

public class GoToNextCycleAction<N>
extends AbstractDsmAction<N>
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        int minSelectedRow;
        int minSelectedCol;
        if (e == null) {
            GoToNextCycleAction.$$$reportNull$$$0(0);
        }
        DsmTable table = this.getTable(e);
        Graph graph = table.getGraph().getIntGraph();
        TLongObjectHashMap edges = new TLongObjectHashMap();
        ArrayList<Object> cycles = new ArrayList<Object>();
        for (int v = 0; v < graph.V(); ++v) {
            Iterator<Edge> iterator = graph.getEdges(v);
            while (iterator.hasNext()) {
                Object back;
                Edge edge = iterator.next();
                int w = edge.w();
                if (v < w) {
                    edges.put(GoToNextCycleAction.toLong(v, w), (Object)edge);
                    continue;
                }
                if (w >= v || (back = (Edge)edges.get(GoToNextCycleAction.toLong(w, v))) == null) continue;
                cycles.add(edge);
                cycles.add(back);
            }
        }
        if (cycles.isEmpty()) {
            this.showHint(table, DsmBundle.message("hint.text.no.cycles.found", new Object[0]));
            return;
        }
        DsmSelectionModel selectionModel = table.getSelectionModel();
        Collection selection = selectionModel.getSelection();
        if (selection.isEmpty()) {
            minSelectedCol = -1;
            minSelectedRow = -1;
        } else {
            minSelectedRow = Integer.MAX_VALUE;
            minSelectedCol = Integer.MAX_VALUE;
            for (DsmSelection dsmSelection : selection) {
                if (GoToNextCycleAction.compareCells(dsmSelection.start1, dsmSelection.start2, minSelectedRow, minSelectedCol) >= 0) continue;
                minSelectedRow = dsmSelection.start1;
                minSelectedCol = dsmSelection.start2;
            }
        }
        int minCycleRow = Integer.MAX_VALUE;
        int minCycleCol = Integer.MAX_VALUE;
        for (Edge edge : cycles) {
            int colIndex;
            DsmTreeStructure.TreeNode row = table.getGraph().getNode(edge.v());
            DsmTreeStructure.TreeNode col = table.getGraph().getNode(edge.w());
            int rowIndex = table.getRowIndex(row);
            if (GoToNextCycleAction.compareCells(rowIndex, colIndex = table.getRowIndex(col), minSelectedRow, minSelectedCol) <= 0 || GoToNextCycleAction.compareCells(rowIndex, colIndex, minCycleRow, minCycleCol) >= 0) continue;
            minCycleRow = rowIndex;
            minCycleCol = colIndex;
        }
        DsmTreeStructure.TreeNode row = table.getRowByIndex(minCycleRow);
        DsmTreeStructure.TreeNode treeNode = table.getRowByIndex(minCycleCol);
        if (row == null || treeNode == null) {
            this.showHint(table, DsmBundle.message("hint.text.no.more.cycles.found", new Object[0]));
            return;
        }
        selectionModel.clear();
        selectionModel.addSelection(selectionModel.createCellSelection(row, treeNode));
        table.scrollCellToVisible(row, treeNode);
    }

    private void showHint(DsmTable<N> table, @NlsContexts.HintText String text) {
        JComponent label = HintUtil.createInformationLabel((SimpleColoredText)new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES));
        HintManager.getInstance().showHint(label, RelativePoint.getCenterOf((JComponent)table.getComponent()), 10, 3000);
    }

    private static int compareCells(int row1, int col1, int row2, int col2) {
        int rows = Comparing.compare((int)row1, (int)row2);
        if (rows != 0) {
            return rows;
        }
        return Comparing.compare((int)col1, (int)col2);
    }

    private static long toLong(int a, int b) {
        return (long)a | (long)b << 32;
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && this.getTable(e).isDisplayCycles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dsm/actions/GoToNextCycleAction", "actionPerformed"));
    }
}

