/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.convertcontentstoattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.convertcontentstoattribute.ConvertContentsToAttribute;
import com.sixrr.xrp.convertcontentstoattribute.ConvertContentsToAttributeUsageViewDescriptor;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ConvertContentsToAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String attributeName;
    private final Context context;
    private final boolean trim;

    ConvertContentsToAttributeProcessor(XmlTag tag, String attributeName, Context context, boolean trim) {
        super(tag.getProject());
        this.tag = tag;
        this.attributeName = attributeName;
        this.context = context;
        this.trim = trim;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            ConvertContentsToAttributeProcessor.$$$reportNull$$$0(0);
        }
        return new ConvertContentsToAttributeUsageViewDescriptor(this.tag);
    }

    @Override
    public void findUsages(@NotNull List<? super XRPUsageInfo> usages) {
        if (usages == null) {
            ConvertContentsToAttributeProcessor.$$$reportNull$$$0(1);
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            usages.add(new ConvertContentsToAttribute(xmlTag, this.attributeName, this.trim));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactorXBundle.message("command.name.convert.contents.tag.to.attribute", this.tag.getName(), this.attributeName);
        if (string == null) {
            ConvertContentsToAttributeProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/convertcontentstoattribute/ConvertContentsToAttributeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/convertcontentstoattribute/ConvertContentsToAttributeProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

