/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.changeattributevalue;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class ChangeAttributeValueDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField newAttributeField;
    private final XmlAttribute attribute;
    private final XmlTag tag;

    ChangeAttributeValueDialog(XmlAttribute attribute) {
        super(attribute.getProject(), true);
        this.attribute = attribute;
        String attributeName = attribute.getName();
        this.tag = attribute.getParent();
        XmlFile containingFile = (XmlFile)this.tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("change.attribute.value", new Object[0]));
        this.attributeNameLabel.setText(RefactorXBundle.message("label.text.new.value.for.attribute.0", attributeName));
        this.newAttributeField = new JTextField("");
        Document document = this.newAttributeField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.ChangeAttributeValue";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.newAttributeField;
    }

    public String getNewAttributeValue() {
        return this.newAttributeField.getText().trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.text.change.value.of.attribute.0.1.in.tag.2", attributeName, this.attribute.getValue(), tagName));
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder(border);
        this.newAttributeField.setEditable(true);
        box.add(this.newAttributeField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        return this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        String attributeValue = this.attribute.getValue();
        String newAttributeValue = this.getNewAttributeValue();
        return " <xsl:template match=\"@" + attributeName + "[.='" + attributeValue + "' and parent::" + tagName + "]\">\n    <xsl:attribute name=\"" + attributeName + "\">" + newAttributeValue + "</xsl:attribute>\n  </xsl:template>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.changeAttributeValue";
    }
}

