/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addattribute;

import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class AddAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JLabel attributeValueLabel = new JLabel();
    private final JTextField attributeNameField;
    private final JTextField attributeValueField;
    private final JCheckBox addIfAbsentCheckbox;
    private final XmlTag tag;

    AddAttributeDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("dialog.title.add.attribute", new Object[0]));
        this.attributeNameLabel.setText(RefactorXBundle.message("label.text.name.for.new.attribute", new Object[0]));
        this.attributeNameField = new JTextField();
        this.attributeValueLabel.setText(RefactorXBundle.message("label.text.value.for.new.attribute", new Object[0]));
        this.attributeValueField = new JTextField();
        this.addIfAbsentCheckbox = new JCheckBox(RefactorXBundle.message("checkbox.text.add.attribute.only.if.absent", new Object[0]));
        this.addIfAbsentCheckbox.setSelected(true);
        Document document = this.attributeNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.AddAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.attributeNameField;
    }

    public String getAttributeName() {
        return this.attributeNameField.getText().trim();
    }

    public String getAttributeValue() {
        return this.attributeValueField.getText().trim();
    }

    public boolean getAddOnlyIfAbsent() {
        return this.addIfAbsentCheckbox.isSelected();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.text.add.attribute.to.tag.0", tagName));
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder(border);
        this.attributeNameField.setEditable(true);
        box.add(this.attributeNameField);
        box.add(this.attributeValueLabel);
        box.add(this.attributeValueField);
        box.add(this.addIfAbsentCheckbox);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        return XMLRefactoringUtil.attributeNameIsValid(this.getAttributeName()) && this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String attributeName = this.getAttributeName();
        String attributeValue = this.getAttributeValue();
        if (this.getAddOnlyIfAbsent()) {
            return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\n\t\t<xsl:attribute name=\"" + attributeName + "\">" + attributeValue + "</xsl:attribute>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>\n<xsl:template match=\"" + tagName + "[@" + attributeName + "]\">\n\t<xsl:copy>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>";
        }
        return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\n\t\t<xsl:attribute name=\"" + attributeName + "\">" + attributeValue + "</xsl:attribute>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.addAttribute";
    }
}

