/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.uploader;

import com.google.gson.Gson;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.uploader.EventLogUploadException;
import com.intellij.internal.statistic.uploader.EventLogUploaderOptions;
import com.intellij.internal.statistic.uploader.events.ExternalEventsLogger;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\u0014\u0010\u0010\u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0014\"\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u001e\u0010\u001c\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0007J-\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,J%\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u00072\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0014H\u0002\u00a2\u0006\u0002\u0010/R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/internal/statistic/eventLog/uploader/EventLogExternalUploader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "UPLOADER_MAIN_CLASS", "", "addArgument", "", "args", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "name", "value", "findJavaHome", "findLibraryByClass", "clazz", "Ljava/lang/Class;", "findLibsByPrefixes", "", "Ljava/io/File;", "prefixes", "([Ljava/lang/String;)[Ljava/io/File;", "findUploader", "Ljava/nio/file/Path;", "getOrCreateTempDir", "getTempFile", "joinAsClasspath", "libCopies", "", "uploaderCopy", "logPreviousExternalUploadResult", "recorderId", "prepareUploadCommand", "config", "Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "recorder", "Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfig;", "applicationInfo", "Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "(Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfig;Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;)[Ljava/lang/String;", "startExternalUpload", "isTest", "", "startsWithAny", "str", "(Ljava/lang/String;[Ljava/lang/String;)Z", "intellij.platform.statistics"})
public final class EventLogExternalUploader {
    private static final Logger LOG;
    private static final String UPLOADER_MAIN_CLASS = "com.intellij.internal.statistic.uploader.EventLogUploader";
    @NotNull
    public static final EventLogExternalUploader INSTANCE;

    public final void logPreviousExternalUploadResult(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        EventLogInternalRecorderConfig recorder = new EventLogInternalRecorderConfig(recorderId);
        if (!recorder.isSendEnabled()) {
            return;
        }
        try {
            File tempDir = this.getTempFile();
            if (tempDir.exists()) {
                List<ExternalSystemEvent> list = ExternalEventsLogger.parseEvents(tempDir);
                Intrinsics.checkNotNullExpressionValue(list, (String)"ExternalEventsLogger.parseEvents(tempDir)");
                List<ExternalSystemEvent> events = list;
                for (ExternalSystemEvent event : events) {
                    ExternalSystemEvent externalSystemEvent = event;
                    if (externalSystemEvent instanceof ExternalUploadStartedEvent) {
                        EventLogSystemLogger.logStartingExternalSend(recorderId, ((ExternalUploadStartedEvent)event).getTimestamp());
                        continue;
                    }
                    if (externalSystemEvent instanceof ExternalUploadSendEvent) {
                        List<Integer> errors;
                        List<String> files;
                        Intrinsics.checkNotNullExpressionValue(((ExternalUploadSendEvent)event).getSuccessfullySentFiles(), (String)"event.successfullySentFiles");
                        Intrinsics.checkNotNullExpressionValue(((ExternalUploadSendEvent)event).getErrors(), (String)"event.errors");
                        EventLogSystemLogger.logFilesSend(recorderId, ((ExternalUploadSendEvent)event).getTotal(), ((ExternalUploadSendEvent)event).getSucceed(), ((ExternalUploadSendEvent)event).getFailed(), true, files, errors);
                        continue;
                    }
                    if (externalSystemEvent instanceof ExternalUploadFinishedEvent) {
                        EventLogSystemLogger.logFinishedExternalSend(recorderId, ((ExternalUploadFinishedEvent)event).getError(), ((ExternalUploadFinishedEvent)event).getTimestamp());
                        continue;
                    }
                    if (!(externalSystemEvent instanceof ExternalSystemErrorEvent)) continue;
                    EventLogSystemLogger.logSystemError(recorderId, ((ExternalSystemErrorEvent)event).getEvent(), ((ExternalSystemErrorEvent)event).getErrorClass(), ((ExternalSystemErrorEvent)event).getTimestamp());
                }
            }
            FilesKt.deleteRecursively((File)tempDir);
        }
        catch (Exception e) {
            LOG.warn("Failed reading previous upload result: " + e.getMessage());
        }
    }

    public final void startExternalUpload(@NotNull String recorderId, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        EventLogInternalRecorderConfig recorder = new EventLogInternalRecorderConfig(recorderId, false);
        if (!recorder.isSendEnabled()) {
            LOG.info("Don't start external process because sending logs is disabled");
            return;
        }
        EventLogSystemLogger.logCreatingExternalSendCommand(recorderId);
        EventLogRecorderConfiguration config = EventLogConfiguration.Companion.getInstance().getOrCreate(recorderId);
        EventLogInternalApplicationInfo application = new EventLogInternalApplicationInfo(recorderId, isTest);
        try {
            String[] command = this.prepareUploadCommand(config, recorder, application);
            EventLogSystemLogger.logFinishedCreatingExternalSendCommand(recorderId, null);
            Runtime.getRuntime().exec(command);
            LOG.info("Started external process for uploading event log");
        }
        catch (EventLogUploadException e) {
            EventLogSystemLogger.logFinishedCreatingExternalSendCommand(recorderId, e.getErrorType());
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String[] prepareUploadCommand(EventLogRecorderConfiguration config, EventLogRecorderConfig recorder, EventLogApplicationInfo applicationInfo) {
        void $this$mapTo$iv$iv22;
        File[] libs;
        String string;
        Collection collection;
        Object object;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = recorder.getFilesToSendProvider().getFilesToSend();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            object = (EventLogFile)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it.getFile().getAbsolutePath();
            collection.add(string);
        }
        List logFiles = (List)destination$iv$iv;
        if (logFiles.isEmpty()) {
            throw (Throwable)new EventLogUploadException("No available logs to send", EventLogUploadException.EventLogUploadErrorType.NO_LOGS);
        }
        File tempDir = this.getOrCreateTempDir();
        Path uploader = this.findUploader();
        File[] $this$map$iv2 = libs = this.findLibsByPrefixes("kotlin-stdlib", "commons-logging");
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
        boolean $i$f$mapTo2 = false;
        void var14_23 = $this$mapTo$iv$iv22;
        int n = ((void)var14_23).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv3;
            void var18_28 = item$iv$iv3 = var14_23[i];
            collection = destination$iv$iv2;
            boolean bl = false;
            string = it.getPath();
            collection.add(string);
        }
        List libPaths = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        libPaths.add(this.findLibraryByClass(NotNull.class));
        libPaths.add(this.findLibraryByClass(org.apache.log4j.Logger.class));
        libPaths.add(this.findLibraryByClass(Gson.class));
        libPaths.add(this.findLibraryByClass(EventGroupsFilterRules.class));
        String classpath = this.joinAsClasspath(libPaths, uploader);
        boolean $this$mapTo$iv$iv22 = false;
        ArrayList<String> args = new ArrayList<String>();
        String java = this.findJavaHome();
        object = args;
        String string2 = new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath();
        boolean bl = false;
        object.add(string2);
        this.addArgument(args, "-cp", classpath);
        object = args;
        string2 = "-Djava.io.tmpdir=" + tempDir.getPath();
        bl = false;
        object.add(string2);
        object = args;
        string2 = UPLOADER_MAIN_CLASS;
        bl = false;
        object.add(string2);
        this.addArgument(args, "--ide-token", ((Object)Paths.get(PathManager.getSystemPath(), "token").toAbsolutePath()).toString());
        this.addArgument(args, "--recorder", recorder.getRecorderId());
        Iterable iterable2 = logFiles;
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"File.pathSeparator");
        this.addArgument(args, "--files", CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null));
        this.addArgument(args, "--device", config.getDeviceId());
        this.addArgument(args, "--bucket", String.valueOf(config.getBucket()));
        this.addArgument(args, "--machine-id", config.getMachineId().getId());
        this.addArgument(args, "--id-revision-option", String.valueOf(config.getMachineId().getRevision()));
        String string4 = applicationInfo.getTemplateUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"applicationInfo.templateUrl");
        this.addArgument(args, "--url", string4);
        String string5 = applicationInfo.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"applicationInfo.productCode");
        this.addArgument(args, "--product", string5);
        String string6 = applicationInfo.getProductVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"applicationInfo.productVersion");
        this.addArgument(args, "--product-version", string6);
        this.addArgument(args, "--user-agent", applicationInfo.getConnectionSettings().getUserAgent());
        if (applicationInfo.isInternal()) {
            object = args;
            string2 = "--internal";
            bl = false;
            object.add(string2);
        }
        if (applicationInfo.isTest()) {
            object = args;
            string2 = "--test";
            bl = false;
            object.add(string2);
        }
        if (applicationInfo.isEAP()) {
            object = args;
            string2 = "--eap";
            bl = false;
            object.add(string2);
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)args);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ArrayUtil.toStringArray(args)");
        return stringArray;
    }

    private final void addArgument(ArrayList<String> args, String name, String value) {
        Collection collection = args;
        boolean bl = false;
        collection.add(name);
        collection = args;
        bl = false;
        collection.add(value);
    }

    private final String joinAsClasspath(List<String> libCopies, Path uploaderCopy) {
        if (libCopies.isEmpty()) {
            return ((Object)uploaderCopy).toString();
        }
        Iterable iterable = libCopies;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.pathSeparator");
        String libClassPath = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        return libClassPath + File.pathSeparator + uploaderCopy;
    }

    private final Path findUploader() {
        Path uploader;
        Path path = uploader = PluginManagerCore.isRunningFromSources() ? Paths.get(PathManager.getHomePath(), "out/artifacts/statistics-uploader.jar") : PathManager.getJarForClass(EventLogUploaderOptions.class);
        if (uploader == null || !Files.isRegularFile(uploader, new LinkOption[0])) {
            throw (Throwable)new EventLogUploadException("Cannot find uploader jar", EventLogUploadException.EventLogUploadErrorType.NO_UPLOADER);
        }
        return uploader;
    }

    private final String findLibraryByClass(Class<?> clazz) {
        Path library = PathManager.getJarForClass(clazz);
        if (library == null || !Files.isRegularFile(library, new LinkOption[0])) {
            throw (Throwable)new EventLogUploadException("Cannot find jar for " + clazz, EventLogUploadException.EventLogUploadErrorType.NO_UPLOADER);
        }
        return ((Object)library).toString();
    }

    private final String findJavaHome() {
        String string = System.getProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"java.home\")");
        return string;
    }

    private final File[] findLibsByPrefixes(String ... prefixes) {
        File[] libFiles2;
        block3: {
            block2: {
                String string = PathManager.getLibPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathManager.getLibPath()");
                String lib = string;
                libFiles2 = new File(lib).listFiles(new FileFilter(prefixes){
                    final /* synthetic */ String[] $prefixes;

                    public final boolean accept(File file) {
                        File file2 = file;
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        String string = file2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                        return EventLogExternalUploader.access$startsWithAny(EventLogExternalUploader.INSTANCE, string, this.$prefixes);
                    }
                    {
                        this.$prefixes = stringArray;
                    }
                });
                if (libFiles2 == null) break block2;
                File[] fileArray = libFiles2;
                boolean bl = false;
                if (!(fileArray.length == 0)) break block3;
            }
            throw (Throwable)new EventLogUploadException("Cannot find libraries from dependency for event log uploader", EventLogUploadException.EventLogUploadErrorType.NO_LIBRARIES);
        }
        return libFiles2;
    }

    private final boolean startsWithAny(String str, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!StringsKt.startsWith$default((String)str, (String)prefix, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    private final File getOrCreateTempDir() {
        File tempDir = this.getTempFile();
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw (Throwable)new EventLogUploadException("Cannot create temp directory: " + tempDir, EventLogUploadException.EventLogUploadErrorType.NO_TEMP_FOLDER);
        }
        return tempDir;
    }

    private final File getTempFile() {
        return new File(PathManager.getTempPath(), "statistics-uploader");
    }

    private EventLogExternalUploader() {
    }

    static {
        EventLogExternalUploader eventLogExternalUploader;
        INSTANCE = eventLogExternalUploader = new EventLogExternalUploader();
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Event\u2026ternalUploader.javaClass)");
        LOG = logger2;
    }

    public static final /* synthetic */ boolean access$startsWithAny(EventLogExternalUploader $this, String str, String[] prefixes) {
        return $this.startsWithAny(str, prefixes);
    }
}

