/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheVersion;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManagerKt;
import org.jetbrains.kotlin.load.kotlin.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersion;", "versionFile", "Ljava/nio/file/Path;", "expectedOwnVersion", "", "(Ljava/nio/file/Path;Ljava/lang/Integer;)V", "expected", "getExpected", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersion;", "versionFileForTesting", "Ljava/io/File;", "getVersionFileForTesting", "()Ljava/io/File;", "loadActual", "writeVersion", "", "values", "kotlin.jps-plugin"})
public final class CacheVersionManager
implements CacheAttributesManager<CacheVersion> {
    @Nullable
    private final CacheVersion expected;
    private final Path versionFile;

    @Override
    @Nullable
    public CacheVersion getExpected() {
        return this.expected;
    }

    @Override
    @Nullable
    public CacheVersion loadActual() {
        Path path;
        Object object = this.versionFile;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        if (Files.notExists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            path = null;
        } else {
            try {
                object = PathsKt.readText$default((Path)this.versionFile, null, (int)1, null);
                boolean bl2 = false;
                object = new CacheVersion(Integer.parseInt((String)object));
            }
            catch (NumberFormatException e) {
                object = null;
            }
            catch (IOException e) {
                object = null;
            }
            path = object;
        }
        return path;
    }

    @Override
    public void writeVersion(@Nullable CacheVersion values) {
        if (values == null) {
            Path path = this.versionFile;
            boolean bl = false;
            Files.deleteIfExists(path);
        } else {
            Path path = this.versionFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"versionFile.parent");
            Path path2 = path;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
            PathsKt.writeText$default((Path)this.versionFile, (CharSequence)String.valueOf(values.getIntValue()), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
    }

    @TestOnly
    @NotNull
    public final File getVersionFileForTesting() {
        File file2 = this.versionFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"versionFile.toFile()");
        return file2;
    }

    public CacheVersionManager(@NotNull Path versionFile, @Nullable Integer expectedOwnVersion) {
        Intrinsics.checkNotNullParameter((Object)versionFile, (String)"versionFile");
        this.versionFile = versionFile;
        this.expected = expectedOwnVersion == null ? null : CacheVersionManagerKt.CacheVersion(expectedOwnVersion, JvmBytecodeBinaryVersion.INSTANCE, JvmMetadataVersion.INSTANCE);
    }

    @Override
    public boolean isCompatible(@NotNull CacheVersion actual, @NotNull CacheVersion expected) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return CacheAttributesManager.DefaultImpls.isCompatible(this, actual, expected);
    }
}

