/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandProcessor {
    public static CommandProcessor getInstance() {
        return (CommandProcessor)ApplicationManager.getApplication().getService(CommandProcessor.class);
    }

    public abstract void executeCommand(@Nullable Project var1, @NotNull Runnable var2, @Nullable @NlsContexts.Command String var3, @Nullable Object var4);

    public abstract void executeCommand(@Nullable Project var1, @NotNull Runnable var2, @Nullable @NlsContexts.Command String var3, @Nullable Object var4, @Nullable Document var5);

    public abstract void executeCommand(@Nullable Project var1, @NotNull Runnable var2, @Nullable @NlsContexts.Command String var3, @Nullable Object var4, @NotNull UndoConfirmationPolicy var5);

    public abstract void executeCommand(@Nullable Project var1, @NotNull Runnable var2, @Nullable @NlsContexts.Command String var3, @Nullable Object var4, @NotNull UndoConfirmationPolicy var5, @Nullable Document var6);

    public abstract void executeCommand(@Nullable Project var1, @NotNull Runnable var2, @Nullable @NlsContexts.Command String var3, @Nullable Object var4, @NotNull UndoConfirmationPolicy var5, boolean var6);

    @ApiStatus.Experimental
    public abstract void executeCommand(@Nullable Project var1, @NotNull Runnable var2, @Nullable @NlsContexts.Command String var3, @Nullable Object var4, @NotNull UndoConfirmationPolicy var5, boolean var6, @Nullable Document var7);

    public abstract void setCurrentCommandName(@Nullable @NlsContexts.Command String var1);

    public abstract void setCurrentCommandGroupId(@Nullable Object var1);

    @Nullable
    public abstract Runnable getCurrentCommand();

    @Nullable
    @Nls
    public abstract String getCurrentCommandName();

    @Nullable
    public abstract Object getCurrentCommandGroupId();

    @Nullable
    public abstract Project getCurrentCommandProject();

    public abstract void runUndoTransparentAction(@NotNull Runnable var1);

    public abstract boolean isUndoTransparentActionInProgress();

    public abstract void markCurrentCommandAsGlobal(@Nullable Project var1);

    public abstract void addAffectedDocuments(@Nullable Project var1, Document ... var2);

    public abstract void addAffectedFiles(@Nullable Project var1, VirtualFile ... var2);

    @Deprecated
    public abstract void addCommandListener(@NotNull CommandListener var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void addCommandListener(@NotNull CommandListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            CommandProcessor.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            CommandProcessor.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(CommandListener.TOPIC, (Object)listener);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void removeCommandListener(@NotNull CommandListener var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/command/CommandProcessor";
        objectArray[2] = "addCommandListener";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

