/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.jam.implicitlyRegistered;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBeanWithDefinition;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.ImplicitlyRegisteredBeansProvider;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringIntegrationImplicitlyRegisteredBean
extends ContextJavaBean
implements ImplicitlyRegisteredBeansProvider {
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    public SpringIntegrationImplicitlyRegisteredBean(@NotNull PsiMethod psiMethod, @NotNull String anno) {
        if (psiMethod == null) {
            SpringIntegrationImplicitlyRegisteredBean.$$$reportNull$$$0(0);
        }
        if (anno == null) {
            SpringIntegrationImplicitlyRegisteredBean.$$$reportNull$$$0(1);
        }
        super(psiMethod);
        this.myPsiAnnotation = new AnnotationChildLink(anno).createChildRef((PsiElement)psiMethod);
    }

    public boolean isValid() {
        return this.getPsiElement().isValid();
    }

    @Nullable
    public PsiAnnotation getPsiAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    public String getBeanName() {
        String className;
        PsiClass containingClass;
        String value;
        PsiMethod psiMethod = this.getPsiElement();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (String[])new String[]{"org.springframework.integration.annotation.EndpointId"});
        if (annotation != null && StringUtil.isNotEmpty((String)(value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"value")))) {
            return value;
        }
        String methodName = psiMethod.getName();
        if (StringUtil.isNotEmpty((String)methodName) && (containingClass = psiMethod.getContainingClass()) != null && StringUtil.isNotEmpty((String)(className = containingClass.getName()))) {
            return StringUtil.decapitalize((String)className) + "." + methodName + "." + this.getBeanNameSuffix();
        }
        return super.getBeanName();
    }

    @NotNull
    protected abstract String getBeanNameSuffix();

    @NotNull
    protected abstract String getSecondBeanClass();

    @NotNull
    protected abstract String getSecondBeanNameSuffix();

    @NotNull
    public Set<CommonSpringBean> getImplicitlyRegistered() {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)this.getPsiElement(), (String)"org.springframework.context.annotation.Bean", (int)0)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                SpringIntegrationImplicitlyRegisteredBean.$$$reportNull$$$0(2);
            }
            return set;
        }
        Project project = this.getPsiElement().getProject();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(this.getSecondBeanClass(), GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            Set<SpringImplicitBeanWithDefinition> set = Collections.singleton(new SpringImplicitBeanWithDefinition(this.getBeanName() + "." + this.getSecondBeanNameSuffix(), psiClass, (CommonSpringBean)this, (PsiTarget)new DelegatePsiTarget((PsiElement)this.getPsiElement())));
            if (set == null) {
                SpringIntegrationImplicitlyRegisteredBean.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<CommonSpringBean> set = Collections.emptySet();
        if (set == null) {
            SpringIntegrationImplicitlyRegisteredBean.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/model/jam/implicitlyRegistered/SpringIntegrationImplicitlyRegisteredBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/model/jam/implicitlyRegistered/SpringIntegrationImplicitlyRegisteredBean";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyRegistered";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

