/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.jam;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.integration.model.jam.IntegrationComponentScan;
import com.intellij.spring.integration.model.jam.messagingGateway.MessagingGateway;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessagingGatewaysSearchUtil {
    private static final Key<CachedValue<List<CommonSpringBean>>> ALL_INTEGRATION_COMPONENT_SCANS_KEY = Key.create((String)"ALL_INTEGRATION_COMPONENT_SCANS_KEY");
    private static final Key<CachedValue<List<CommonSpringBean>>> ALL_INTEGRATION_COMPONENT_SCANS_INCLUDING_TESTS_KEY = Key.create((String)"ALL_INTEGRATION_COMPONENT_SCANS_INCLUDING_TESTS_KEY");

    public static List<CommonSpringBean> getAllMessagingGateways(@NotNull Module module, IntegrationComponentScan scan) {
        if (module == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(0);
        }
        PsiFile file = scan.getContainingFile();
        assert (file != null);
        boolean isInTestSources = ProjectRootsUtil.isInTestSource((PsiFile)file);
        Key<CachedValue<List<CommonSpringBean>>> cachedValueKey = isInTestSources ? ALL_INTEGRATION_COMPONENT_SCANS_INCLUDING_TESTS_KEY : ALL_INTEGRATION_COMPONENT_SCANS_KEY;
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, cachedValueKey, () -> {
            SmartList result = new SmartList();
            result.addAll(MessagingGatewaysSearchUtil.getMessagingGateways(module, isInTestSources));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    @NotNull
    public static List<CommonSpringBean> getMessagingGateways(@NotNull Module module, boolean isInTestSources) {
        if (module == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(1);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)isInTestSources);
        JamService jamService = JamService.getJamService((Project)module.getProject());
        SmartList messagingGateways = new SmartList();
        for (String anno : MessagingGatewaysSearchUtil.getMessagingGatewayAnnotations(module)) {
            List elements = jamService.getJamClassElements(MessagingGateway.MESSAGING_GATEWAY_JAM_KEY, anno, scope);
            for (MessagingGateway gateway : elements) {
                if (!(gateway instanceof CommonSpringBean)) continue;
                messagingGateways.add((CommonSpringBean)gateway);
            }
        }
        SmartList smartList = messagingGateways;
        if (smartList == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    public static Collection<String> getMessagingGatewayAnnotations(@Nullable Module module) {
        if (module == null) {
            Set<String> set = Collections.singleton("org.springframework.integration.annotation.MessagingGateway");
            if (set == null) {
                MessagingGatewaysSearchUtil.$$$reportNull$$$0(3);
            }
            return set;
        }
        Collection classes = JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationTypesWithChildren("org.springframework.integration.annotation.MessagingGateway");
        List list = ContainerUtil.mapNotNull((Collection)classes, (Function)((NullableFunction)PsiClass::getQualifiedName));
        if (list == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagingGateways";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagingGatewayAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllMessagingGateways";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessagingGateways";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

