/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections.jam;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringIntegrationJamModelInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(1);
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return null;
        }
        if (!SpringIntegrationJamModelInspectionBase.isFileAccepted(file.getContainingFile())) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        this.checkJavaFile((PsiJavaFile)file, holder);
        List problemDescriptors = holder.getResults();
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder) {
        if (javaFile == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(3);
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder) {
        this.checkClass(aClass, holder);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder);
        }
    }

    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(4);
        }
    }

    protected static boolean isFileAccepted(PsiFile file) {
        if (!InspectionValidatorWrapper.isCompilationThread()) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return SpringIntegrationUtil.isSpringIntegrationUsed(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/integration/inspections/jam/SpringIntegrationJamModelInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkJavaFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

