/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection.el;

import com.intellij.jsp.el.impl.ELElementProcessor;
import com.intellij.jsp.el.impl.JspImplicitVariableWithCustomResolve;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.spring.integration.injection.el.SpringIntegrationImplicitVariable;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class HeadersVariable
extends SpringIntegrationImplicitVariable
implements JspImplicitVariableWithCustomResolve {
    HeadersVariable(PsiElement element) {
        super(element, "headers", HeadersVariable.getHeadersType(element));
    }

    public boolean process(ELExpression element, ELElementProcessor processor) {
        if (element instanceof ELLiteralExpression) {
            return false;
        }
        PsiClass mapPsiClass = ((PsiClassType)this.getType()).resolve();
        if (mapPsiClass == null) {
            return false;
        }
        Collection signatures = mapPsiClass.getVisibleSignatures();
        List methods = signatures.stream().map(MethodSignatureBackedByPsiMethod::getMethod).filter(method -> !method.isConstructor() && method.hasModifierProperty("public") && !method.hasModifierProperty("static")).collect(Collectors.toList());
        for (PsiMethod method2 : methods) {
            if (processor.processMethod(method2)) continue;
            return false;
        }
        return true;
    }

    private static PsiType getHeadersType(PsiElement element) {
        PsiClass libraryClass;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && (libraryClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.messaging.MessageHeaders")) != null) {
            return JavaPsiFacade.getElementFactory((Project)element.getProject()).createType(libraryClass);
        }
        return JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createTypeByFQClassName("java.util.Map", element.getResolveScope());
    }
}

