/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLabelModel;
import com.intellij.openapi.graph.layout.hierarchic.IncrementalHierarchicLayouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.SmartNodeLabelModel;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.integration.diagram.SpringIntegrationDiagramNodeContentManager;
import com.intellij.spring.integration.diagram.SpringIntegrationMessageEndpointWrapper;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.SpringDiagramExtras;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import java.awt.Point;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringIntegrationDiagramExtras
extends SpringDiagramExtras {
    SpringIntegrationDiagramExtras() {
    }

    public Layouter getCustomLayouter(GraphSettings settings, Project project) {
        IncrementalHierarchicLayouter layouter = GraphManager.getGraphManager().createIncrementalHierarchicLayouter();
        layouter.setConsiderNodeLabelsEnabled(true);
        layouter.setIntegratedEdgeLabelingEnabled(true);
        layouter.setOrthogonallyRouted(false);
        layouter.setEdgeToEdgeDistance(30.0);
        layouter.setBackloopRoutingEnabled(false);
        layouter.setLayoutOrientation(LayoutOrientation.LEFT_TO_RIGHT);
        GraphLayoutService.getInstance().setEdgeLabeling((Layouter)layouter, true);
        return layouter;
    }

    @NotNull
    public JComponent createNodeComponent(@NotNull DiagramNode<SpringElementWrapper<?>> node, @NotNull DiagramBuilder builder, @NotNull Point basePoint, @NotNull JPanel wrapper) {
        if (node == null) {
            SpringIntegrationDiagramExtras.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            SpringIntegrationDiagramExtras.$$$reportNull$$$0(1);
        }
        if (basePoint == null) {
            SpringIntegrationDiagramExtras.$$$reportNull$$$0(2);
        }
        if (wrapper == null) {
            SpringIntegrationDiagramExtras.$$$reportNull$$$0(3);
        }
        SimpleColoredComponent component = this.createLabel(builder, node);
        Icon icon = ((SpringElementWrapper)node.getIdentifyingElement()).getIcon();
        component.setIcon((Icon)(icon != null ? ScalableIconWrapper.evaluateDeferredAndWrap((Icon)icon) : null));
        this.setNodeBorders(node, builder, wrapper);
        NodeRealizer realizer = builder.getGraph().getRealizer(builder.getNode(node));
        Object wrapped = ((SpringElementWrapper)node.getIdentifyingElement()).getWrapped();
        if (SpringIntegrationDiagramExtras.isShowLabels(builder)) {
            String name = SpringIntegrationDiagramExtras.getWrappedElementName(wrapped);
            if (name != null) {
                NodeLabel label = GraphManager.getGraphManager().createNodeLabel();
                SmartNodeLabelModel labelModel = GraphManager.getGraphManager().createSmartNodeLabelModel();
                label.setLabelModel((NodeLabelModel)labelModel, labelModel.createDiscreteModelParameter(SmartNodeLabelModel.POSITION_SOUTH));
                label.setText(name);
                label.setTextColor(JBColor.foreground());
                realizer.setLabel(label);
            }
        } else if (realizer.labelCount() > 0) {
            realizer.removeLabel(0);
        }
        SimpleColoredComponent simpleColoredComponent = component;
        if (simpleColoredComponent == null) {
            SpringIntegrationDiagramExtras.$$$reportNull$$$0(4);
        }
        return simpleColoredComponent;
    }

    @Nullable
    private static String getWrappedElementName(Object wrapped) {
        if (wrapped instanceof SpringBeanPointer) {
            return ((SpringBeanPointer)wrapped).getName();
        }
        if (wrapped instanceof SpringIntegrationJamMethodEndpoint) {
            return ((SpringIntegrationJamMethodEndpoint)wrapped).getPsiElement().getName();
        }
        return null;
    }

    public Object getData(@NotNull String dataId, List<DiagramNode<SpringElementWrapper<?>>> diagramNodes, DiagramBuilder builder) {
        SpringIntegrationJamMethodEndpoint methodEndpoint;
        PsiMethod psiMethod;
        SpringElementWrapper wrapper;
        if (dataId == null) {
            SpringIntegrationDiagramExtras.$$$reportNull$$$0(5);
        }
        if (diagramNodes != null && diagramNodes.size() == 1 && (wrapper = (SpringElementWrapper)diagramNodes.get(0).getIdentifyingElement()) instanceof SpringIntegrationMessageEndpointWrapper && (psiMethod = (methodEndpoint = (SpringIntegrationJamMethodEndpoint)((SpringIntegrationMessageEndpointWrapper)wrapper).getWrapped()).getPsiElement()).isValid()) {
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiMethod;
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                return new Navigatable[]{psiMethod};
            }
        }
        return super.getData(dataId, diagramNodes, builder);
    }

    private static boolean isShowLabels(DiagramBuilder builder) {
        return Objects.requireNonNull(builder.getDataModel().getNodeContentManager()).isCategoryEnabled(SpringIntegrationDiagramNodeContentManager.SHOW_LABELS);
    }

    public DiagramAddElementAction getAddElementHandler() {
        return null;
    }

    public DiagramDnDProvider<SpringElementWrapper<?>> getDnDProvider() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/diagram/SpringIntegrationDiagramExtras";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/diagram/SpringIntegrationDiagramExtras";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNodeComponent";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

