/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.integration.SpringIntegrationCoreIcons;
import com.intellij.spring.integration.diagram.SpringIntegrationBeanPointerWrapper;
import com.intellij.spring.integration.diagram.SpringIntegrationDataModelUtils;
import com.intellij.spring.integration.diagram.SpringIntegrationDiagramProvider;
import com.intellij.spring.integration.diagram.SpringIntegrationMessageEndpointWrapper;
import com.intellij.spring.integration.diagram.SpringIntegrationNode;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamBridgeFrom;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamBridgeTo;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamTransformer;
import com.intellij.spring.integration.model.xml.core.EndpointDomBean;
import com.intellij.spring.integration.model.xml.core.InterceptorsOwner;
import com.intellij.spring.integration.model.xml.core.WireTap;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.edges.MessageFlowEdge;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringIntegrationDataModel
extends DiagramDataModel<SpringElementWrapper<?>> {
    private static final Key<Boolean> PROCESSED_KEY = Key.create((String)"PROCESSED_KEY");
    private static final Set<String> INBOUND_CHANNELS = Set.of("input-channel", "default-reply-channel", "reply-channel");
    private static final Set<String> OUTBOUND_CHANNELS = Set.of("default-output-channel", "output-channel", "default-request-channel", "request-channel", "default-publisher-channel", "default-channel", "nullChannel");
    private static final Set<String> NON_STANDARD_OUTBOUND_CHANNELS = Set.of("error-channel", "discard-channel", "return-channel", "on-success-result-channel", "on-failure-result-channel", "confirm-ack-channel", "confirm-nack-channel");
    private static final String CHANNEL = "channel";
    private static final Set<String> ROUTER_OUTBOUND_CHANNEL_PARENTS = Set.of("mapping", "recipient");
    private static final String OUTBOUND_GATEWAY_INBOUND = "request-channel";
    private static final String OUTBOUND_GATEWAY_OUTBOUND = "reply-channel";
    private final SpringElementWrapper myElement;
    private final Collection<DiagramNode<SpringElementWrapper<?>>> myNodes = new HashSet();
    private final Collection<DiagramEdge<SpringElementWrapper<?>>> myEdges = new HashSet();
    private final Collection<SpringBeanPointer<?>> messageChannels = new HashSet();
    private final Collection<SpringIntegrationJamTransformer> transformers = new HashSet<SpringIntegrationJamTransformer>();

    public SpringIntegrationDataModel(Project project, SpringIntegrationDiagramProvider provider, SpringElementWrapper element) {
        super(project, (DiagramProvider)provider);
        this.myElement = element;
    }

    @NotNull
    public Collection<? extends DiagramNode<SpringElementWrapper<?>>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper<?>>> collection = this.myNodes;
        if (collection == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<SpringElementWrapper<?>>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper<?>>> collection = this.myEdges;
        if (collection == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<SpringElementWrapper<?>> n) {
        if (n == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(2);
        }
        String string = ((SpringElementWrapper)n.getIdentifyingElement()).getName();
        if (string == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper<?>> addElement(@Nullable SpringElementWrapper element) {
        if (element == null) {
            return null;
        }
        SpringIntegrationNode node = new SpringIntegrationNode(element, this.getProvider());
        this.myNodes.add((DiagramNode<SpringElementWrapper<?>>)node);
        return node;
    }

    public void refreshDataModel() {
        this.myEdges.clear();
        this.myNodes.clear();
        Module module = this.myElement.getModule();
        if (module == null || DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        CommonSpringModel applicationModel = this.myElement.getProcessingSpringModel(false);
        if (applicationModel == null) {
            return;
        }
        this.messageChannels.clear();
        this.messageChannels.addAll(SpringIntegrationUtil.getMessageChannels(module, (NotNullFactory<? extends CommonSpringModel>)((NotNullFactory)() -> applicationModel)));
        for (SpringBeanPointer pointer : SpringModelVisitorUtils.getAllDomBeans((CommonSpringModel)applicationModel)) {
            this.processEndpoints(applicationModel, pointer);
            this.processInterceptors(applicationModel, pointer);
        }
        Set<SpringIntegrationJamMethodEndpoint> methodEndpoints = SpringIntegrationDataModelUtils.getJamMethodEndpoints(applicationModel);
        this.transformers.clear();
        this.transformers.addAll(methodEndpoints.stream().filter(SpringIntegrationJamTransformer.class::isInstance).map(SpringIntegrationJamTransformer.class::cast).collect(Collectors.toSet()));
        for (SpringIntegrationJamMethodEndpoint methodEndpoint : methodEndpoints) {
            DiagramNode<SpringElementWrapper<?>> jamMethodNode = this.getOrCreateElement(methodEndpoint, module);
            if (jamMethodNode == null) continue;
            for (String outboundChannelName : methodEndpoint.getOutboundChannelNames()) {
                DiagramNode<SpringElementWrapper<?>> outboundChannelNode;
                SpringBeanPointer<?> outboundChannel = SpringIntegrationDataModel.findMessageChannelByName(this.messageChannels, this.transformers, outboundChannelName, module);
                if (outboundChannel == null || (outboundChannelNode = this.getOrCreateElement(outboundChannel, applicationModel)) == null) continue;
                this.addEdge((DiagramEdge<SpringElementWrapper<?>>)new MessageFlowEdge(jamMethodNode, outboundChannelNode, (PsiElement)methodEndpoint.getPsiElement()));
            }
            for (String inboundChannelName : methodEndpoint.getInboundChannelNames()) {
                DiagramNode<SpringElementWrapper<?>> inboundChannelNode;
                SpringBeanPointer<?> inboundChannel = SpringIntegrationDataModel.findMessageChannelByName(this.messageChannels, this.transformers, inboundChannelName, module);
                if (inboundChannel == null || (inboundChannelNode = this.getOrCreateElement(inboundChannel, applicationModel)) == null) continue;
                this.addEdge((DiagramEdge<SpringElementWrapper<?>>)new MessageFlowEdge(inboundChannelNode, jamMethodNode, (PsiElement)methodEndpoint.getPsiElement()));
            }
            if (methodEndpoint instanceof SpringIntegrationJamBridgeFrom) {
                this.addBridgeFromNodeChannel(applicationModel, methodEndpoint, jamMethodNode);
                continue;
            }
            if (!(methodEndpoint instanceof SpringIntegrationJamBridgeTo)) continue;
            this.addBridgeToNodeChannel(applicationModel, methodEndpoint, jamMethodNode);
        }
    }

    private void addBridgeToNodeChannel(CommonSpringModel module, SpringIntegrationJamMethodEndpoint endpoint, DiagramNode<SpringElementWrapper<?>> node) {
        DiagramNode<SpringElementWrapper<?>> inboundChannelNode;
        SpringBeanPointer<?> channel = this.findContextBeanChannelForMethod(endpoint.getPsiElement());
        if (channel != null && (inboundChannelNode = this.getOrCreateElement(channel, module)) != null) {
            this.addEdge((DiagramEdge<SpringElementWrapper<?>>)new MessageFlowEdge(inboundChannelNode, node, (PsiElement)endpoint.getPsiElement()));
        }
    }

    private void addBridgeFromNodeChannel(CommonSpringModel model, SpringIntegrationJamMethodEndpoint methodEndpoint, DiagramNode<SpringElementWrapper<?>> jamMethodNode) {
        DiagramNode<SpringElementWrapper<?>> outboundChannelNode;
        SpringBeanPointer<?> channel = this.findContextBeanChannelForMethod(methodEndpoint.getPsiElement());
        if (channel != null && (outboundChannelNode = this.getOrCreateElement(channel, model)) != null) {
            this.addEdge((DiagramEdge<SpringElementWrapper<?>>)new MessageFlowEdge(jamMethodNode, outboundChannelNode, (PsiElement)methodEndpoint.getPsiElement()));
        }
    }

    private SpringBeanPointer<?> findContextBeanChannelForMethod(PsiMethod psiMethod) {
        for (SpringBeanPointer<?> channel : this.messageChannels) {
            CommonSpringBean bean = channel.getSpringBean();
            if (!(bean instanceof ContextJavaBean) || !psiMethod.equals(((ContextJavaBean)bean).getPsiElement())) continue;
            return channel;
        }
        return null;
    }

    private void processEndpoints(CommonSpringModel commonSpringModel, SpringBeanPointer<?> pointer) {
        DiagramNode<SpringElementWrapper<?>> sourceNode;
        if (SpringIntegrationDataModel.isIntegrationBeanPointer(pointer) && (sourceNode = this.getOrCreateElement(pointer, commonSpringModel)) != null) {
            this.processDependencies(pointer, sourceNode, commonSpringModel);
        }
    }

    private void processInterceptors(CommonSpringModel model, SpringBeanPointer<?> pointer) {
        block4: {
            String pattern;
            SpringBeanPointer wiredPointer;
            CommonSpringBean springBean;
            block3: {
                springBean = pointer.getSpringBean();
                if (!(springBean instanceof InterceptorsOwner)) break block3;
                for (WireTap wireTap : ((InterceptorsOwner)springBean).getInterceptors().getWireTaps()) {
                    SpringBeanPointer wiredPointer2 = (SpringBeanPointer)wireTap.getChannel().getValue();
                    if (wiredPointer2 == null || !this.messageChannels.contains(wiredPointer2)) continue;
                    this.addWiredTapDependency(model, pointer, wiredPointer2, wireTap.getChannel().getXmlElement());
                }
                break block4;
            }
            if (!(springBean instanceof WireTap) || (wiredPointer = (SpringBeanPointer)((WireTap)springBean).getChannel().getValue()) == null || !StringUtil.isNotEmpty((String)(pattern = ((WireTap)springBean).getPattern().getStringValue()))) break block4;
            List strings = StringUtil.split((String)pattern, (String)",");
            for (SpringBeanPointer<?> messageChannel : this.messageChannels) {
                String name = messageChannel.getName();
                for (String simplePattern : strings) {
                    if (!SpringIntegrationDataModel.isInterceptorName(name, simplePattern)) continue;
                    this.addWiredTapDependency(model, messageChannel, wiredPointer, ((WireTap)springBean).getChannel().getXmlElement());
                }
            }
        }
    }

    private static boolean isInterceptorName(@Nullable String name, @NotNull String simplePattern) {
        if (simplePattern == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)name) || StringUtil.isEmptyOrSpaces((String)simplePattern)) {
            return false;
        }
        if (name.trim().equals(simplePattern.trim())) {
            return true;
        }
        return SpringIntegrationDataModelUtils.simpleMatch(simplePattern, name);
    }

    private void addWiredTapDependency(CommonSpringModel model, SpringBeanPointer<?> pointer, SpringBeanPointer<?> wiredPointer, XmlElement element) {
        DiagramNode<SpringElementWrapper<?>> source = this.getOrCreateElement(pointer, model);
        DiagramNode<SpringElementWrapper<?>> target = this.getOrCreateElement(wiredPointer, model);
        if (source != null && target != null) {
            this.addEdge((DiagramEdge<SpringElementWrapper<?>>)new MessageFlowEdge(source, target, (PsiElement)element, "wire-tap", true));
        }
    }

    @Nullable
    private static SpringBeanPointer<?> findMessageChannelByName(@NotNull Collection<SpringBeanPointer<?>> messageChannels, @NotNull Collection<SpringIntegrationJamTransformer> transformers, @NotNull String name, Module module) {
        SpringBeanPointer messageChannelPointer;
        if (messageChannels == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(5);
        }
        if (transformers == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(6);
        }
        if (name == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(7);
        }
        if ((messageChannelPointer = (SpringBeanPointer)messageChannels.stream().filter(pointer -> name.equals(pointer.getName())).findFirst().orElse(null)) != null) {
            return messageChannelPointer;
        }
        for (SpringIntegrationJamTransformer transformer : transformers) {
            for (String inboundChannelName : transformer.getInboundChannelNames()) {
                if (!name.equals(inboundChannelName)) continue;
                return SpringIntegrationDataModel.createPointer(name, transformer, module);
            }
        }
        return null;
    }

    @Nullable
    private static SpringBeanPointer<?> createPointer(@NotNull String name, @NotNull SpringIntegrationJamTransformer transformer, @NotNull Module module) {
        SpringImplicitBean implicitBean;
        if (name == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(8);
        }
        if (transformer == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(9);
        }
        if (module == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(10);
        }
        return (implicitBean = SpringImplicitBean.create((Module)module, (String)"", (String)"org.springframework.messaging.MessageChannel", (String)name)) != null ? BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)implicitBean) : null;
    }

    private static boolean isIntegrationBeanPointer(@NotNull SpringBeanPointer<?> pointer) {
        if (pointer == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(11);
        }
        return pointer.isValid() && pointer.getSpringBean() instanceof EndpointDomBean;
    }

    private void processDependencies(@NotNull SpringBeanPointer<?> pointer, @NotNull DiagramNode<SpringElementWrapper<?>> node, CommonSpringModel model) {
        if (pointer == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(12);
        }
        if (node == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(13);
        }
        if (this.isProcessed(node)) {
            return;
        }
        SpringIntegrationDataModel.setProcessed(node);
        CommonSpringBean springBean = pointer.getSpringBean();
        if (springBean instanceof EndpointDomBean) {
            this.addPointedDependencies(node, springBean, model);
        }
    }

    private void addPointedDependencies(final DiagramNode<SpringElementWrapper<?>> sourceNode, CommonSpringBean springBean, final CommonSpringModel model) {
        if (SpringIntegrationDataModel.isCustomSchemaBean(springBean)) {
            ((DomSpringBean)springBean).acceptChildren(new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                    if (element instanceof GenericAttributeValue && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer messageChannelPointer;
                        DiagramNode<SpringElementWrapper<?>> target;
                        Object pointer = ((GenericDomValue)element).getValue();
                        if (pointer instanceof SpringBeanPointer && SpringIntegrationDataModel.this.messageChannels.contains(pointer) && (target = SpringIntegrationDataModel.this.getOrCreateElement(messageChannelPointer = (SpringBeanPointer)pointer, model)) != null) {
                            SpringIntegrationDataModel.this.addEdge(SpringIntegrationDataModel.createIntegrationEdge(sourceNode, target, (GenericAttributeValue)element));
                        }
                    } else {
                        List children = DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true);
                        for (DomElement child : children) {
                            child.accept((DomElementVisitor)this);
                        }
                    }
                }
            });
        }
    }

    private void addEdge(@Nullable DiagramEdge<SpringElementWrapper<?>> edge) {
        if (edge == null) {
            return;
        }
        if (!this.myEdges.contains(edge)) {
            this.myEdges.add(edge);
        }
    }

    private static DiagramEdge<SpringElementWrapper<?>> createIntegrationEdge(DiagramNode<SpringElementWrapper<?>> sourceNode, DiagramNode<SpringElementWrapper<?>> targetNode, GenericAttributeValue identifyingAttributeValue) {
        XmlAttribute xmlAttribute = identifyingAttributeValue.getXmlAttribute();
        if (xmlAttribute == null) {
            return null;
        }
        String attributeName = xmlAttribute.getName();
        if (SpringIntegrationDataModel.isInboundChannel(identifyingAttributeValue, attributeName)) {
            return new MessageFlowEdge(targetNode, sourceNode, (PsiElement)identifyingAttributeValue.getXmlElement());
        }
        if (SpringIntegrationDataModel.isOutBoundChannel(identifyingAttributeValue, attributeName)) {
            return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement());
        }
        if (SpringIntegrationDataModel.isNonStandardOutBoundChannel(attributeName)) {
            return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement(), attributeName);
        }
        return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement(), attributeName, true);
    }

    private static boolean isNonStandardOutBoundChannel(String attributeName) {
        return NON_STANDARD_OUTBOUND_CHANNELS.contains(attributeName);
    }

    private static boolean isOutBoundChannel(GenericAttributeValue identifyingAttributeValue, String attributeName) {
        DomElement parent = identifyingAttributeValue.getParent();
        if (SpringIntegrationCoreIcons.Diagram.OutboundGateway.equals(parent.getPresentation().getIcon())) {
            if (OUTBOUND_GATEWAY_INBOUND.equals(attributeName)) {
                return false;
            }
            if (OUTBOUND_GATEWAY_OUTBOUND.equals(attributeName)) {
                return true;
            }
        }
        boolean inboundAdapter = SpringIntegrationCoreIcons.Diagram.InboundAdapter.equals(parent.getPresentation().getIcon());
        boolean outboundRouter = ROUTER_OUTBOUND_CHANNEL_PARENTS.contains(parent.getXmlElementName());
        return OUTBOUND_CHANNELS.contains(attributeName) || CHANNEL.equals(attributeName) && (outboundRouter || inboundAdapter);
    }

    private static boolean isInboundChannel(GenericAttributeValue identifyingAttributeValue, String attributeName) {
        DomElement parent = identifyingAttributeValue.getParent();
        if (SpringIntegrationCoreIcons.Diagram.OutboundGateway.equals(parent.getPresentation().getIcon())) {
            if (OUTBOUND_GATEWAY_INBOUND.equals(attributeName)) {
                return true;
            }
            if (OUTBOUND_GATEWAY_OUTBOUND.equals(attributeName)) {
                return false;
            }
        }
        boolean outboundAdapter = SpringIntegrationCoreIcons.Diagram.OutboundAdapter.equals(parent.getPresentation().getIcon());
        return INBOUND_CHANNELS.contains(attributeName) || CHANNEL.equals(attributeName) && outboundAdapter;
    }

    private static boolean isCustomSchemaBean(CommonSpringBean springBean) {
        return springBean instanceof DomSpringBean && !(springBean instanceof SpringBean);
    }

    private static void setProcessed(@NotNull DiagramNode<SpringElementWrapper<?>> targetNode) {
        if (targetNode == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(14);
        }
        targetNode.putUserData(PROCESSED_KEY, (Object)true);
    }

    private boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper<?>> targetNode) {
        Boolean isProcessed;
        if (targetNode == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(15);
        }
        return (isProcessed = (Boolean)targetNode.getUserData(PROCESSED_KEY)) != null && isProcessed != false;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper<?>> getOrCreateElement(SpringBeanPointer beanPointer, CommonSpringModel model) {
        DiagramNode<SpringElementWrapper<?>> target = this.getNode(beanPointer);
        if (target == null) {
            target = this.addNode(beanPointer, model);
        }
        return target;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper<?>> getOrCreateElement(SpringIntegrationJamMethodEndpoint jamMethodEndpoint, Module module) {
        DiagramNode<SpringElementWrapper<?>> target = this.getNode(jamMethodEndpoint);
        if (target == null) {
            target = this.addNode(jamMethodEndpoint, module);
        }
        return target;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper<?>> getNode(@NotNull Object bean) {
        if (bean == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(16);
        }
        for (DiagramNode<SpringElementWrapper<?>> node : this.myNodes) {
            if (!bean.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper<?>> addNode(SpringBeanPointer element, CommonSpringModel model) {
        return element == null ? null : this.addNode((SpringElementWrapper)SpringIntegrationBeanPointerWrapper.createIntegrationBeanWrapper(element, model));
    }

    @Nullable
    public DiagramNode<SpringElementWrapper<?>> addNode(SpringIntegrationJamMethodEndpoint element, Module module) {
        return element == null ? null : this.addNode((SpringElementWrapper)SpringIntegrationMessageEndpointWrapper.createMessageEndpointWrapper(element, module));
    }

    @NotNull
    private DiagramNode<SpringElementWrapper<?>> addNode(SpringElementWrapper beanPointerWrapper) {
        SpringIntegrationNode node = new SpringIntegrationNode(beanPointerWrapper, this.getProvider());
        if (!this.myNodes.contains((Object)node)) {
            this.myNodes.add((DiagramNode<SpringElementWrapper<?>>)node);
        }
        SpringIntegrationNode springIntegrationNode = node;
        if (springIntegrationNode == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(17);
        }
        return springIntegrationNode;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        DomManager domManager = DomManager.getDomManager((Project)this.getProject());
        if (domManager == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(18);
        }
        return domManager;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/diagram/SpringIntegrationDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simplePattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageChannels";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformers";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/diagram/SpringIntegrationDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addNode";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInterceptorName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMessageChannelByName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIntegrationBeanPointer";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setProcessed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isProcessed";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

