/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.integration.SpringIntegrationCoreIcons;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringIntegrationBeanPointerWrapper
extends SpringBeanPointerWrapper {
    private static final List<Pair<String, Icon>> byClass = Arrays.asList(Pair.create((Object)"org.springframework.integration.transformer.Transformer", (Object)SpringIntegrationCoreIcons.Diagram.Transformer), Pair.create((Object)"org.springframework.integration.gateway.MessagingGatewaySupport", (Object)SpringIntegrationCoreIcons.Diagram.InboundGateway));
    private static final List<Pair<String, Icon>> byName = Arrays.asList(Pair.create((Object)"InboundGateway", (Object)SpringIntegrationCoreIcons.Diagram.InboundGateway), Pair.create((Object)"OutboundGateway", (Object)SpringIntegrationCoreIcons.Diagram.OutboundGateway));

    private SpringIntegrationBeanPointerWrapper(@NotNull SpringBeanPointer<?> pointer, CommonSpringModel model) {
        if (pointer == null) {
            SpringIntegrationBeanPointerWrapper.$$$reportNull$$$0(0);
        }
        super(pointer, model);
    }

    public static SpringIntegrationBeanPointerWrapper createIntegrationBeanWrapper(SpringBeanPointer pointer, CommonSpringModel model) {
        return new SpringIntegrationBeanPointerWrapper(pointer, model);
    }

    public String getName() {
        return "";
    }

    public Icon getIcon() {
        SpringBeanPointer wrapped = (SpringBeanPointer)this.getWrapped();
        if (wrapped.isValid()) {
            CommonSpringBean bean = wrapped.getSpringBean();
            if (bean instanceof DomSpringBean) {
                return ((DomSpringBean)bean).getPresentation().getIcon();
            }
            PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType());
            if (beanClass != null) {
                if (InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"org.springframework.messaging.MessageChannel")) {
                    return SpringIntegrationCoreIcons.Diagram.Channel;
                }
                if (bean instanceof SpringJavaBean) {
                    Icon icon = SpringIntegrationBeanPointerWrapper.getEndpointIcon((SpringJavaBean)bean);
                    if (icon != null) {
                        return icon;
                    }
                    String className = beanClass.getQualifiedName();
                    if (StringUtil.isNotEmpty((String)className)) {
                        for (Pair<String, Icon> pair : byName) {
                            if (!className.contains((CharSequence)pair.first)) continue;
                            return (Icon)pair.second;
                        }
                    }
                    for (Pair<String, Icon> pair : byClass) {
                        if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)((String)pair.first))) continue;
                        return (Icon)pair.second;
                    }
                }
            }
        }
        return super.getIcon();
    }

    @Nullable
    private static Icon getEndpointIcon(SpringJavaBean bean) {
        PsiMethod method = bean.getPsiElement();
        for (SpringIntegrationJamMethodEndpoint endpoint : SemService.getSemService((Project)method.getProject()).getSemElements(SpringIntegrationJamMethodEndpoint.ENDPOINT_JAM_KEY, (PsiElement)method)) {
            Icon icon = ElementPresentationManager.getIcon((Object)endpoint);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/integration/diagram/SpringIntegrationBeanPointerWrapper", "<init>"));
    }
}

