/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.CodeBuilderKt;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.CatchStatement;
import org.jetbrains.kotlin.j2k.ast.Statement;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/TryStatement;", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "block", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "catches", "", "Lorg/jetbrains/kotlin/j2k/ast/CatchStatement;", "finallyBlock", "(Lorg/jetbrains/kotlin/j2k/ast/Block;Ljava/util/List;Lorg/jetbrains/kotlin/j2k/ast/Block;)V", "getBlock", "()Lorg/jetbrains/kotlin/j2k/ast/Block;", "getCatches", "()Ljava/util/List;", "getFinallyBlock", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.old"})
public final class TryStatement
extends Statement {
    @NotNull
    private final Block block;
    @NotNull
    private final List<CatchStatement> catches;
    @NotNull
    private final Block finallyBlock;

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        CodeBuilderKt.appendElements$default(builder.append("try\n").append(this.block).append("\n"), this.catches, "\n", null, null, 12, null).append("\n");
        if (!this.finallyBlock.isEmpty()) {
            builder.append("finally\n").append(this.finallyBlock);
        }
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public final List<CatchStatement> getCatches() {
        return this.catches;
    }

    @NotNull
    public final Block getFinallyBlock() {
        return this.finallyBlock;
    }

    public TryStatement(@NotNull Block block, @NotNull List<CatchStatement> catches, @NotNull Block finallyBlock) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(catches, (String)"catches");
        Intrinsics.checkNotNullParameter((Object)finallyBlock, (String)"finallyBlock");
        this.block = block;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
    }
}

