/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiMethodUtil;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.ReferenceSearcherKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.LiteralExpression;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.Mutability;
import org.jetbrains.kotlin.j2k.ast.PrimitiveType;
import org.jetbrains.kotlin.j2k.ast.Property;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0002*\u00020\u0017\u001a\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u000e*\u00020 \u001a\f\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u000e\u001a\f\u0010#\u001a\u0004\u0018\u00010$*\u00020\u000e\u001a\f\u0010%\u001a\u0004\u0018\u00010$*\u00020\u000e\u001a\n\u0010&\u001a\u00020\f*\u00020'\u001a\u0012\u0010(\u001a\u00020\f*\u00020'2\u0006\u0010)\u001a\u00020*\u001a\n\u0010+\u001a\u00020\f*\u00020\u000e\u001a\n\u0010,\u001a\u00020\f*\u00020$\u001a\n\u0010-\u001a\u00020\f*\u00020.\u001a\u0012\u0010/\u001a\u00020\f*\u00020 2\u0006\u00100\u001a\u00020\"\u001a\n\u00101\u001a\u00020\f*\u00020 \u001a\f\u00102\u001a\u0004\u0018\u00010\u000e*\u000203\u001a\f\u00104\u001a\u0004\u0018\u00010\u000e*\u000203\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\u00a8\u00065"}, d2={"toKotlinMutableTypesMap", "", "", "getToKotlinMutableTypesMap", "()Ljava/util/Map;", "toKotlinTypesMap", "getToKotlinTypesMap", "getDefaultInitializer", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "property", "Lorg/jetbrains/kotlin/j2k/ast/Property;", "isFacadeClassFromLibrary", "", "element", "Lcom/intellij/psi/PsiElement;", "quoteKeywords", "packageName", "shouldGenerateDefaultInitializer", "searcher", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "field", "Lcom/intellij/psi/PsiField;", "accessModifier", "Lcom/intellij/psi/PsiModifierListOwner;", "convertToKotlinAnalog", "Lorg/jetbrains/kotlin/j2k/Converter;", "classQualifiedName", "mutability", "Lorg/jetbrains/kotlin/j2k/ast/Mutability;", "convertToKotlinAnalogIdentifier", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "dot", "Lcom/intellij/psi/PsiReferenceExpression;", "getContainingClass", "Lcom/intellij/psi/PsiClass;", "getContainingConstructor", "Lcom/intellij/psi/PsiMethod;", "getContainingMethod", "isConstructor", "Lcom/intellij/psi/PsiMember;", "isImported", "file", "Lcom/intellij/psi/PsiJavaFile;", "isInSingleLine", "isMainMethod", "isNullLiteral", "Lcom/intellij/psi/PsiExpression;", "isQualifierEmptyOrClass", "psiClass", "isQualifierEmptyOrThis", "lPar", "Lcom/intellij/psi/PsiExpressionList;", "rPar", "kotlin.j2k.old"})
public final class UtilsKt {
    @NotNull
    private static final Map<String, String> toKotlinTypesMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.lang.Object", (Object)StandardNames.FqNames.any.asString()), TuplesKt.to((Object)"java.lang.Byte", (Object)StandardNames.FqNames._byte.asString()), TuplesKt.to((Object)"java.lang.Character", (Object)StandardNames.FqNames._char.asString()), TuplesKt.to((Object)"java.lang.Double", (Object)StandardNames.FqNames._double.asString()), TuplesKt.to((Object)"java.lang.Float", (Object)StandardNames.FqNames._float.asString()), TuplesKt.to((Object)"java.lang.Integer", (Object)StandardNames.FqNames._int.asString()), TuplesKt.to((Object)"java.lang.Long", (Object)StandardNames.FqNames._long.asString()), TuplesKt.to((Object)"java.lang.Short", (Object)StandardNames.FqNames._short.asString()), TuplesKt.to((Object)"java.lang.Boolean", (Object)StandardNames.FqNames._boolean.asString()), TuplesKt.to((Object)"java.lang.Iterable", (Object)StandardNames.FqNames.iterable.asString()), TuplesKt.to((Object)"java.util.Iterator", (Object)StandardNames.FqNames.iterator.asString()), TuplesKt.to((Object)"java.util.List", (Object)StandardNames.FqNames.list.asString()), TuplesKt.to((Object)"java.util.Collection", (Object)StandardNames.FqNames.collection.asString()), TuplesKt.to((Object)"java.util.Set", (Object)StandardNames.FqNames.set.asString()), TuplesKt.to((Object)"java.util.Map", (Object)StandardNames.FqNames.map.asString()), TuplesKt.to((Object)"java.util.Map.Entry", (Object)StandardNames.FqNames.mapEntry.asString()), TuplesKt.to((Object)ListIterator.class.getCanonicalName(), (Object)StandardNames.FqNames.listIterator.asString())});
    @NotNull
    private static final Map<String, String> toKotlinMutableTypesMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.util.Iterator", (Object)StandardNames.FqNames.mutableIterator.asString()), TuplesKt.to((Object)"java.util.List", (Object)StandardNames.FqNames.mutableList.asString()), TuplesKt.to((Object)"java.util.Collection", (Object)StandardNames.FqNames.mutableCollection.asString()), TuplesKt.to((Object)"java.util.Set", (Object)StandardNames.FqNames.mutableSet.asString()), TuplesKt.to((Object)"java.util.Map", (Object)StandardNames.FqNames.mutableMap.asString()), TuplesKt.to((Object)"java.util.Map.Entry", (Object)StandardNames.FqNames.mutableMapEntry.asString()), TuplesKt.to((Object)ListIterator.class.getCanonicalName(), (Object)StandardNames.FqNames.mutableListIterator.asString())});

    @NotNull
    public static final String quoteKeywords(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)packageName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, (Function1)quoteKeywords.1.INSTANCE, (int)30, null);
    }

    @Nullable
    public static final Expression getDefaultInitializer(@NotNull Property property2) {
        Expression result;
        Expression expression;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Type t = property2.getType();
        if (t.isNullable()) {
            expression = new LiteralExpression("null");
        } else if (t instanceof PrimitiveType) {
            switch (((PrimitiveType)t).getName().getName()) {
                case "Boolean": {
                    expression = new LiteralExpression("false");
                    break;
                }
                case "Char": {
                    expression = new LiteralExpression("' '");
                    break;
                }
                case "Double": {
                    Expression expression2 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                    String string = OperatorConventions.DOUBLE.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OperatorConventions.DOUBLE.toString()");
                    expression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression2, string, null, null, null, 28, null);
                    break;
                }
                case "Float": {
                    Expression expression3 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                    String string = OperatorConventions.FLOAT.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OperatorConventions.FLOAT.toString()");
                    expression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression3, string, null, null, null, 28, null);
                    break;
                }
                default: {
                    expression = new LiteralExpression("0");
                    break;
                }
            }
        } else {
            expression = null;
        }
        Expression expression4 = result = expression;
        return expression4 != null ? (Expression)ElementKt.assignNoPrototype((Element)expression4) : null;
    }

    public static final boolean shouldGenerateDefaultInitializer(@NotNull ReferenceSearcher searcher, @NotNull PsiField field) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return field.getInitializer() == null && (ReferenceSearcherKt.isVar(field, searcher) || !ReferenceSearcherKt.hasWriteAccesses((PsiVariable)field, searcher, (PsiElement)field.getContainingClass()));
    }

    public static final boolean isQualifierEmptyOrThis(@NotNull PsiReferenceExpression $this$isQualifierEmptyOrThis) {
        Intrinsics.checkNotNullParameter((Object)$this$isQualifierEmptyOrThis, (String)"$this$isQualifierEmptyOrThis");
        PsiExpression qualifier = $this$isQualifierEmptyOrThis.getQualifierExpression();
        return qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null;
    }

    public static final boolean isQualifierEmptyOrClass(@NotNull PsiReferenceExpression $this$isQualifierEmptyOrClass, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isQualifierEmptyOrClass, (String)"$this$isQualifierEmptyOrClass");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        PsiExpression qualifier = $this$isQualifierEmptyOrClass.getQualifierExpression();
        return qualifier == null || qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)psiClass);
    }

    public static final boolean isInSingleLine(@NotNull PsiElement $this$isInSingleLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isInSingleLine, (String)"$this$isInSingleLine");
        if ($this$isInSingleLine instanceof PsiWhiteSpace) {
            String string = ((PsiWhiteSpace)$this$isInSingleLine).getText();
            Intrinsics.checkNotNull((Object)string);
            String text2 = string;
            return StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)0, (boolean)false, (int)6, null) < 0 && StringsKt.indexOf$default((CharSequence)text2, (char)'\r', (int)0, (boolean)false, (int)6, null) < 0;
        }
        for (PsiElement child = $this$isInSingleLine.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (UtilsKt.isInSingleLine(child)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static final PsiMethod getContainingMethod(@NotNull PsiElement $this$getContainingMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingMethod, (String)"$this$getContainingMethod");
        PsiElement context = $this$getContainingMethod.getContext();
        while (context != null) {
            PsiElement _context = context;
            if (_context instanceof PsiMethod) {
                return (PsiMethod)_context;
            }
            context = _context.getContext();
        }
        return null;
    }

    @Nullable
    public static final PsiClass getContainingClass(@NotNull PsiElement $this$getContainingClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingClass, (String)"$this$getContainingClass");
        PsiElement context = $this$getContainingClass.getContext();
        while (context != null) {
            PsiElement _context = context;
            if (_context instanceof PsiClass) {
                return (PsiClass)_context;
            }
            if (_context instanceof PsiMember) {
                return ((PsiMember)_context).getContainingClass();
            }
            context = _context.getContext();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final PsiMethod getContainingConstructor(@NotNull PsiElement $this$getContainingConstructor) {
        PsiMethod method;
        Intrinsics.checkNotNullParameter((Object)$this$getContainingConstructor, (String)"$this$getContainingConstructor");
        PsiMethod psiMethod = method = UtilsKt.getContainingMethod($this$getContainingConstructor);
        if (psiMethod == null) return null;
        if (!psiMethod.isConstructor()) return null;
        PsiMethod psiMethod2 = method;
        return psiMethod2;
    }

    public static final boolean isConstructor(@NotNull PsiMember $this$isConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$isConstructor, (String)"$this$isConstructor");
        return $this$isConstructor instanceof PsiMethod && ((PsiMethod)$this$isConstructor).isConstructor();
    }

    @NotNull
    public static final String accessModifier(@NotNull PsiModifierListOwner $this$accessModifier) {
        Intrinsics.checkNotNullParameter((Object)$this$accessModifier, (String)"$this$accessModifier");
        return $this$accessModifier.hasModifierProperty("public") ? "public" : ($this$accessModifier.hasModifierProperty("private") ? "private" : ($this$accessModifier.hasModifierProperty("protected") ? "protected" : "packageLocal"));
    }

    public static final boolean isMainMethod(@NotNull PsiMethod $this$isMainMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isMainMethod, (String)"$this$isMainMethod");
        return PsiMethodUtil.isMainMethod((PsiMethod)$this$isMainMethod);
    }

    @Nullable
    public static final PsiElement dot(@NotNull PsiReferenceExpression $this$dot) {
        Intrinsics.checkNotNullParameter((Object)$this$dot, (String)"$this$dot");
        ASTNode aSTNode = $this$dot.getNode().findChildByType(JavaTokenType.DOT);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement lPar(@NotNull PsiExpressionList $this$lPar) {
        Intrinsics.checkNotNullParameter((Object)$this$lPar, (String)"$this$lPar");
        ASTNode aSTNode = $this$lPar.getNode().findChildByType(JavaTokenType.LPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement rPar(@NotNull PsiExpressionList $this$rPar) {
        Intrinsics.checkNotNullParameter((Object)$this$rPar, (String)"$this$rPar");
        ASTNode aSTNode = $this$rPar.getNode().findChildByType(JavaTokenType.RPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isImported(@NotNull PsiMember $this$isImported, @NotNull PsiJavaFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$isImported, (String)"$this$isImported");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if ($this$isImported instanceof PsiClass) {
            String string;
            int index;
            String fqName;
            String string2 = fqName = ((PsiClass)$this$isImported).getQualifiedName();
            int n = index = string2 != null ? StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null) : -1;
            if (index >= 0) {
                String string3 = fqName;
                Intrinsics.checkNotNull((Object)string3);
                String string4 = string3;
                int n2 = 0;
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, index);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = null;
            }
            String parentName = string;
            PsiImportStatementBase[] psiImportStatementBaseArray = file.getImportList();
            PsiImportStatementBase[] psiImportStatementBaseArray2 = psiImportStatementBaseArray;
            if (psiImportStatementBaseArray == null) return false;
            PsiImportStatementBase[] psiImportStatementBaseArray3 = psiImportStatementBaseArray2.getAllImportStatements();
            psiImportStatementBaseArray2 = psiImportStatementBaseArray3;
            if (psiImportStatementBaseArray3 == null) return false;
            PsiImportStatementBase[] $this$any$iv = psiImportStatementBaseArray2;
            boolean $i$f$any = false;
            PsiImportStatementBase[] psiImportStatementBaseArray4 = $this$any$iv;
            int n3 = psiImportStatementBaseArray4.length;
            int n4 = 0;
            while (n4 < n3) {
                PsiImportStatementBase element$iv;
                PsiImportStatementBase it = element$iv = psiImportStatementBaseArray4[n4];
                boolean bl = false;
                PsiImportStatementBase psiImportStatementBase = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiImportStatementBase, (String)"it");
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = psiImportStatementBase.getImportReference();
                if (Intrinsics.areEqual((Object)(psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getQualifiedName() : null), (Object)(it.isOnDemand() ? parentName : fqName))) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        if ($this$isImported.getContainingClass() == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray = file.getImportList();
        PsiImportStaticStatement[] psiImportStaticStatementArray2 = psiImportStaticStatementArray;
        if (psiImportStaticStatementArray == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray3 = psiImportStaticStatementArray2.getImportStaticStatements();
        psiImportStaticStatementArray2 = psiImportStaticStatementArray3;
        if (psiImportStaticStatementArray3 == null) return false;
        PsiImportStaticStatement[] $this$any$iv = psiImportStaticStatementArray2;
        boolean $i$f$any = false;
        PsiImportStaticStatement[] psiImportStaticStatementArray4 = $this$any$iv;
        int n = psiImportStaticStatementArray4.length;
        int n5 = 0;
        while (n5 < n) {
            PsiImportStaticStatement element$iv;
            PsiImportStaticStatement it = element$iv = psiImportStaticStatementArray4[n5];
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.resolveTargetClass(), (Object)$this$isImported.getContainingClass())) {
                PsiImportStaticStatement psiImportStaticStatement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiImportStaticStatement, (String)"it");
                if (psiImportStaticStatement.isOnDemand()) return true;
                if (Intrinsics.areEqual((Object)it.getReferenceName(), (Object)$this$isImported.getName())) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public static final boolean isNullLiteral(@NotNull PsiExpression $this$isNullLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullLiteral, (String)"$this$isNullLiteral");
        return $this$isNullLiteral instanceof PsiLiteralExpression && Intrinsics.areEqual((Object)((PsiLiteralExpression)$this$isNullLiteral).getType(), (Object)PsiType.NULL);
    }

    public static final boolean isFacadeClassFromLibrary(@Nullable PsiElement element) {
        return element instanceof KtLightClass && ((KtLightClass)element).getKotlinOrigin() == null;
    }

    @Nullable
    public static final String convertToKotlinAnalog(@NotNull Converter $this$convertToKotlinAnalog, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkNotNullParameter((Object)$this$convertToKotlinAnalog, (String)"$this$convertToKotlinAnalog");
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        if (classQualifiedName == null) {
            return null;
        }
        String string = TypesKt.isMutable(mutability, $this$convertToKotlinAnalog.getSettings()) ? toKotlinMutableTypesMap.get(classQualifiedName) : null;
        if (string == null) {
            string = toKotlinTypesMap.get(classQualifiedName);
        }
        return string;
    }

    @Nullable
    public static final Identifier convertToKotlinAnalogIdentifier(@NotNull Converter $this$convertToKotlinAnalogIdentifier, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkNotNullParameter((Object)$this$convertToKotlinAnalogIdentifier, (String)"$this$convertToKotlinAnalogIdentifier");
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        String string = UtilsKt.convertToKotlinAnalog($this$convertToKotlinAnalogIdentifier, classQualifiedName, mutability);
        if (string == null) {
            return null;
        }
        String kotlinClassName = string;
        return Identifier.Companion.withNoPrototype$default(Identifier.Companion, StringsKt.substringAfterLast$default((String)kotlinClassName, (char)'.', null, (int)2, null), false, false, null, 14, null);
    }

    @NotNull
    public static final Map<String, String> getToKotlinTypesMap() {
        return toKotlinTypesMap;
    }

    @NotNull
    public static final Map<String, String> getToKotlinMutableTypesMap() {
        return toKotlinMutableTypesMap;
    }
}

