/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactInfoGroup;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.GroupedSearchRequest;
import org.sonatype.nexus.index.GroupedSearchResponse;
import org.sonatype.nexus.index.Grouping;
import org.sonatype.nexus.index.SearchEngine;
import org.sonatype.nexus.index.context.IndexUtils;
import org.sonatype.nexus.index.context.IndexingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=SearchEngine.class)
public class DefaultSearchEngine
extends AbstractLogEnabled
implements SearchEngine {
    @Override
    @Deprecated
    public Set<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, IndexingContext indexingContext, Query query) throws IOException {
        return this.searchFlatPaged(new FlatSearchRequest(query, artifactInfoComparator, indexingContext)).getResults();
    }

    @Override
    @Deprecated
    public Set<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, Collection<IndexingContext> indexingContexts, Query query) throws IOException {
        return this.searchFlatPaged(new FlatSearchRequest(query, artifactInfoComparator), indexingContexts).getResults();
    }

    @Override
    public FlatSearchResponse searchFlatPaged(FlatSearchRequest request) throws IOException {
        TreeSet<ArtifactInfo> result = new TreeSet<ArtifactInfo>(request.getArtifactInfoComparator());
        int totalHits = this.searchFlat(result, request.getContext(), request.getQuery(), request.getStart(), request.getAiCount());
        return new FlatSearchResponse(request.getQuery(), totalHits, result);
    }

    @Override
    public FlatSearchResponse searchFlatPaged(FlatSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        TreeSet<ArtifactInfo> result = new TreeSet<ArtifactInfo>(request.getArtifactInfoComparator());
        int totalHits = 0;
        for (IndexingContext ctx : indexingContexts) {
            if (!ctx.isSearchable()) continue;
            totalHits += this.searchFlat(result, ctx, request.getQuery(), request.getStart(), request.getAiCount());
        }
        return new FlatSearchResponse(request.getQuery(), totalHits, result);
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request) throws IOException {
        TreeMap<String, ArtifactInfoGroup> result = new TreeMap<String, ArtifactInfoGroup>(request.getGroupKeyComparator());
        int totalHits = this.searchGrouped(result, request.getGrouping(), request.getContext(), request.getQuery());
        return new GroupedSearchResponse(request.getQuery(), totalHits, result);
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        TreeMap<String, ArtifactInfoGroup> result = new TreeMap<String, ArtifactInfoGroup>(request.getGroupKeyComparator());
        int totalHits = 0;
        for (IndexingContext ctx : indexingContexts) {
            if (!ctx.isSearchable()) continue;
            totalHits += this.searchGrouped(result, request.getGrouping(), ctx, request.getQuery());
        }
        return new GroupedSearchResponse(request.getQuery(), totalHits, result);
    }

    protected int searchFlat(Collection<ArtifactInfo> result, IndexingContext context, Query query, int from, int aiCount) throws IOException {
        Hits hits = context.getIndexSearcher().search(query, new Sort(new SortField("u", 3)));
        if (hits == null || hits.length() == 0) {
            return 0;
        }
        int hitCount = hits.length();
        int start = from == FlatSearchRequest.UNDEFINED ? 0 : from;
        int found = 0;
        for (int i = start; i < hits.length(); ++i) {
            Document doc = hits.doc(i);
            ArtifactInfo artifactInfo = IndexUtils.constructArtifactInfo(doc, context);
            if (artifactInfo == null) continue;
            artifactInfo.repository = context.getRepositoryId();
            artifactInfo.context = context.getId();
            if (result.add(artifactInfo)) {
                ++found;
            } else {
                --hitCount;
            }
            if (found == aiCount) break;
        }
        return hitCount;
    }

    protected int searchGrouped(Map<String, ArtifactInfoGroup> result, Grouping grouping, IndexingContext context, Query query) throws IOException {
        Hits hits = context.getIndexSearcher().search(query, new Sort(new SortField("u", 3)));
        if (hits != null && hits.length() != 0) {
            int hitCount = hits.length();
            for (int i = 0; i < hits.length(); ++i) {
                ArtifactInfo artifactInfo = IndexUtils.constructArtifactInfo(hits.doc(i), context);
                if (artifactInfo == null) continue;
                artifactInfo.repository = context.getRepositoryId();
                artifactInfo.context = context.getId();
                if (grouping.addArtifactInfo(result, artifactInfo)) continue;
                --hitCount;
            }
            return hitCount;
        }
        return 0;
    }
}

