/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.util.CachedAliasImportData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0007\u001a\u0018\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006H\u0002\u001a\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n*\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u000e\u001a\f\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ALIAS_IMPORT_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/util/CachedAliasImportData;", "aliasImportMap", "Lcom/google/common/collect/Multimap;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "buildAliasImportMap", "getContainingFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "Lcom/intellij/psi/stubs/StubElement;", "isProbablyNothing", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.common"})
public final class TypeIndexUtilKt {
    private static final Key<CachedAliasImportData> ALIAS_IMPORT_DATA_KEY = new Key("ALIAS_IMPORT_MAP_KEY");

    @NotNull
    public static final Multimap<String, String> aliasImportMap(@NotNull KtUserType $this$aliasImportMap) {
        PsiFile file;
        Intrinsics.checkNotNullParameter((Object)$this$aliasImportMap, (String)"$this$aliasImportMap");
        PsiFile psiFile = (PsiFile)$this$aliasImportMap.getStub();
        if (psiFile == null || (psiFile = TypeIndexUtilKt.getContainingFileStub((StubElement)psiFile)) == null || (psiFile = (PsiFile)psiFile.getPsi()) == null) {
            HashMultimap hashMultimap = HashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"HashMultimap.create()");
            return (Multimap)hashMultimap;
        }
        PsiFile psiFile2 = file = psiFile;
        if (psiFile2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return TypeIndexUtilKt.aliasImportMap((KtFile)psiFile2);
    }

    @NotNull
    public static final Multimap<String, String> aliasImportMap(@NotNull KtFile $this$aliasImportMap) {
        Intrinsics.checkNotNullParameter((Object)$this$aliasImportMap, (String)"$this$aliasImportMap");
        CachedAliasImportData cached = (CachedAliasImportData)$this$aliasImportMap.getUserData(ALIAS_IMPORT_DATA_KEY);
        long modificationStamp = $this$aliasImportMap.getModificationStamp();
        if (cached != null && modificationStamp == cached.getFileModificationStamp()) {
            return cached.getMap();
        }
        CachedAliasImportData data = new CachedAliasImportData(TypeIndexUtilKt.buildAliasImportMap($this$aliasImportMap), modificationStamp);
        $this$aliasImportMap.putUserData(ALIAS_IMPORT_DATA_KEY, (Object)data);
        return data.getMap();
    }

    private static final Multimap<String, String> buildAliasImportMap(KtFile $this$buildAliasImportMap) {
        HashMultimap map = HashMultimap.create();
        KtImportList ktImportList = $this$buildAliasImportMap.getImportList();
        if (ktImportList == null) {
            HashMultimap hashMultimap = map;
            Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"map");
            return (Multimap)hashMultimap;
        }
        KtImportList importList = ktImportList;
        for (KtImportDirective ktImportDirective : importList.getImports()) {
            String aliasName;
            if (ktImportDirective.getAliasName() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)aliasName, (String)"import.aliasName ?: continue");
            KtImportDirective ktImportDirective2 = ktImportDirective;
            Intrinsics.checkNotNullExpressionValue((Object)ktImportDirective2, (String)"import");
            Object object = ktImportDirective2.getImportPath();
            if (object == null || (object = object.getFqName()) == null || (object = object.shortName()) == null || (object = object.asString()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"import.importPath?.fqNam\u2026)?.asString() ?: continue");
            Object name = object;
            map.put((Object)aliasName, name);
        }
        HashMultimap hashMultimap = map;
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"map");
        return (Multimap)hashMultimap;
    }

    public static final boolean isProbablyNothing(@Nullable KtTypeReference $this$isProbablyNothing) {
        KtTypeReference ktTypeReference = $this$isProbablyNothing;
        Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (!(object instanceof KtUserType)) {
            object = null;
        }
        KtUserType ktUserType = (KtUserType)object;
        if (ktUserType == null) {
            return false;
        }
        KtUserType userType = ktUserType;
        return TypeIndexUtilKt.isProbablyNothing(userType);
    }

    public static final boolean isProbablyNothing(@Nullable KtUserType $this$isProbablyNothing) {
        if ($this$isProbablyNothing == null) {
            return false;
        }
        String referencedName = $this$isProbablyNothing.getReferencedName();
        return Intrinsics.areEqual((Object)referencedName, (Object)"Nothing") || TypeIndexUtilKt.aliasImportMap($this$isProbablyNothing).get((Object)referencedName).contains("Nothing");
    }

    private static final PsiFileStub<?> getContainingFileStub(StubElement<?> $this$getContainingFileStub) {
        PsiFileStub<?> psiFileStub;
        if ($this$getContainingFileStub instanceof PsiFileStub) {
            psiFileStub = (PsiFileStub<?>)$this$getContainingFileStub;
        } else {
            StubElement stubElement = $this$getContainingFileStub.getParentStub();
            Intrinsics.checkNotNullExpressionValue((Object)stubElement, (String)"parentStub");
            psiFileStub = TypeIndexUtilKt.getContainingFileStub(stubElement);
        }
        return psiFileStub;
    }
}

