/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util.psi.patternMatching;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiRangeKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifier;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.UnificationResult;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\u0015\u0016J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\bH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange;", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "getElements", "()Ljava/util/List;", "empty", "", "getEmpty", "()Z", "contains", "element", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "isValid", "match", "Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/UnificationResult$Matched;", "scope", "unifier", "Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiUnifier;", "Empty", "ListRange", "kotlin.common"})
public interface KotlinPsiRange {
    @NotNull
    public List<PsiElement> getElements();

    @NotNull
    public TextRange getTextRange();

    public boolean isValid();

    public boolean getEmpty();

    public boolean contains(@NotNull PsiElement var1);

    @NotNull
    public List<UnificationResult.Matched> match(@NotNull PsiElement var1, @NotNull KotlinPsiUnifier var2);

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange$Empty;", "Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange;", "()V", "elements", "", "Lcom/intellij/psi/PsiElement;", "getElements", "()Ljava/util/List;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "kotlin.common"})
    public static final class Empty
    implements KotlinPsiRange {
        @NotNull
        public static final Empty INSTANCE;

        @Override
        @NotNull
        public List<PsiElement> getElements() {
            List<PsiElement> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList<PsiElement>()");
            return list;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.EMPTY_RANGE");
            return textRange;
        }

        private Empty() {
        }

        static {
            Empty empty;
            INSTANCE = empty = new Empty();
        }

        @Override
        public boolean isValid() {
            return DefaultImpls.isValid(this);
        }

        @Override
        public boolean getEmpty() {
            return DefaultImpls.getEmpty(this);
        }

        @Override
        public boolean contains(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return DefaultImpls.contains(this, element);
        }

        @Override
        @NotNull
        public List<UnificationResult.Matched> match(@NotNull PsiElement scope, @NotNull KotlinPsiUnifier unifier) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)unifier, (String)"unifier");
            return DefaultImpls.match(this, scope, unifier);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange$ListRange;", "Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "endElement", "getEndElement", "()Lcom/intellij/psi/PsiElement;", "startElement", "getStartElement", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "kotlin.common"})
    public static final class ListRange
    implements KotlinPsiRange {
        @NotNull
        private final PsiElement startElement;
        @NotNull
        private final PsiElement endElement;
        @NotNull
        private final List<PsiElement> elements;

        @NotNull
        public final PsiElement getStartElement() {
            return this.startElement;
        }

        @NotNull
        public final PsiElement getEndElement() {
            return this.endElement;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange startRange = this.startElement.getTextRange();
            TextRange endRange = this.endElement.getTextRange();
            if (startRange == null || endRange == null) {
                TextRange textRange = TextRange.EMPTY_RANGE;
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.EMPTY_RANGE");
                return textRange;
            }
            return new TextRange(startRange.getStartOffset(), endRange.getEndOffset());
        }

        @Override
        @NotNull
        public List<PsiElement> getElements() {
            return this.elements;
        }

        public ListRange(@NotNull List<? extends PsiElement> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.elements = elements;
            this.startElement = (PsiElement)CollectionsKt.first(this.getElements());
            this.endElement = (PsiElement)CollectionsKt.last(this.getElements());
        }

        @Override
        public boolean isValid() {
            return DefaultImpls.isValid(this);
        }

        @Override
        public boolean getEmpty() {
            return DefaultImpls.getEmpty(this);
        }

        @Override
        public boolean contains(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return DefaultImpls.contains(this, element);
        }

        @Override
        @NotNull
        public List<UnificationResult.Matched> match(@NotNull PsiElement scope, @NotNull KotlinPsiUnifier unifier) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)unifier, (String)"unifier");
            return DefaultImpls.match(this, scope, unifier);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static boolean isValid(@NotNull KotlinPsiRange $this) {
            boolean bl;
            block3: {
                Iterable $this$all$iv = $this.getElements();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (it.isValid()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public static boolean getEmpty(@NotNull KotlinPsiRange $this) {
            return $this instanceof Empty;
        }

        public static boolean contains(@NotNull KotlinPsiRange $this, @NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TextRange textRange = $this.getTextRange();
            TextRange textRange2 = element.getTextRange();
            if (textRange2 == null) {
                textRange2 = TextRange.EMPTY_RANGE;
            }
            return textRange.contains(textRange2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<UnificationResult.Matched> match(@NotNull KotlinPsiRange $this, @NotNull PsiElement scope, @NotNull KotlinPsiUnifier unifier) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)unifier, (String)"unifier");
            Iterable iterable = $this.getElements();
            Function1 predicate$iv = KotlinPsiRangeKt.access$getSIGNIFICANT_FILTER$p();
            boolean $i$f$filter = false;
            void var7_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List elements = (List)destination$iv$iv;
            if (elements.isEmpty()) {
                List<UnificationResult.Matched> list = Collections.emptyList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList()");
                return list;
            }
            ArrayList matches = new ArrayList();
            scope.accept((PsiElementVisitor)new KtTreeVisitorVoid($this, elements, unifier, matches){
                final /* synthetic */ KotlinPsiRange this$0;
                final /* synthetic */ List $elements;
                final /* synthetic */ KotlinPsiUnifier $unifier;
                final /* synthetic */ ArrayList $matches;

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    KotlinPsiRange range = KotlinPsiRangeKt.toRange$default(SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings$default((PsiElement)((PsiElement)element), (boolean)false, (boolean)false, (int)3, null), (Function1)KotlinPsiRangeKt.access$getSIGNIFICANT_FILTER$p()), (int)this.$elements.size())), false, 1, null);
                    UnificationResult result = this.$unifier.unify(range, this.this$0);
                    if (result instanceof UnificationResult.StronglyMatched) {
                        this.$matches.add(result);
                    } else {
                        int matchCountSoFar = this.$matches.size();
                        super.visitKtElement(element);
                        if (result instanceof UnificationResult.WeaklyMatched && this.$matches.size() == matchCountSoFar) {
                            this.$matches.add(result);
                        }
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$elements = $captured_local_variable$1;
                    this.$unifier = $captured_local_variable$2;
                    this.$matches = $captured_local_variable$3;
                }
            });
            return matches;
        }
    }
}

