/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.artifacts;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.PathManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.kotlin.idea.artifacts.LibraryFileKind;
import org.jetbrains.kotlin.idea.artifacts.RepoLocation;
import org.jetbrains.kotlin.idea.artifacts.UtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0000\u001a(\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002\"!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"remoteMavenRepositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "getRemoteMavenRepositories", "()Ljava/util/List;", "remoteMavenRepositories$delegate", "Lkotlin/Lazy;", "findLibrary", "Ljava/io/File;", "repoLocation", "Lorg/jetbrains/kotlin/idea/artifacts/RepoLocation;", "library", "", "groupId", "artifactId", "kind", "Lorg/jetbrains/kotlin/idea/artifacts/LibraryFileKind;", "resolveArtifact", "version", "substitutePathVariables", "path", "kotlin.common"})
public final class UtilKt {
    private static final Lazy remoteMavenRepositories$delegate = LazyKt.lazy((Function0)remoteMavenRepositories.2.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final File findLibrary(@NotNull RepoLocation repoLocation, @NotNull String library, @NotNull String groupId, @NotNull String artifactId, @NotNull LibraryFileKind kind) {
        Object object;
        String urlScheme;
        block20: {
            String pathInRepository;
            block19: {
                Object v3;
                block18: {
                    void $this$singleOrNull$iv;
                    Intrinsics.checkNotNullParameter((Object)((Object)repoLocation), (String)"repoLocation");
                    Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                    Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                    Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                    Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                    File librariesDir = new File(PathManager.getHomePath(), ".idea/libraries");
                    if (!librariesDir.exists()) {
                        throw (Throwable)new IllegalStateException("Can't find " + librariesDir);
                    }
                    File libraryFile = new File(librariesDir, library);
                    if (!libraryFile.exists()) {
                        throw (Throwable)new IllegalStateException("Can't find library " + library);
                    }
                    Object object2 = libraryFile;
                    boolean bl = false;
                    object2 = new FileInputStream((File)object2);
                    bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        FileInputStream stream = (FileInputStream)object2;
                        boolean bl3 = false;
                        stream = new SAXBuilder().build((InputStream)stream);
                    }
                    catch (Throwable stream) {
                        throwable = stream;
                        throw stream;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    }
                    FileInputStream document = stream;
                    urlScheme = "jar://";
                    pathInRepository = StringsKt.replace$default((String)groupId, (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + artifactId;
                    String pathPrefix = urlScheme + (Object)((Object)repoLocation) + '/' + pathInRepository + '/';
                    FileInputStream fileInputStream = document;
                    Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"document");
                    object = fileInputStream.getRootElement().getChild("library");
                    if (object == null || (object = object.getChild(kind.name())) == null || (object = object.getChildren("root")) == null) break block19;
                    Iterable bl3 = (Iterable)object;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        Element it = (Element)element$iv;
                        boolean bl4 = false;
                        String string = it.getAttributeValue("url");
                        if (string == null) {
                            string = "";
                        }
                        if (!StringsKt.startsWith$default((String)string, (String)pathPrefix, (boolean)false, (int)2, null)) continue;
                        if (found$iv) {
                            v3 = null;
                            break block18;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v3 = !found$iv ? null : single$iv;
                }
                if ((object = (Element)v3) != null) break block20;
            }
            throw (Throwable)new IllegalStateException("Root '" + pathInRepository + "' not found in library " + library);
        }
        Object root = object;
        String string = root.getAttributeValue("url");
        if (string == null) {
            string = "";
        }
        String url = string;
        String path = StringsKt.dropLast((String)StringsKt.drop((String)url, (int)urlScheme.length()), (int)2);
        File result = new File(UtilKt.substitutePathVariables(path));
        if (!result.exists()) {
            if (kind == LibraryFileKind.SOURCES) {
                String version = StringsKt.dropLast((String)StringsKt.drop((String)FilesKt.getNameWithoutExtension((File)result), (int)(artifactId.length() + 1)), (int)kind.getClassifierSuffix().length());
                return UtilKt.resolveArtifact(groupId, artifactId, version, kind);
            }
            throw (Throwable)new IllegalStateException("File " + result + " doesn't exist");
        }
        return result;
    }

    public static /* synthetic */ File findLibrary$default(RepoLocation repoLocation, String string, String string2, String string3, LibraryFileKind libraryFileKind, int n, Object object) {
        if ((n & 0x10) != 0) {
            libraryFileKind = LibraryFileKind.CLASSES;
        }
        return UtilKt.findLibrary(repoLocation, string, string2, string3, libraryFileKind);
    }

    private static final List<RemoteRepository> getRemoteMavenRepositories() {
        Lazy lazy = remoteMavenRepositories$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    private static final String substitutePathVariables(String path) {
        if (StringsKt.startsWith$default((String)path, (String)("" + (Object)((Object)RepoLocation.PROJECT_DIR) + '/'), (boolean)false, (int)2, null)) {
            File projectDir = new File(PathManager.getHomePath());
            String string = FilesKt.resolve((File)projectDir, (String)StringsKt.drop((String)path, (int)RepoLocation.PROJECT_DIR.toString().length())).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectDir.resolve(path.\u2026g().length)).absolutePath");
            return string;
        }
        if (StringsKt.startsWith$default((String)path, (String)("" + (Object)((Object)RepoLocation.MAVEN_REPOSITORY) + '/'), (boolean)false, (int)2, null)) {
            File file;
            String string = System.getenv("M2_HOME");
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                file = new File(it);
            } else {
                String string3 = System.getProperty("user.home", null);
                if (string3 == null) {
                    String string4 = "Unable to get the user home directory";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                file = new File(string3, ".m2");
            }
            File m2 = file;
            File repoDir = FilesKt.resolve((File)m2, (String)"repository");
            return repoDir.getAbsolutePath() + StringsKt.drop((String)path, (int)RepoLocation.MAVEN_REPOSITORY.toString().length());
        }
        return path;
    }

    private static final File resolveArtifact(String groupId, String artifactId, String version, LibraryFileKind kind) {
        ArtifactRepositoryManager repositoryManager = new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), UtilKt.getRemoteMavenRepositories(), ProgressConsumer.DEAF, false);
        Collection collection = repositoryManager.resolveDependencyAsArtifact(groupId, artifactId, version, SetsKt.setOf((Object)kind.getArtifactKind()), false, CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repositoryManager.resolv\u2026 false, emptyList()\n    )");
        Collection artifacts = collection;
        boolean bl = artifacts.size() == 1;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Single artifact expected for library \"" + groupId + ':' + artifactId + ':' + version + "\", got " + artifacts;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object = CollectionsKt.single((Iterable)artifacts);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"artifacts.single()");
        File file = ((Artifact)object).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifacts.single().file");
        return file;
    }
}

