/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.version;

import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.jetty.model.JettyConfigArgElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigCallElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigNewElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigRefElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigSetElement;
import com.intellij.javaee.oss.jetty.model.JettyWebRootElement;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileWriter;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentModel;
import com.intellij.javaee.oss.jetty.version.JettyVersion741Handler;
import com.intellij.javaee.oss.util.AbstractConnectorCommand;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JettyVersion9Handler
extends JettyVersion741Handler {
    @Override
    protected JettyConfigFileWriter getConfigFileWriter(final File contextDeployTempDir) {
        return new JettyConfigFileWriter(){

            @Override
            protected void createContent(JettyWebRootElement rootElement) {
                rootElement.getId().setValue((Object)"Server");
                JettyConfigRefElement refElement = rootElement.addRef();
                refElement.getId().setValue((Object)"DeploymentManager");
                JettyConfigCallElement callElement = refElement.addCall();
                callElement.getName().setValue((Object)"addAppProvider");
                JettyConfigArgElement argElement = callElement.addArg();
                JettyConfigNewElement newElement = 1.setupNewElement(argElement, JettyVersion9Handler.this.getContextDeployerPackageName() + ".WebAppProvider");
                JettyConfigSetElement setDirElement = 1.setupSetElement(newElement, "monitoredDirName");
                setDirElement.setValue(contextDeployTempDir.getAbsolutePath());
                1.setupScanIntervalSetElement(newElement);
                JettyConfigSetElement setExtractElement = 1.setupSetElement(newElement, "extractWars");
                setExtractElement.setValue("true");
            }
        };
    }

    @Override
    public DeploymentStatus getDeploymentStatus(MBeanServerConnection connection, ObjectName objectName) throws IOException, JMException {
        String stateDescription = (String)AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)objectName, (String)"state");
        if ("started".equalsIgnoreCase(stateDescription)) {
            return DeploymentStatus.DEPLOYED;
        }
        if ("stopped".equalsIgnoreCase(stateDescription)) {
            return DeploymentStatus.NOT_DEPLOYED;
        }
        if ("starting".equalsIgnoreCase(stateDescription)) {
            return DeploymentStatus.ACTIVATING;
        }
        return DeploymentStatus.FAILED;
    }

    @Override
    public boolean isStarted(MBeanServerConnection connection) throws IOException, JMException {
        String stateDescription = (String)AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)this.getServerObjectName(), (String)"state");
        return "started".equalsIgnoreCase(stateDescription);
    }

    @Override
    public String getHttpPortConfigFilePath() {
        return "etc/jetty-http.xml";
    }

    @Override
    protected String getContextsConfigFilename() {
        return "jetty-contexts.xml";
    }

    @Override
    protected String getContextDeployerPackageName() {
        return "org.eclipse.jetty.deploy.providers";
    }

    @Override
    protected String getWebAppClassAttributeName() {
        return "context";
    }

    @Override
    public String getConfigDocTypeSystemId() {
        return "http://www.eclipse.org/jetty/configure_9_0.dtd";
    }

    @Override
    public String[] getWebAppObjectNames(JettyDeploymentModel deployment, File webApp) {
        String lastSegment;
        Object[] baseResult = super.getWebAppObjectNames(deployment, webApp);
        String nameAttribute = JettyVersion9Handler.computeNameAttribute(deployment, webApp);
        ArrayList<String> moreVariants = new ArrayList<String>();
        if (nameAttribute.contains(".")) {
            moreVariants.add(this.createWebAppObjectName(nameAttribute.replaceAll("\\.", "_")));
        }
        if (nameAttribute.lastIndexOf(47) > 0 && (lastSegment = StringUtil.substringAfterLast((String)nameAttribute, (String)"/")) != null) {
            moreVariants.add(this.createWebAppObjectName(lastSegment));
            if (lastSegment.contains(".")) {
                moreVariants.add(this.createWebAppObjectName(lastSegment.replaceAll("\\.", "_")));
            }
        }
        if (!moreVariants.isEmpty()) {
            return (String[])ArrayUtil.mergeArrayAndCollection((Object[])baseResult, moreVariants, (ArrayFactory)ArrayUtil.STRING_ARRAY_FACTORY);
        }
        return baseResult;
    }
}

