/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.version;

import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileChecker;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesCollector;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesEditor;
import com.intellij.javaee.oss.jetty.server.JettyIniProcessor;
import com.intellij.javaee.oss.jetty.server.JettyIniProducer;
import com.intellij.javaee.oss.jetty.version.JettyVersion9Handler;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JettyVersion91Handler
extends JettyVersion9Handler {
    @Override
    public FileTypeDescriptor getConfigFileTypeDescriptor() {
        return JettyUtil.MODULE_FILE_DESCRIPTOR;
    }

    @Override
    public Collection<String> getCommandLineParameters(Collection<String> configFiles) {
        Collection<String> modules = JettyVersion91Handler.getCommandLineModules(configFiles);
        return modules.isEmpty() ? Collections.emptyList() : Collections.singletonList("--module=" + StringUtil.join(modules, (String)","));
    }

    @NotNull
    protected static Collection<String> getCommandLineModules(@NotNull Collection<String> configurationFiles) {
        if (configurationFiles == null) {
            JettyVersion91Handler.$$$reportNull$$$0(0);
        }
        Collection collection = configurationFiles.stream().map(JettyUtil::getModuleNameFromPath).collect(Collectors.toSet());
        if (collection == null) {
            JettyVersion91Handler.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    public List<JettyConfigFileChecker> getConfigFileCheckers(JettyConfigFilesEditor editor) {
        return Collections.singletonList(new JettyConfigFileChecker(editor, "modules/jmx.mod", JettyBundle.getText("JettyVersion91Handler.error.jmx.module.is.not.included", new Object[0])));
    }

    @Override
    public JettyConfigFilesCollector getConfigFilesCollector(String home, String workDir, List<JettyConfigFile> configFiles) {
        return new JettyModulesConfigCollector(home, workDir, configFiles);
    }

    @Override
    public JettyIniProducer getIniProducer(String home, Set<String> activePaths) {
        return new ModuleIniProducer(home, activePaths);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/jetty/version/JettyVersion91Handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/jetty/version/JettyVersion91Handler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineModules";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleIniProducer
    extends JettyIniProducer {
        private Set<String> myActiveModules;

        ModuleIniProducer(String home, Set<String> configFiles) {
            super(home, configFiles);
        }

        @Override
        public void process() {
            this.myActiveModules = new HashSet<String>();
            for (String activePath : this.getConfigFiles()) {
                this.myActiveModules.add(FileUtilRt.getNameWithoutExtension((String)new File(activePath).getName()));
            }
            super.process();
            for (String module : this.myActiveModules) {
                this.addModule(module, false);
            }
        }

        @Override
        protected void processPathLine(String path) {
            this.addIniLine(path);
        }

        @Override
        protected void processModuleLine(String moduleName, boolean isCommented) {
            this.addModule(moduleName, !this.myActiveModules.remove(moduleName));
        }

        private void addModule(String moduleName, boolean commented) {
            this.addIniLine((commented ? "#" : "") + "--module=" + moduleName);
        }
    }

    private static class JettyModulesConfigCollector
    extends JettyConfigFilesCollector {
        JettyModulesConfigCollector(String home, String workDir, List<JettyConfigFile> configFiles) {
            super(home, workDir, configFiles, ".mod");
        }

        @Override
        public void scanIni() {
            new JettyIniProcessor(this.getWorkDir()){

                @Override
                protected void processModuleLine(String moduleName, boolean isCommented) {
                    if (!isCommented) {
                        this.getOrCreateConfigFile(JettyUtil.getModuleRelativePath(moduleName)).setActive(true);
                    }
                }
            }.process();
        }

        @Override
        protected File[] doScanDir() {
            return new File(this.getHome(), "modules").listFiles(pathname -> pathname.getName().endsWith(".mod"));
        }
    }
}

