/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JettyIniProcessor {
    @NonNls
    private static final String START_INI_FILE = "start.ini";
    @NonNls
    private static final String OPTIONS_PARAM_PREFIX = "OPTIONS=";
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^([^#].*)=(.*)$");
    private static final Pattern MODULE_PATTERN = Pattern.compile("(?:#\\s*)?--module=(.+)");
    private final File myIniFile;

    public JettyIniProcessor(String workDir) {
        this(JettyIniProcessor.getDefaultIniFile(workDir));
    }

    @NotNull
    public static File getDefaultIniFile(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            JettyIniProcessor.$$$reportNull$$$0(0);
        }
        return new File(workingDirectory, START_INI_FILE);
    }

    public JettyIniProcessor(File iniFile) {
        this.myIniFile = iniFile;
    }

    public File getIniFile() {
        return this.myIniFile;
    }

    public void process() {
        try {
            String[] iniLines;
            String iniContent = FileUtil.loadFile((File)this.myIniFile);
            for (String iniLine : iniLines = iniContent.split("\n")) {
                iniLine = iniLine.trim();
                Matcher matcher = PARAMETER_PATTERN.matcher(iniLine);
                Matcher moduleMatcher = MODULE_PATTERN.matcher(iniLine);
                if (moduleMatcher.matches()) {
                    this.processModuleLine(moduleMatcher.group(1), iniLine.startsWith("#"));
                    continue;
                }
                if (iniLine.isEmpty() || iniLine.startsWith("#") || iniLine.startsWith("-") || iniLine.startsWith(OPTIONS_PARAM_PREFIX)) {
                    this.processNonPathLine(iniLine);
                    continue;
                }
                if (matcher.matches()) {
                    this.processNonPathLine(iniLine);
                    this.processParameter(matcher.group(1), matcher.group(2));
                    continue;
                }
                this.processPathLine(iniLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void processNonPathLine(String iniLine) {
    }

    protected void processParameter(String paramName, String value) {
    }

    protected void processPathLine(String path) {
    }

    protected void processModuleLine(String moduleName, boolean isCommented) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "com/intellij/javaee/oss/jetty/server/JettyIniProcessor", "getDefaultIniFile"));
    }
}

