/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.common.PathResolverBase;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.util.Column;
import com.intellij.javaee.oss.util.JTableWrapper;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;

public class JettyConfigFilesEditor {
    private static final FileChooserDescriptor CONFIG_FOLDER_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFolderDescriptor();
    private final JPanel myMainPanel;
    private final JBTable myFilesTable = new JBTable();
    private final JTableWrapper<JettyConfigFile, FileColumnBase> myFilesTableWrapper = new JTableWrapper(this.myFilesTable, (Column[])new FileColumnBase[]{new ActiveColumn(), new PathColumn()});
    private File myHome;
    private List<JettyConfigFile> myFiles = new ArrayList<JettyConfigFile>();
    private FileTypeDescriptor myConfigFileTypeDescriptor = JettyUtil.CONFIG_FILE_DESCRIPTOR;
    private final PathResolverBase myPathResolver = new PathResolverBase(){

        @Override
        protected File getRootDir() {
            return JettyConfigFilesEditor.this.myHome;
        }
    };

    public JettyConfigFilesEditor() {
        this.myMainPanel = ToolbarDecorator.createDecorator((JTable)this.myFilesTable).setAddAction(this.createAddAction()).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JettyConfigFilesEditor.this.removeFile();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JettyConfigFilesEditor.this.editFile();
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JettyConfigFilesEditor.this.moveUpFile();
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JettyConfigFilesEditor.this.moveDownFile();
            }
        }).createPanel();
    }

    public void setConfigFileTypeDescriptor(FileTypeDescriptor descriptor) {
        this.myConfigFileTypeDescriptor = descriptor;
    }

    private void moveDownFile() {
        int selectedIndex = this.myFilesTable.getSelectedRow();
        if (selectedIndex == -1 || selectedIndex == this.myFiles.size() - 1) {
            return;
        }
        JettyConfigFile file = this.myFiles.remove(selectedIndex);
        this.myFiles.add(selectedIndex + 1, file);
        if (file.isActive()) {
            this.activeFilesSetChanged();
        }
        this.updateTable(selectedIndex + 1);
    }

    private void moveUpFile() {
        int selectedIndex = this.myFilesTable.getSelectedRow();
        if (selectedIndex == -1 || selectedIndex == 0) {
            return;
        }
        JettyConfigFile file = this.myFiles.remove(selectedIndex);
        this.myFiles.add(selectedIndex - 1, file);
        if (file.isActive()) {
            this.activeFilesSetChanged();
        }
        this.updateTable(selectedIndex - 1);
    }

    protected AnActionButtonRunnable createAddAction() {
        return new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JettyConfigFilesEditor.this.addFile(false);
            }
        };
    }

    protected final void addFile(boolean dir) {
        if (!new FileChooserWrapper(){

            @Override
            protected void processChosenPath(String path) {
                JettyConfigFilesEditor.this.myFiles.add(new JettyConfigFile(path));
            }
        }.chooseFiles(this.myHome, dir)) {
            return;
        }
        this.updateTable(this.myFiles.size() - 1);
    }

    private void removeFile() {
        int selectedIndex = this.myFilesTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        if (this.myFiles.remove(selectedIndex).isActive()) {
            this.activeFilesSetChanged();
        }
        this.updateTable();
    }

    private void editFile() {
        int selectedIndex = this.myFilesTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        final JettyConfigFile selectedConfigFile = this.myFiles.get(selectedIndex);
        if (!new FileChooserWrapper(){

            @Override
            protected void processChosenPath(String path) {
                selectedConfigFile.setPath(path);
                if (selectedConfigFile.isActive()) {
                    JettyConfigFilesEditor.this.activeFilesSetChanged();
                }
            }
        }.chooseFiles(this.myPathResolver.path2Absolute(selectedConfigFile.getPath()), selectedConfigFile.isDir())) {
            return;
        }
        this.updateTable(selectedIndex);
    }

    public void setEnabled(boolean enabled) {
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)enabled, (boolean)true);
    }

    public void setHome(File home) {
        this.myHome = home;
    }

    public void setFiles(Collection<JettyConfigFile> files) {
        this.myFiles = new ArrayList<JettyConfigFile>(files);
        this.updateTable();
    }

    private void updateTable() {
        this.myFilesTableWrapper.setInputRows(this.myFiles);
    }

    private void updateTable(int selectedIndex) {
        this.updateTable();
        this.myFilesTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
    }

    public List<JettyConfigFile> getFiles() {
        return new ArrayList<JettyConfigFile>(this.myFiles);
    }

    protected void activeFilesSetChanged() {
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private static class PathColumn
    extends FileColumnBase {
        PathColumn() {
            super(JettyBundle.getText("JettyConfigFilesEditor.column.path", new Object[0]));
        }

        public Object getColumnValue(JettyConfigFile row) {
            return row.getPath();
        }
    }

    private class ActiveColumn
    extends FileColumnBase {
        ActiveColumn() {
            super(JettyBundle.getText("JettyConfigFilesEditor.column.active", new Object[0]));
        }

        public boolean isEditable() {
            return true;
        }

        public Class<?> getValueClass() {
            return Boolean.class;
        }

        public Object getColumnValue(JettyConfigFile row) {
            return row.isActive();
        }

        public void setColumnValue(JettyConfigFile row, Object value) {
            row.setActive((Boolean)value);
            JettyConfigFilesEditor.this.activeFilesSetChanged();
        }

        public boolean needPack() {
            return true;
        }
    }

    private static abstract class FileColumnBase
    extends Column<JettyConfigFile> {
        FileColumnBase(String name) {
            super(name);
        }
    }

    private abstract class FileChooserWrapper {
        private FileChooserWrapper() {
        }

        public boolean chooseFiles(File preselectedFile, boolean dir) {
            VirtualFile[] chosenFiles = FileChooser.chooseFiles((FileChooserDescriptor)(dir ? CONFIG_FOLDER_DESCRIPTOR : JettyConfigFilesEditor.this.myConfigFileTypeDescriptor), (Component)JettyConfigFilesEditor.this.myMainPanel, null, (VirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(preselectedFile));
            if (chosenFiles.length == 0) {
                return false;
            }
            for (VirtualFile chosenFile : chosenFiles) {
                String path = JettyConfigFilesEditor.this.myPathResolver.path2Relative(VfsUtilCore.virtualToIoFile((VirtualFile)chosenFile));
                if (dir) {
                    path = JettyConfigFile.getDirPath(path);
                }
                this.processChosenPath(path);
            }
            return true;
        }

        protected abstract void processChosenPath(String var1);
    }
}

