/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesEditor;
import com.intellij.openapi.util.io.FileUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;

public class JettyConfigFileChecker {
    private final JettyConfigFilesEditor myConfigFilesEditor;
    private final String myPath;
    @Nls
    private final String myWarning;
    private boolean myIncluded;

    public JettyConfigFileChecker(JettyConfigFilesEditor configFilesEditor, String path, @Nls String warning) {
        this.myConfigFilesEditor = configFilesEditor;
        this.myPath = path;
        this.myWarning = warning;
        this.myIncluded = false;
    }

    public void checkActiveIncluded(Set<String> activePaths) {
        if (activePaths.contains(this.myPath)) {
            this.myIncluded = true;
        }
    }

    public void checkIniIncluded(String iniPath) {
        if (this.myPath.equals(iniPath)) {
            this.myIncluded = true;
        }
    }

    public void warn(List<JettyConfigFile> configFiles) throws RuntimeConfigurationWarning {
        if (this.myIncluded) {
            return;
        }
        JettyConfigFile jmxConfigFile = null;
        for (JettyConfigFile configFile : configFiles) {
            if (!this.myPath.equals(FileUtil.toSystemIndependentName((String)configFile.getPath()))) continue;
            jmxConfigFile = configFile;
        }
        JettyConfigFile finalJmxConfigFile = jmxConfigFile;
        throw new RuntimeConfigurationWarning(this.myWarning, jmxConfigFile == null ? null : () -> {
            finalJmxConfigFile.setActive(true);
            this.myConfigFilesEditor.setFiles(configFiles);
        });
    }
}

