/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JettyConfigFile {
    private String myPath;
    private boolean myActive;

    public JettyConfigFile() {
        this(null);
    }

    public JettyConfigFile(String path) {
        this.myPath = path;
        this.myActive = false;
    }

    public String getPath() {
        return this.myPath;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public void setActive(boolean active) {
        this.myActive = active;
    }

    public boolean isDir() {
        return this.myPath.endsWith(String.valueOf(File.separatorChar));
    }

    public static String getDirPath(String path) {
        return path + File.separatorChar;
    }

    public static Set<String> getActivePaths(List<? extends JettyConfigFile> configFiles) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (JettyConfigFile jettyConfigFile : configFiles) {
            if (!jettyConfigFile.isActive()) continue;
            result.add(FileUtil.toSystemIndependentName((String)jettyConfigFile.getPath()));
        }
        return result;
    }
}

