/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.tests.DefaultExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.DefaultExternalTestsModel;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestsModel;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class ExternalTestsSerializationService
implements SerializationService<ExternalTestsModel> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(ExternalTestsModel testsModel, Class<? extends ExternalTestsModel> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);
        try {
            ExternalTestsSerializationService.write(writer, this.myWriteContext, testsModel);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalTestsModel read(byte[] object, Class<? extends ExternalTestsModel> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            ExternalTestsModel externalTestsModel = ExternalTestsSerializationService.read(reader, this.myReadContext);
            return externalTestsModel;
        }
        finally {
            reader.close();
        }
    }

    public Class<? extends ExternalTestsModel> getModelClass() {
        return ExternalTestsModel.class;
    }

    private static void write(final IonWriter writer, final WriteContext context, final ExternalTestsModel model) throws IOException {
        context.objectCollector.add((Object)model, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ExternalTestsSerializationService.writeTestSourceMappings(writer, context, model.getTestSourceMappings());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeTestSourceMappings(IonWriter writer, WriteContext context, Collection<ExternalTestSourceMapping> sourceMappings) throws IOException {
        writer.setFieldName("sourceTestMappings");
        writer.stepIn(IonType.LIST);
        for (ExternalTestSourceMapping mapping : sourceMappings) {
            ExternalTestsSerializationService.writeTestSourceMapping(writer, context, mapping);
        }
        writer.stepOut();
    }

    private static void writeTestSourceMapping(final IonWriter writer, WriteContext context, final ExternalTestSourceMapping testSourceMapping) throws IOException {
        context.mappingCollector.add((Object)testSourceMapping, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"testName", (String)testSourceMapping.getTestName());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"testTaskPath", (String)testSourceMapping.getTestTaskPath());
                    ToolingStreamApiUtils.writeStrings((IonWriter)writer, (String)"sourceFolders", (Collection)testSourceMapping.getSourceFolders());
                }
                writer.stepOut();
            }
        });
    }

    @Nullable
    private static ExternalTestsModel read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ExternalTestsModel model = (ExternalTestsModel)context.objectMap.computeIfAbsent(ToolingStreamApiUtils.readInt((IonReader)reader, (String)"objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<ExternalTestsModel>(){

            public ExternalTestsModel create() {
                DefaultExternalTestsModel testsModel = new DefaultExternalTestsModel();
                testsModel.setSourceTestMappings(ExternalTestsSerializationService.readTestSourceMappings(reader, context));
                return testsModel;
            }
        });
        reader.stepOut();
        return model;
    }

    private static List<ExternalTestSourceMapping> readTestSourceMappings(IonReader reader, ReadContext context) {
        ExternalTestSourceMapping testSourceMapping;
        ArrayList<ExternalTestSourceMapping> list = new ArrayList<ExternalTestSourceMapping>();
        reader.next();
        reader.stepIn();
        while ((testSourceMapping = ExternalTestsSerializationService.readTestSourceMapping(reader, context)) != null) {
            list.add(testSourceMapping);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static ExternalTestSourceMapping readTestSourceMapping(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ExternalTestSourceMapping dependency = (ExternalTestSourceMapping)context.testSourceMapping.computeIfAbsent(ToolingStreamApiUtils.readInt((IonReader)reader, (String)"objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<ExternalTestSourceMapping>(){

            public ExternalTestSourceMapping create() {
                DefaultExternalTestSourceMapping mapping = new DefaultExternalTestSourceMapping();
                mapping.setTestName(ToolingStreamApiUtils.readString((IonReader)reader, (String)"testName"));
                mapping.setTestTaskPath((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"testTaskPath")));
                mapping.setSourceFolders(ToolingStreamApiUtils.readStringSet((IonReader)reader));
                return mapping;
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static class WriteContext {
        private final ObjectCollector<ExternalTestsModel, IOException> objectCollector = new ObjectCollector();
        private final ObjectCollector<ExternalTestSourceMapping, IOException> mappingCollector = new ObjectCollector();

        private WriteContext() {
        }
    }

    private static class ReadContext {
        private final IntObjectMap<ExternalTestsModel> objectMap = new IntObjectMap();
        private final IntObjectMap<ExternalTestSourceMapping> testSourceMapping = new IntObjectMap();

        private ReadContext() {
        }
    }
}

