/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.toolWindow.tree;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.toolWindow.tree.CdiViewPathUtils$WhenMappings;
import com.intellij.cdi.toolWindow.tree.nodes.CdiNodeTypes;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a+\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0016\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u0001\"\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\u0010\u0013\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"createPath", "", "", "steps", "([Ljava/lang/Object;)[Ljava/lang/Object;", "getBindingAnnotation", "Lcom/intellij/psi/PsiClass;", "psiClass", "module", "Lcom/intellij/openapi/module/Module;", "getCdiNodeType", "Lcom/intellij/cdi/toolWindow/tree/nodes/CdiNodeTypes;", "getDeploymentAnnotation", "getScopeAnnotation", "getTreePath", "psiElement", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/project/Project;)[Ljava/lang/Object;", "isAnnotated", "", "annoClass", "intellij.javaee.cdi"})
@JvmName(name="CdiViewPathUtils")
public final class CdiViewPathUtils {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RequiresBackgroundThread
    @NotNull
    public static final Object[] getTreePath(@NotNull PsiElement psiElement, @Nullable Module module, @NotNull Project project) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (module == null) {
            return new Object[]{project};
        }
        Object $this$parentOfType$iv = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiClass.class, (boolean)true);
        if (psiClass == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"ArrayUtil.EMPTY_OBJECT_ARRAY");
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiClass psiClass2 = psiClass;
        Object object = $this$parentOfType$iv = CdiViewPathUtils.getCdiNodeType(psiClass2, module);
        if (object != null) {
            switch (CdiViewPathUtils$WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
                case 1: {
                    void cdiNodeType;
                    objectArray = CdiViewPathUtils.createPath(project, module, cdiNodeType, CdiViewPathUtils.getBindingAnnotation(psiClass2, module), psiClass2);
                    return objectArray;
                }
                case 2: {
                    void cdiNodeType;
                    objectArray = CdiViewPathUtils.createPath(project, module, cdiNodeType, CdiViewPathUtils.getDeploymentAnnotation(psiClass2, module), psiClass2);
                    return objectArray;
                }
                case 3: {
                    void cdiNodeType;
                    objectArray = CdiViewPathUtils.createPath(project, module, cdiNodeType, CdiViewPathUtils.getScopeAnnotation(psiClass2, module), psiClass2);
                    return objectArray;
                }
                case 4: {
                    void cdiNodeType;
                    objectArray = CdiViewPathUtils.createPath(project, module, cdiNodeType, psiClass2);
                    return objectArray;
                }
            }
        }
        objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"ArrayUtil.EMPTY_OBJECT_ARRAY");
        return objectArray;
    }

    private static final Object[] createPath(Object ... steps) {
        Object[] $this$takeWhile$iv = steps;
        boolean $i$f$takeWhile = false;
        ArrayList<Object> list$iv = new ArrayList<Object>();
        Object[] objectArray = $this$takeWhile$iv;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object item$iv;
            Object it = item$iv = objectArray[i];
            boolean bl = false;
            if (!(it != null)) break;
            list$iv.add(item$iv);
        }
        List list = list$iv;
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        Object[] objectArray2 = ArrayUtil.toObjectArray((Collection)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"steps.takeWhile { it != \u2026yUtil.toObjectArray(it) }");
        return objectArray2;
    }

    private static final CdiNodeTypes getCdiNodeType(PsiClass psiClass, Module module) {
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (Collection)SetsKt.setOf((Object)CdiAnnoConstants.DEPLOYMENT_TYPE_ANNOTATION.fqn(module)))) {
            return CdiNodeTypes.DEPLOYMENT;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (Collection)CdiCommonUtils.NORMAL_SCOPE_ANNOTATIONS, (int)0)) {
            return CdiNodeTypes.SCOPE;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (String)CdiAnnoConstants.NAMED_ANNOTATION.fqn(module), (int)0)) {
            return CdiNodeTypes.NAMED;
        }
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (Collection)SetsKt.setOf((Object)CdiAnnoConstants.QUALIFIER_ANNOTATION.fqn(module)))) {
            return CdiNodeTypes.BINDING;
        }
        return null;
    }

    private static final PsiClass getBindingAnnotation(PsiClass psiClass, Module module) {
        Object v2;
        block1: {
            Collection<PsiClass> collection = CdiCommonUtils.getQualifierClasses(module);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"CdiCommonUtils.getQualifierClasses(module)");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                PsiClass it = (PsiClass)t;
                boolean bl3 = false;
                PsiClass psiClass2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"it");
                if (!CdiViewPathUtils.isAnnotated(psiClass, psiClass2)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final PsiClass getScopeAnnotation(PsiClass psiClass, Module module) {
        Object v2;
        block1: {
            Collection<PsiClass> collection = CdiCommonUtils.getNormalScopeTypesClasses(module);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"CdiCommonUtils.getNormalScopeTypesClasses(module)");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                PsiClass it = (PsiClass)t;
                boolean bl3 = false;
                PsiClass psiClass2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"it");
                if (!CdiViewPathUtils.isAnnotated(psiClass, psiClass2)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final PsiClass getDeploymentAnnotation(PsiClass psiClass, Module module) {
        Object v2;
        block1: {
            Collection<PsiClass> collection = CdiCommonUtils.getDeploymentTypesClasses(module);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"CdiCommonUtils.getDeploymentTypesClasses(module)");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                PsiClass it = (PsiClass)t;
                boolean bl3 = false;
                PsiClass psiClass2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"it");
                if (!CdiViewPathUtils.isAnnotated(psiClass, psiClass2)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final boolean isAnnotated(PsiClass psiClass, PsiClass annoClass) {
        boolean bl;
        String string = annoClass.getQualifiedName();
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            bl = AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (String)it, (int)0);
        } else {
            bl = false;
        }
        return bl;
    }
}

