/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.toolWindow;

import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.toolWindow.tree.CdiTreeStructure;
import com.intellij.cdi.toolWindow.tree.actions.NodeTypesToggleAction;
import com.intellij.cdi.toolWindow.tree.nodes.CdiNodeTypes;
import com.intellij.cdi.toolWindow.tree.nodes.CdiTreeRootNode;
import com.intellij.cdi.toolWindow.tree.nodes.CdiViewSettings;
import com.intellij.cdi.toolWindow.tree.nodes.JamPsiMemberNode;
import com.intellij.javaee.ui.FrameworkToolWindowViewBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMember;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.PlatformIcons;
import com.intellij.util.messages.Topic;
import icons.JavaUltimateIcons;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CdiView
extends FrameworkToolWindowViewBase
implements Disposable {
    private final CdiViewSettings myCdiViewSettings;
    public static final Topic<Listener> TOPIC = new Topic("Cdi Tree Changes", Listener.class);

    public CdiView(@NotNull Project project, final @NotNull CdiViewSettings cdiViewSettings, @NotNull Disposable parentDisposable) {
        if (project == null) {
            CdiView.$$$reportNull$$$0(0);
        }
        if (cdiViewSettings == null) {
            CdiView.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            CdiView.$$$reportNull$$$0(2);
        }
        super(project, new FrameworkToolWindowViewBase.FrameworkViewTreeStructureProvider(){

            public SimpleTreeStructure createTreeStructure(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new CdiTreeStructure((SimpleNode)new CdiTreeRootNode(project, cdiViewSettings), project, cdiViewSettings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/toolWindow/CdiView$1", "createTreeStructure"));
            }
        }, parentDisposable);
        this.myCdiViewSettings = cdiViewSettings;
        this.initComponents();
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(TOPIC, () -> this.myModel.invalidate());
    }

    public void dispose() {
        this.removeAll();
    }

    protected void addGearActions(DefaultActionGroup group) {
        this.addNamedBeans(group);
        this.addQualifiers(group);
        this.addScopes(group);
        this.addDeployments(group);
    }

    private void addNamedBeans(DefaultActionGroup actions) {
        actions.add((AnAction)new NodeTypesToggleAction(this.myProject, CdiNodeTypes.NAMED, CdiBundle.message("actions.show.named", new Object[0]), PlatformIcons.ANNOTATION_TYPE_ICON){

            @Override
            protected void setNodeTypeSelected(boolean state) {
                CdiView.this.myCdiViewSettings.named = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return CdiView.this.myCdiViewSettings.named;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cdi/toolWindow/CdiView$2", "isSelected"));
            }
        });
    }

    private void addScopes(DefaultActionGroup actions) {
        actions.add((AnAction)new NodeTypesToggleAction(this.myProject, CdiNodeTypes.SCOPE, CdiBundle.message("actions.show.scope", new Object[0]), JavaUltimateIcons.Cdi.Scopes){

            @Override
            protected void setNodeTypeSelected(boolean state) {
                CdiView.this.myCdiViewSettings.scope = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return CdiView.this.myCdiViewSettings.scope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cdi/toolWindow/CdiView$3", "isSelected"));
            }
        });
    }

    private void addDeployments(DefaultActionGroup actions) {
        actions.add((AnAction)new NodeTypesToggleAction(this.myProject, CdiNodeTypes.DEPLOYMENT, CdiBundle.message("actions.show.deployment", new Object[0]), JavaUltimateIcons.Cdi.Deployments){

            @Override
            protected void setNodeTypeSelected(boolean state) {
                CdiView.this.myCdiViewSettings.deployment = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return CdiView.this.myCdiViewSettings.deployment;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cdi/toolWindow/CdiView$4", "isSelected"));
            }
        });
    }

    private void addQualifiers(DefaultActionGroup actions) {
        actions.add((AnAction)new NodeTypesToggleAction(this.myProject, CdiNodeTypes.BINDING, CdiBundle.message("actions.show.qualifiers", new Object[0]), JavaUltimateIcons.Cdi.Bean){

            @Override
            protected void setNodeTypeSelected(boolean state) {
                CdiView.this.myCdiViewSettings.binding = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                return CdiView.this.myCdiViewSettings.binding;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cdi/toolWindow/CdiView$5", "isSelected"));
            }
        });
    }

    public Object getData(@NotNull @NonNls String dataId) {
        Object data;
        if (dataId == null) {
            CdiView.$$$reportNull$$$0(3);
        }
        if ((data = super.getData(dataId)) != null) {
            return data;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "CDI_Tool_Window";
        }
        Set set = CdiView.getSelectedElements((JTree)this.myTree);
        if (!set.isEmpty()) {
            PsiMember psiMember;
            Object nodeDescriptor = set.iterator().next();
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && nodeDescriptor instanceof JamPsiMemberNode && (psiMember = (PsiMember)((JamPsiMemberNode)((Object)nodeDescriptor)).getJamElement()) != null && psiMember.isValid()) {
                return psiMember;
            }
        }
        return null;
    }

    public static void select(@NotNull Project project, boolean requestFocus, Object ... pathSteps) {
        if (project == null) {
            CdiView.$$$reportNull$$$0(4);
        }
        CdiView.select((String)"CDI", (Project)project, (boolean)requestFocus, (Object[])pathSteps);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cdiViewSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/toolWindow/CdiView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void settingsChanged();
    }
}

