/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.providers;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/cdi/providers/MPImplicitUsageProvider;", "Lcom/intellij/codeInsight/daemon/ImplicitUsageProvider;", "()V", "isGaugeMetricMethod", "", "element", "Lcom/intellij/psi/PsiMethod;", "isImplicitRead", "Lcom/intellij/psi/PsiElement;", "isImplicitUsage", "isImplicitWrite", "isProbeClass", "Lcom/intellij/psi/PsiClass;", "intellij.javaee.cdi"})
public final class MPImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiClass && this.isProbeClass((PsiClass)element) || element instanceof PsiMethod && this.isGaugeMetricMethod((PsiMethod)element);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiMethod && this.isGaugeMetricMethod((PsiMethod)element);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }

    private final boolean isProbeClass(PsiClass element) {
        if (element.isEnum() || element.isAnnotationType() || element.isInterface() || element.hasModifier(JvmModifier.ABSTRACT) || PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)"org.eclipse.microprofile.health.Readiness", (int)0) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)"org.eclipse.microprofile.health.Liveness", (int)0)) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)element, (String)"org.eclipse.microprofile.health.HealthCheck");
    }

    private final boolean isGaugeMetricMethod(PsiMethod element) {
        if (element.hasModifier(JvmModifier.ABSTRACT) || element.hasModifier(JvmModifier.STATIC)) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)"org.eclipse.microprofile.metrics.annotation.Gauge", (int)0)) {
            return false;
        }
        PsiClass psiClass = element.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"element.containingClass ?: return false");
        PsiClass containingClass = psiClass;
        if (containingClass.isEnum() || containingClass.isAnnotationType() || containingClass.isInterface() || containingClass.hasModifier(JvmModifier.ABSTRACT) || PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)containingClass));
        if (module == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026ingClass) ?: return false");
        Module module2 = module;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)CdiAnnoConstants.APPLICATION_SCOPED_ANNOTATION.fqn(module2), (int)0);
    }
}

