/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.providers;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final Collection<JavaeeClass> PARAM_ANNOTATIONS = Arrays.asList(CdiAnnoConstants.OBSERVES_ANNOTATION, CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION, CdiAnnoConstants.DISPOSES_ANNOTATION);
    private static final Collection<JavaeeClass> OBSERVE_PARAM_ANNOTATIONS = Arrays.asList(CdiAnnoConstants.OBSERVES_ANNOTATION, CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION);

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        Module module = CdiImplicitUsageProvider.getCdiModule(element);
        return CdiImplicitUsageProvider.isImplicitUsage(element, module);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return this.isImplicitUsage(element);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        if (CdiAnnoConstants.INJECT_ANNOTATION.isAnnotated((PsiModifierListOwner)element, 0)) {
            return true;
        }
        Module module = CdiImplicitUsageProvider.getCdiModule(element);
        if (module == null) {
            return false;
        }
        return CdiImplicitUsageProvider.isImplicitUsage(element, module) || AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), CdiCommonUtils.getBindingTypesQualifiedNames(module), (int)0);
    }

    private static boolean isImplicitUsage(@NotNull PsiElement element, @Nullable Module module) {
        if (element == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            return false;
        }
        if (element instanceof PsiMethod) {
            Collection paramAnnotations = PARAM_ANNOTATIONS.stream().map(aClass -> aClass.fqn(module)).collect(Collectors.toSet());
            for (PsiParameter parameter : ((PsiMethod)element).getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (Collection)paramAnnotations, (int)0)) continue;
                return true;
            }
        }
        if (element instanceof PsiClass && CdiImplicitUsageProvider.isProducerClass((PsiClass)element)) {
            return true;
        }
        if (element instanceof PsiParameter && CdiImplicitUsageProvider.isObserveParameter((PsiParameter)element, module)) {
            return true;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), CdiCommonUtils.getStereotypeAnnotationNames(module), (int)0) || AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)CdiAnnoConstants.PRODUCES_ANNOTATION.fqn(module), (int)0) || CdiImplicitUsageProvider.isInjectedBeanCandidate(module, element);
    }

    private static boolean isObserveParameter(@NotNull PsiParameter parameter, @NotNull Module module) {
        if (parameter == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        if (module == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        Set annotations = OBSERVE_PARAM_ANNOTATIONS.stream().map(aClass -> aClass.fqn(module)).collect(Collectors.toSet());
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, annotations, (int)0);
    }

    private static boolean isProducerClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(6);
        }
        return CdiCommonUtils.getProducerFields(psiClass).size() > 0 || CdiCommonUtils.getProducerMethods(psiClass).size() > 0;
    }

    private static boolean isInjectedBeanCandidate(@NotNull Module module, @NotNull PsiElement element) {
        if (module == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(7);
        }
        if (element == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiClass) {
            Set ipTypes = ContainerUtil.map2Set(CdiInjectionUtils.getInjectionPoints(module), descriptor -> descriptor.getType());
            for (PsiType ipType : ipTypes) {
                if (ipType == null || !ipType.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)((PsiClass)element)))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Module getCdiModule(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(9);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && CdiCommonUtils.isCdiInstalled(module)) {
            return module;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/providers/CdiImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isObserveParameter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isProducerClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectedBeanCandidate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCdiModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

