/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.microprofile;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.cdi.JavaeeCdiIcons;
import com.intellij.cdi.microprofile.MicroprofileModuleBuilder;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.ide.starters.remote.DependencyAvailable;
import com.intellij.ide.starters.remote.DependencyState;
import com.intellij.ide.starters.remote.DependencyUnavailable;
import com.intellij.ide.starters.remote.WebStarterContext;
import com.intellij.ide.starters.remote.WebStarterContextProvider;
import com.intellij.ide.starters.remote.WebStarterDependency;
import com.intellij.ide.starters.remote.WebStarterDependencyCategory;
import com.intellij.ide.starters.remote.WebStarterFrameworkVersion;
import com.intellij.ide.starters.remote.WebStarterModuleBuilder;
import com.intellij.ide.starters.remote.WebStarterServerOptions;
import com.intellij.ide.starters.remote.WebStarterSettings;
import com.intellij.ide.starters.remote.wizard.WebStarterInitialStep;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.GraphPropertyImpl;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u000278B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000bH\u0014J\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\nH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001cH\u0014J\b\u0010)\u001a\u00020\nH\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\u000bH\u0014J\b\u0010+\u001a\u00020\nH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000bH\u0014J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\nH\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000bH\u0014J\u0010\u00103\u001a\u0002042\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u00105\u001a\u0002062\u0006\u0010\u000f\u001a\u00020\nH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/cdi/microprofile/MicroprofileModuleBuilder;", "Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "()V", "MP_RUNTIME_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/cdi/microprofile/MicroprofileModuleBuilder$MicroprofileRuntime;", "getMP_RUNTIME_KEY", "()Lcom/intellij/openapi/util/Key;", "MP_RUNTIME_SUPPORT_MAP_KEY", "", "", "", "Lcom/intellij/cdi/microprofile/MicroprofileModuleBuilder$MicroprofileRuntimeVersion;", "composeGeneratorUrl", "Lcom/intellij/util/Url;", "serverUrl", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "createOptionsStep", "Lcom/intellij/ide/starters/remote/wizard/WebStarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/remote/WebStarterContextProvider;", "extractGeneratorResult", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "filterSpecifications", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "specifications", "getBuilderId", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "getDefaultLanguageLevel", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getDefaultServerUrl", "getDependencyState", "Lcom/intellij/ide/starters/remote/DependencyState;", "frameworkVersion", "Lcom/intellij/ide/starters/remote/WebStarterFrameworkVersion;", "dependency", "getDescription", "getFilePathsToOpen", "getHelpId", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "isVersionAvailable", "", "loadServerOptions", "Lcom/intellij/ide/starters/remote/WebStarterServerOptions;", "MicroprofileRuntime", "MicroprofileRuntimeVersion", "intellij.javaee.cdi"})
public class MicroprofileModuleBuilder
extends WebStarterModuleBuilder {
    private final Key<Map<String, List<MicroprofileRuntimeVersion>>> MP_RUNTIME_SUPPORT_MAP_KEY;
    @NotNull
    private final Key<MicroprofileRuntime> MP_RUNTIME_KEY;

    @NotNull
    protected final Key<MicroprofileRuntime> getMP_RUNTIME_KEY() {
        return this.MP_RUNTIME_KEY;
    }

    @NotNull
    public String getDefaultServerUrl() {
        return "https://start.microprofile.io";
    }

    @NotNull
    public String getBuilderId() {
        return "microprofile";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = JavaeeCdiIcons.Microprofile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaeeCdiIcons.Microprofile");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        return "MicroProfile";
    }

    @NotNull
    public String getDescription() {
        String string = CdiBundle.message("description.for.microprofile.project.starter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CdiBundle.message(\"descr\u2026profile.project.starter\")");
        return string;
    }

    @NotNull
    public String getHelpId() {
        return "microprofile.project";
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return new StarterLanguageLevel("8", "8", "1.8");
    }

    @NotNull
    protected List<WebStarterDependency> filterSpecifications(@NotNull List<? extends WebStarterDependency> specifications) {
        Intrinsics.checkNotNullParameter(specifications, (String)"specifications");
        return specifications;
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        return CollectionsKt.listOf((Object)new StarterLanguage("java", "Java", "JAVA", false, null, 24, null));
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages = new CustomizedMessages();
        boolean bl = false;
        boolean bl2 = false;
        CustomizedMessages $this$apply = customizedMessages;
        boolean bl3 = false;
        $this$apply.setFrameworkVersionLabel(CdiBundle.message("microprofile.starter.version.label", new Object[0]));
        $this$apply.setDependenciesLabel(CdiBundle.message("microprofile.starter.specifications.label", new Object[0]));
        $this$apply.setSelectedDependenciesLabel(CdiBundle.message("microprofile.starter.selected.specifications.label", new Object[0]));
        $this$apply.setNoDependenciesSelectedLabel(CdiBundle.message("microprofile.starter.no.selected.specifications.hint", new Object[0]));
        return customizedMessages;
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.listOf((Object)"readme.md");
    }

    @NotNull
    protected WebStarterInitialStep createOptionsStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new WebStarterInitialStep(this, contextProvider, contextProvider){
            private final List<MicroprofileRuntime> runtimes;
            private final GraphProperty<MicroprofileRuntime> runtimeProperty;
            final /* synthetic */ MicroprofileModuleBuilder this$0;
            final /* synthetic */ WebStarterContextProvider $contextProvider;

            protected void addFieldsBefore(@NotNull LayoutBuilder layout) {
                Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
                super.addFieldsAfter(layout);
                DefaultComboBoxModel<E> runtimesModel = new DefaultComboBoxModel<E>();
                runtimesModel.addAll(this.runtimes);
                RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)layout), (String)CdiBundle.message("microprofile.starter.runtime.label", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this, runtimesModel){
                    final /* synthetic */ createOptionsStep.1 this$0;
                    final /* synthetic */ DefaultComboBoxModel $runtimesModel;

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        $this$row.comboBox((ComboBoxModel)this.$runtimesModel, createOptionsStep.1.access$getRuntimeProperty$p(this.this$0), (ListCellRenderer)SimpleListCellRenderer.create((String)"", (Function)createOptionsStep.addFieldsBefore.1.INSTANCE)).growPolicy(GrowPolicy.MEDIUM_TEXT);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$runtimesModel = defaultComboBoxModel;
                        super(1);
                    }
                }), (int)2, null).largeGapAfter();
            }

            public void updateDataModel() {
                super.updateDataModel();
                this.getStarterContext().putUserData(this.this$0.getMP_RUNTIME_KEY(), this.runtimeProperty.get());
            }
            {
                this.this$0 = this$0;
                this.$contextProvider = $captured_local_variable$1;
                super($super_call_param$2);
                this.runtimes = CollectionsKt.shuffled((Iterable)CollectionsKt.listOf((Object[])new MicroprofileRuntime[]{new MicroprofileRuntime("HELIDON", "Helidon"), new MicroprofileRuntime("QUARKUS", "Quarkus"), new MicroprofileRuntime("KUMULUZEE", "KumuluzEE"), new MicroprofileRuntime("LIBERTY", "Open Liberty"), new MicroprofileRuntime("PAYARA_MICRO", "Payara Micro"), new MicroprofileRuntime("TOMEE", "Apache TomEE"), new MicroprofileRuntime("WILDFLY", "WildFly")}));
                this.runtimeProperty = GraphPropertyImpl.Companion.graphProperty(this.getPropertyGraph(), (Function0)new Function0<MicroprofileRuntime>(this){
                    final /* synthetic */ createOptionsStep.1 this$0;

                    @NotNull
                    public final MicroprofileRuntime invoke() {
                        return (MicroprofileRuntime)CollectionsKt.first((List)createOptionsStep.1.access$getRuntimes$p(this.this$0));
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }

            public static final /* synthetic */ GraphProperty access$getRuntimeProperty$p(createOptionsStep.1 $this) {
                return $this.runtimeProperty;
            }

            public static final /* synthetic */ List access$getRuntimes$p(createOptionsStep.1 $this) {
                return $this.runtimes;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv5;
        Iterable $this$map$iv;
        Object line;
        Iterable $this$mapTo$iv$iv2;
        Object destination$iv$iv;
        Object $this$map$iv2;
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        JsonObject serversJson = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/api/supportMatrix/servers"), null, (int)2, null).getAsJsonObject();
        boolean bl = false;
        Set mpVersions = new LinkedHashSet();
        boolean bl2 = false;
        List runtimesVersions = new ArrayList();
        JsonElement jsonElement = serversJson.get("configs");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"serversJson.get(\"configs\")");
        JsonObject configsNode = jsonElement.getAsJsonObject();
        for (Map.Entry runtimeEntry : configsNode.entrySet()) {
            String runtimeId = (String)runtimeEntry.getKey();
            Object v = runtimeEntry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"runtimeEntry.value");
            object3 = ((JsonElement)v).getAsJsonArray().iterator();
            while (object3.hasNext()) {
                void $this$mapTo$iv$iv3;
                Object item$iv$iv2;
                void $this$mapTo$iv$iv4;
                JsonElement versionEntry;
                JsonElement jsonElement2 = versionEntry = (JsonElement)object3.next();
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"versionEntry");
                JsonObject versionNode = jsonElement2.getAsJsonObject();
                JsonElement jsonElement3 = versionNode.get("mpVersion");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"versionNode.get(\"mpVersion\")");
                String mpVersion = jsonElement3.getAsString();
                JsonElement jsonElement4 = versionNode.get("mpSpecs");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"versionNode.get(\"mpSpecs\")");
                JsonArray jsonArray = jsonElement4.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"versionNode.get(\"mpSpecs\").asJsonArray");
                Iterable $this$map$iv3 = (Iterable)jsonArray;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv3;
                Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                    void it;
                    JsonElement jsonElement5 = (JsonElement)item$iv$iv2;
                    object2 = destination$iv$iv2;
                    boolean bl3 = false;
                    void v6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                    object = v6.getAsString();
                    object2.add(object);
                }
                Set mpSpecs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                JsonElement jsonElement6 = versionNode.get("javaSEVersions");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"versionNode.get(\"javaSEVersions\")");
                JsonArray jsonArray2 = jsonElement6.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray2, (String)"versionNode.get(\"javaSEVersions\").asJsonArray");
                $this$map$iv2 = (Iterable)jsonArray2;
                boolean $i$f$map2 = false;
                destination$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo22 = false;
                item$iv$iv2 = $this$mapTo$iv$iv3.iterator();
                while (item$iv$iv2.hasNext()) {
                    void it;
                    Object item$iv$iv3 = item$iv$iv2.next();
                    JsonElement bl3 = (JsonElement)item$iv$iv3;
                    object2 = destination$iv$iv;
                    boolean bl4 = false;
                    void v9 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"it");
                    object = v9.getAsString();
                    object2.add(object);
                }
                Set javaVersions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                String string = runtimeId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runtimeId");
                String string2 = mpVersion;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mpVersion");
                runtimesVersions.add(new MicroprofileRuntimeVersion(string, string2, mpSpecs, javaVersions));
                mpVersions.add(mpVersion);
            }
        }
        JsonElement jsonElement7 = serversJson.get("descriptions");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"serversJson.get(\"descriptions\")");
        JsonObject descriptionsNode = jsonElement7.getAsJsonObject();
        Set set = descriptionsNode.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"descriptionsNode.entrySet()");
        Iterable $this$map$iv4 = set;
        boolean $i$f$map = false;
        object3 = $this$map$iv4;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            $this$map$iv2 = (Map.Entry)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl5 = false;
            Object object4 = (JsonElement)it.getValue();
            if (object4 == null || (object4 = object4.getAsString()) == null) {
                object4 = "";
            }
            line = object4;
            destination$iv$iv = StringsKt.substringBefore$default((String)line, (String)"-", null, (int)2, null);
            boolean $i$f$mapTo22 = false;
            String string = destination$iv$iv;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String title = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String $i$f$mapTo22 = StringsKt.substringAfter$default((String)line, (String)"-", null, (int)2, null);
            boolean item$iv$iv3 = false;
            String string3 = $i$f$mapTo22;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String description = StringsKt.capitalize((String)((Object)StringsKt.trim((CharSequence)string3)).toString());
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            object = new WebStarterDependency((String)k, title, description, null, false, false, 56, null);
            object2.add(object);
        }
        List specifications = (List)destination$iv$iv3;
        WebStarterDependencyCategory category = new WebStarterDependencyCategory("MicroProfile", this.filterSpecifications(specifications));
        $this$mapTo$iv$iv2 = mpVersions;
        boolean $i$f$map3 = false;
        void $i$f$mapTo32 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            void it;
            line = (String)item$iv$iv;
            object2 = destination$iv$iv4;
            boolean bl6 = false;
            String code = StringsKt.removePrefix((String)it, (CharSequence)"MP");
            String versionNumber = code.length() == 2 ? "" + code.charAt(0) + '.' + code.charAt(1) : code;
            object = new WebStarterFrameworkVersion((String)it, versionNumber, false);
            object2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv4;
        boolean $i$f$sortedByDescending22 = false;
        boolean $this$mapTo$iv$iv5 = false;
        List frameworkVersions = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                WebStarterFrameworkVersion it = (WebStarterFrameworkVersion)b;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (WebStarterFrameworkVersion)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getId();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        WebStarterServerOptions options = new WebStarterServerOptions(frameworkVersions, CollectionsKt.listOf((Object)category));
        Iterable $i$f$sortedByDescending22 = runtimesVersions;
        object = this.MP_RUNTIME_SUPPORT_MAP_KEY;
        object2 = options;
        boolean $i$f$groupBy = false;
        destination$iv$iv4 = $this$groupBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object5;
            MicroprofileRuntimeVersion it = (MicroprofileRuntimeVersion)element$iv$iv;
            boolean bl7 = false;
            String key$iv$iv = it.getRuntimeId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl8 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv5;
        object2.putUserData((Key)object, (Object)map);
        return options;
    }

    @NotNull
    protected Url composeGeneratorUrl(@NotNull String serverUrl, @NotNull WebStarterContext starterContext) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
        Url url = Urls.newFromEncoded((String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/api/project"));
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"groupId", (Object)starterContext.getGroup());
        pairArray[1] = TuplesKt.to((Object)"artifactId", (Object)starterContext.getArtifact());
        WebStarterFrameworkVersion webStarterFrameworkVersion = starterContext.getFrameworkVersion();
        Intrinsics.checkNotNull((Object)webStarterFrameworkVersion);
        pairArray[2] = TuplesKt.to((Object)"mpVersion", (Object)webStarterFrameworkVersion.getId());
        Object object = starterContext.getUserData(this.MP_RUNTIME_KEY);
        Intrinsics.checkNotNull((Object)object);
        pairArray[3] = TuplesKt.to((Object)"supportedServer", (Object)((MicroprofileRuntime)object).getId());
        Url url2 = url.addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"url.addParameters(mapOf(\u2026_RUNTIME_KEY)!!.id\n    ))");
        url = url2;
        for (WebStarterDependency dependency : starterContext.getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)url.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"selectedSpecs", (Object)dependency.getId()))), (String)"url.addParameters(mapOf(\u2026Specs\" to dependency.id))");
        }
        return url;
    }

    protected void extractGeneratorResult(@NotNull File tempZipFile, @NotNull File contentEntryDir) {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        WebStarterSettings.unzipSubfolder((File)tempZipFile, (File)contentEntryDir);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected DependencyState getDependencyState(@NotNull WebStarterFrameworkVersion frameworkVersion, @NotNull WebStarterDependency dependency) {
        String message;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MicroprofileRuntimeVersion it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv2;
        boolean bl;
        List runtimeInfo;
        MicroprofileRuntime runtime;
        block8: {
            Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Object object = this.getStarterContext().getServerOptions().getUserData(this.MP_RUNTIME_SUPPORT_MAP_KEY);
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"starterContext.serverOpt\u2026UNTIME_SUPPORT_MAP_KEY)!!");
            Map mpRuntimesInfo = (Map)object;
            Object object2 = this.getStarterContext().getUserData(this.MP_RUNTIME_KEY);
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"starterContext.getUserData(MP_RUNTIME_KEY)!!");
            runtime = (MicroprofileRuntime)object2;
            List list = (List)mpRuntimesInfo.get(runtime.getId());
            if (list == null) {
                return (DependencyState)DependencyAvailable.INSTANCE;
            }
            runtimeInfo = list;
            Iterable $this$any$iv = runtimeInfo;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    MicroprofileRuntimeVersion it2 = (MicroprofileRuntimeVersion)element$iv2;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it2.getMpVersion(), (Object)frameworkVersion.getId()) && it2.getCompatibleSpecifications().contains(dependency.getId()))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return (DependencyState)DependencyAvailable.INSTANCE;
        }
        Iterable $i$f$any = runtimeInfo;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MicroprofileRuntimeVersion)element$iv$iv;
            boolean bl3 = false;
            if (!it.getCompatibleSpecifications().contains(dependency.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MicroprofileRuntimeVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            String string = it.getMpVersion();
            collection.add(string);
        }
        List versions = (List)destination$iv$iv;
        if (versions.isEmpty()) {
            String string = CdiBundle.message("message.specification.is.not.supported.by.runtime", runtime.getTitle());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CdiBundle.message(\"messa\u2026.runtime\", runtime.title)");
            message = string;
            String string2 = CdiBundle.message("message.specification.is.not.supported.hint", runtime.getTitle());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CdiBundle.message(\"messa\u2026ted.hint\", runtime.title)");
            String hint = string2;
            return (DependencyState)new DependencyUnavailable(message, hint);
        }
        String string = CdiBundle.message("message.specification.is.not.supported.by.version.but.supported.by.versions", frameworkVersion.getId(), versions);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CdiBundle.message(\"messa\u2026workVersion.id, versions)");
        message = string;
        String string3 = CdiBundle.message("message.specification.supported.hint", CollectionsKt.joinToString$default((Iterable)versions, null, null, null, (int)0, null, null, (int)63, null));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"CdiBundle.message(\"messa\u2026 versions.joinToString())");
        String hint = string3;
        return (DependencyState)new DependencyUnavailable(message, hint);
    }

    protected boolean isVersionAvailable(@NotNull WebStarterFrameworkVersion frameworkVersion) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
            Object object = this.getStarterContext().getServerOptions().getUserData(this.MP_RUNTIME_SUPPORT_MAP_KEY);
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"starterContext.serverOpt\u2026UNTIME_SUPPORT_MAP_KEY)!!");
            Map mpRuntimesInfo = (Map)object;
            Object object2 = this.getStarterContext().getUserData(this.MP_RUNTIME_KEY);
            Intrinsics.checkNotNull((Object)object2);
            String mpRuntimeId = ((MicroprofileRuntime)object2).getId();
            List list = (List)mpRuntimesInfo.get(mpRuntimeId);
            if (list == null) {
                return true;
            }
            List runtimeInfo = list;
            Iterable $this$any$iv = runtimeInfo;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MicroprofileRuntimeVersion it = (MicroprofileRuntimeVersion)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getMpVersion(), (Object)frameworkVersion.getId())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public MicroprofileModuleBuilder() {
        Key key = Key.create((String)"MP_RUNTIME_SUPPORT_MAP");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"MP_RUNTIME_SUPPORT_MAP\")");
        this.MP_RUNTIME_SUPPORT_MAP_KEY = key;
        Key key2 = Key.create((String)"MP_RUNTIME");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"MP_RUNTIME\")");
        this.MP_RUNTIME_KEY = key2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/cdi/microprofile/MicroprofileModuleBuilder$MicroprofileRuntime;", "", "id", "", "title", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getTitle", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javaee.cdi"})
    public static final class MicroprofileRuntime {
        @NotNull
        private final String id;
        @NotNull
        private final String title;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        public MicroprofileRuntime(@NotNull String id, @NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            this.id = id;
            this.title = title;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.title;
        }

        @NotNull
        public final MicroprofileRuntime copy(@NotNull String id, @NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            return new MicroprofileRuntime(id, title);
        }

        public static /* synthetic */ MicroprofileRuntime copy$default(MicroprofileRuntime microprofileRuntime, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = microprofileRuntime.id;
            }
            if ((n & 2) != 0) {
                string2 = microprofileRuntime.title;
            }
            return microprofileRuntime.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MicroprofileRuntime(id=" + this.id + ", title=" + this.title + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.title;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MicroprofileRuntime)) break block3;
                    MicroprofileRuntime microprofileRuntime = (MicroprofileRuntime)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)microprofileRuntime.id) || !Intrinsics.areEqual((Object)this.title, (Object)microprofileRuntime.title)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J=\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/cdi/microprofile/MicroprofileModuleBuilder$MicroprofileRuntimeVersion;", "", "runtimeId", "", "mpVersion", "compatibleSpecifications", "", "javaVersions", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;)V", "getCompatibleSpecifications", "()Ljava/util/Set;", "getJavaVersions", "getMpVersion", "()Ljava/lang/String;", "getRuntimeId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javaee.cdi"})
    public static final class MicroprofileRuntimeVersion {
        @NotNull
        private final String runtimeId;
        @NotNull
        private final String mpVersion;
        @NotNull
        private final Set<String> compatibleSpecifications;
        @NotNull
        private final Set<String> javaVersions;

        @NotNull
        public final String getRuntimeId() {
            return this.runtimeId;
        }

        @NotNull
        public final String getMpVersion() {
            return this.mpVersion;
        }

        @NotNull
        public final Set<String> getCompatibleSpecifications() {
            return this.compatibleSpecifications;
        }

        @NotNull
        public final Set<String> getJavaVersions() {
            return this.javaVersions;
        }

        public MicroprofileRuntimeVersion(@NotNull String runtimeId, @NotNull String mpVersion, @NotNull Set<String> compatibleSpecifications, @NotNull Set<String> javaVersions) {
            Intrinsics.checkNotNullParameter((Object)runtimeId, (String)"runtimeId");
            Intrinsics.checkNotNullParameter((Object)mpVersion, (String)"mpVersion");
            Intrinsics.checkNotNullParameter(compatibleSpecifications, (String)"compatibleSpecifications");
            Intrinsics.checkNotNullParameter(javaVersions, (String)"javaVersions");
            this.runtimeId = runtimeId;
            this.mpVersion = mpVersion;
            this.compatibleSpecifications = compatibleSpecifications;
            this.javaVersions = javaVersions;
        }

        @NotNull
        public final String component1() {
            return this.runtimeId;
        }

        @NotNull
        public final String component2() {
            return this.mpVersion;
        }

        @NotNull
        public final Set<String> component3() {
            return this.compatibleSpecifications;
        }

        @NotNull
        public final Set<String> component4() {
            return this.javaVersions;
        }

        @NotNull
        public final MicroprofileRuntimeVersion copy(@NotNull String runtimeId, @NotNull String mpVersion, @NotNull Set<String> compatibleSpecifications, @NotNull Set<String> javaVersions) {
            Intrinsics.checkNotNullParameter((Object)runtimeId, (String)"runtimeId");
            Intrinsics.checkNotNullParameter((Object)mpVersion, (String)"mpVersion");
            Intrinsics.checkNotNullParameter(compatibleSpecifications, (String)"compatibleSpecifications");
            Intrinsics.checkNotNullParameter(javaVersions, (String)"javaVersions");
            return new MicroprofileRuntimeVersion(runtimeId, mpVersion, compatibleSpecifications, javaVersions);
        }

        public static /* synthetic */ MicroprofileRuntimeVersion copy$default(MicroprofileRuntimeVersion microprofileRuntimeVersion, String string, String string2, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                string = microprofileRuntimeVersion.runtimeId;
            }
            if ((n & 2) != 0) {
                string2 = microprofileRuntimeVersion.mpVersion;
            }
            if ((n & 4) != 0) {
                set = microprofileRuntimeVersion.compatibleSpecifications;
            }
            if ((n & 8) != 0) {
                set2 = microprofileRuntimeVersion.javaVersions;
            }
            return microprofileRuntimeVersion.copy(string, string2, set, set2);
        }

        @NotNull
        public String toString() {
            return "MicroprofileRuntimeVersion(runtimeId=" + this.runtimeId + ", mpVersion=" + this.mpVersion + ", compatibleSpecifications=" + this.compatibleSpecifications + ", javaVersions=" + this.javaVersions + ")";
        }

        public int hashCode() {
            String string = this.runtimeId;
            String string2 = this.mpVersion;
            Set<String> set = this.compatibleSpecifications;
            Set<String> set2 = this.javaVersions;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MicroprofileRuntimeVersion)) break block3;
                    MicroprofileRuntimeVersion microprofileRuntimeVersion = (MicroprofileRuntimeVersion)object;
                    if (!Intrinsics.areEqual((Object)this.runtimeId, (Object)microprofileRuntimeVersion.runtimeId) || !Intrinsics.areEqual((Object)this.mpVersion, (Object)microprofileRuntimeVersion.mpVersion) || !Intrinsics.areEqual(this.compatibleSpecifications, microprofileRuntimeVersion.compatibleSpecifications) || !Intrinsics.areEqual(this.javaVersions, microprofileRuntimeVersion.javaVersions)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

