/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.manager;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.common.persistence.JavaeePersistenceConstants;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiManager {
    public static final List<JavaeeClass> BUILD_IN_CLASSES = List.of(CdiClassesConstants.BEAN_MANAGER, CdiClassesConstants.REQUEST_CONTEXT_CONTROLLER, CdiClassesConstants.INTERCEPTION_FACTORY, WebCommonClassNames.HTTP_SERVLET_REQUEST, WebCommonClassNames.HTTP_SESSION, CdiClassesConstants.JMS_CONTEXT, CdiClassesConstants.JOB_CONTEXT, CdiClassesConstants.STEP_CONTEXT, CdiClassesConstants.SECURITY_PRINCIPAL, WebCommonClassNames.SERVLET_CONTEXT, CdiClassesConstants.USER_TRANSACTION, CdiClassesConstants.VALIDATION_FACTORY, CdiClassesConstants.VALIDATOR, CdiClassesConstants.FLOW_BUILDER, JavaeePersistenceConstants.PERSISTENCE_CONTEXT_CLASS, CdiClassesConstants.FACES_CONTEXT_CLASS);
    public static final List<JavaeeClass> IMPLICIT_PRODUCES_ANNOTATIONS = List.of(CdiAnnoConstants.APPLICATION_SCOPED_ANNOTATION, CdiAnnoConstants.SESSION_SCOPED_ANNOTATION, CdiAnnoConstants.REQUEST_SCOPED_ANNOTATION, CdiAnnoConstants.SINGLETON_ANNOTATION);
    private static final Set<String> IGNORED_BINDING_ANNOTATIONS = Set.of(CdiAnnoConstants.DEFAULT_ANNOTATION.jakarta(), CdiAnnoConstants.DEFAULT_ANNOTATION.javax(), CdiAnnoConstants.ANY_ANNOTATION.jakarta(), CdiAnnoConstants.ANY_ANNOTATION.javax(), CdiAnnoConstants.NEW_ANNOTATION.jakarta(), CdiAnnoConstants.NEW_ANNOTATION.javax());

    @NotNull
    public static Set<CdiBeanDescriptor<?>> resolveBeanByType(@NotNull PsiModifierListOwner psiMember, @NotNull Module module, PsiType type) {
        if (psiMember == null) {
            CdiManager.$$$reportNull$$$0(0);
        }
        if (module == null) {
            CdiManager.$$$reportNull$$$0(1);
        }
        PsiAnnotation[] bindingTypes = CdiCommonUtils.getQualifierAnnotations(psiMember);
        if (type instanceof PsiArrayType) {
            Set<CdiBeanDescriptor<?>> set = CdiManager.resolveProducesBeans(module, type, bindingTypes);
            if (set == null) {
                CdiManager.$$$reportNull$$$0(2);
            }
            return set;
        }
        PsiClass originalPsiClass = CdiCommonUtils.getOriginalPsiClass(type, module);
        if (originalPsiClass != null) {
            PsiClass containingClass;
            Set<CdiBeanDescriptor<?>> descriptors = CdiManager.resolveBeanByClass(module, originalPsiClass, bindingTypes);
            if (CdiAnnoConstants.DELEGATE_ANNOTATION.isAnnotated(psiMember, 1) && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMember, PsiClass.class, (boolean)false)) != null) {
                Set<CdiBeanDescriptor<?>> set = CdiManager.filterDecoratorDescriptors(descriptors, containingClass);
                if (set == null) {
                    CdiManager.$$$reportNull$$$0(3);
                }
                return set;
            }
            Set<CdiBeanDescriptor<?>> set = descriptors;
            if (set == null) {
                CdiManager.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<CdiBeanDescriptor<?>> set = Collections.emptySet();
        if (set == null) {
            CdiManager.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static Set<CdiBeanDescriptor<?>> filterDecoratorDescriptors(@NotNull Set<CdiBeanDescriptor<?>> descriptors, @NotNull PsiClass aClass) {
        if (descriptors == null) {
            CdiManager.$$$reportNull$$$0(6);
        }
        if (aClass == null) {
            CdiManager.$$$reportNull$$$0(7);
        }
        HashSet nonDecorators = new HashSet();
        for (CdiBeanDescriptor<?> descriptor : descriptors) {
            if (aClass.equals(descriptor.getIdentifyingElement())) continue;
            nonDecorators.add(descriptor);
        }
        return nonDecorators;
    }

    @NotNull
    public static Set<CdiBeanDescriptor<?>> resolveBeanByClass(@NotNull Module module, @Nullable PsiClass psiClass, PsiAnnotation ... bindings) {
        if (module == null) {
            CdiManager.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            Set<CdiBeanDescriptor<?>> set = Collections.emptySet();
            if (set == null) {
                CdiManager.$$$reportNull$$$0(9);
            }
            return set;
        }
        HashSet descriptors = new HashSet();
        Set<CdiBeanDescriptor<?>> cdiBeanDescriptors = CdiManager.resolvePsiClassBeans(module, psiClass, bindings);
        for (CdiBeanDescriptor<?> beanDescriptor : cdiBeanDescriptors) {
            CdiBeanDescriptor<?> specializes = CdiManager.getSpecializes(module, beanDescriptor);
            descriptors.add(specializes == null ? beanDescriptor : specializes);
        }
        PsiClassType resolveType = JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(psiClass);
        descriptors.addAll(CdiManager.resolveProducesBeans(module, (PsiType)resolveType, bindings));
        descriptors.addAll(CdiManager.resolveExtensionBeanDescriptors(psiClass));
        Set<CdiBeanDescriptor<?>> set = CdiManager.filterTypedCandidates(psiClass, descriptors);
        if (set == null) {
            CdiManager.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> resolveExtensionBeanDescriptors(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(11);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
        Set<CdiExtensionBeanDescriptor> set = CdiCommonUtils.collectExtensionBeanDescriptors(psiClass.getProject()).stream().filter(descriptor -> {
            for (PsiType psiType : descriptor.getSupportedTypes()) {
                if (!psiClassType.isAssignableFrom(psiType)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (set == null) {
            CdiManager.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Nullable
    private static CdiBeanDescriptor<?> getSpecializes(@NotNull Module module, @NotNull CdiBeanDescriptor<?> candidate) {
        if (module == null) {
            CdiManager.$$$reportNull$$$0(13);
        }
        if (candidate == null) {
            CdiManager.$$$reportNull$$$0(14);
        }
        if (candidate instanceof ManagedBeanDescriptor) {
            PsiClass candidateClass = (PsiClass)((ManagedBeanDescriptor)candidate).getIdentifyingElement();
            for (CdiSpecializes<?> specializes : CdiJamModel.getModel(module).getSpecializeses()) {
                PsiClass specializedClass;
                if (!(specializes instanceof CdiSpecializes.ClassMapping) || !candidateClass.equals(specializedClass = ((CdiSpecializes.ClassMapping)specializes).getSpecializedMember())) continue;
                return CdiDescriptorsFactory.createCdiBeanDescriptor((PsiClass)((CdiSpecializes.ClassMapping)specializes).getPsiElement());
            }
        }
        return null;
    }

    private static Set<CdiBeanDescriptor<?>> filterTypedCandidates(@NotNull PsiClass psiClass, @NotNull Set<CdiBeanDescriptor<?>> descriptors) {
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            CdiManager.$$$reportNull$$$0(16);
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return descriptors;
        }
        HashSet filtered = new HashSet();
        block0: for (CdiBeanDescriptor<?> descriptor : descriptors) {
            PsiAnnotation annotation = CdiManager.getAnnotation(descriptor, CdiAnnoConstants.TYPED_ANNOTATION.fqnFromAnnotated((PsiModifierListOwner)psiClass));
            if (annotation != null) {
                List values = AnnotationModelUtil.getPsiClassArrayValue((PsiAnnotation)annotation, (String)"value");
                if (values.isEmpty()) continue;
                for (AnnotationGenericValue genericValue : values) {
                    PsiClass typedClass = (PsiClass)genericValue.getValue();
                    if (typedClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)typedClass, (PsiClass)psiClass, (boolean)true)) continue;
                    filtered.add(descriptor);
                    continue block0;
                }
                continue;
            }
            filtered.add(descriptor);
        }
        return filtered;
    }

    @Nullable
    private static PsiAnnotation getAnnotation(@NotNull CdiBeanDescriptor<?> descriptor, String anno) {
        Object identifyingElement;
        if (descriptor == null) {
            CdiManager.$$$reportNull$$$0(17);
        }
        return (identifyingElement = descriptor.getIdentifyingElement()) instanceof PsiMember ? AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)identifyingElement), (String[])new String[]{anno}) : null;
    }

    private static Set<CdiBeanDescriptor<?>> resolveProducesBeans(@NotNull Module module, @NotNull PsiType psiType, PsiAnnotation[] bindings) {
        PsiClass producesAnnoClass;
        if (module == null) {
            CdiManager.$$$reportNull$$$0(18);
        }
        if (psiType == null) {
            CdiManager.$$$reportNull$$$0(19);
        }
        if ((producesAnnoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(CdiAnnoConstants.PRODUCES_ANNOTATION.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) == null) {
            return Collections.emptySet();
        }
        HashSet candidates = new HashSet();
        HashSet implicitCandidates = new HashSet();
        BiConsumer<PsiMember, Collection> candidateHandler = (candidate, collection) -> {
            PsiType productType = CdiManager.getProductType(candidate);
            if (productType != null && CdiManager.isAssignable(module, productType, psiType) && CdiManager.hasAnnotated((PsiModifierListOwner)candidate, bindings)) {
                collection.add(candidate);
            }
        };
        Query query = AnnotatedMembersSearch.search((PsiClass)producesAnnoClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        query.forEach(candidate -> candidateHandler.accept((PsiMember)candidate, candidates));
        CdiManager.collectImplicitProduces(module).forEach(candidate -> candidateHandler.accept((PsiMember)candidate, implicitCandidates));
        Set descriptors = ContainerUtil.map2SetNotNull(candidates, CdiDescriptorsFactory::createProducerCdiBeanDescriptor);
        Set implicitDescriptors = ContainerUtil.map2SetNotNull(implicitCandidates, psiMember -> CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiMember, true));
        return ContainerUtil.union((Set)descriptors, (Set)implicitDescriptors);
    }

    private static Collection<PsiMember> collectImplicitProduces(@NotNull Module module) {
        CdiCustomizationProvider cdiCustomization;
        if (module == null) {
            CdiManager.$$$reportNull$$$0(20);
        }
        if ((cdiCustomization = CdiCustomizationManager.getCustomization(module)) == null || !cdiCustomization.isImplicitProducesEnabled()) {
            return Collections.emptyList();
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        HashSet<PsiMember> implicitProduces = new HashSet<PsiMember>();
        for (JavaeeClass annoClass : IMPLICIT_PRODUCES_ANNOTATIONS) {
            implicitProduces.addAll(CdiManager.getCachedAnnotatedMethods(module, annoClass, searchScope));
        }
        return implicitProduces;
    }

    private static Collection<PsiMethod> getCachedAnnotatedMethods(@NotNull Module module, @NotNull JavaeeClass annoClass, @NotNull GlobalSearchScope searchScope) {
        if (module == null) {
            CdiManager.$$$reportNull$$$0(21);
        }
        if (annoClass == null) {
            CdiManager.$$$reportNull$$$0(22);
        }
        if (searchScope == null) {
            CdiManager.$$$reportNull$$$0(23);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(key -> CdiManager.searchAnnotatedMethods(module, key, searchScope));
            return new CachedValueProvider.Result((Object)factoryMap, new Object[]{UastModificationTracker.getInstance((Project)module.getProject())});
        });
        return (Collection)map.get(annoClass);
    }

    private static Collection<PsiMethod> searchAnnotatedMethods(@NotNull Module module, @NotNull JavaeeClass annoClass, @NotNull GlobalSearchScope searchScope) {
        JavaPsiFacade javaPsiFacade;
        PsiClass annoPsiClass;
        if (module == null) {
            CdiManager.$$$reportNull$$$0(24);
        }
        if (annoClass == null) {
            CdiManager.$$$reportNull$$$0(25);
        }
        if (searchScope == null) {
            CdiManager.$$$reportNull$$$0(26);
        }
        if ((annoPsiClass = (javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass(annoClass.fqn(module), searchScope)) == null) {
            return Collections.emptyList();
        }
        return AnnotatedElementsSearch.searchPsiMethods((PsiClass)annoPsiClass, (SearchScope)searchScope).findAll();
    }

    private static boolean isAssignable(@NotNull Module module, PsiType productType, PsiType psiType) {
        if (module == null) {
            CdiManager.$$$reportNull$$$0(27);
        }
        if (productType instanceof PsiArrayType) {
            return psiType.isAssignableFrom(productType);
        }
        PsiClass originalProductClass = CdiCommonUtils.getOriginalPsiClass(productType, module);
        if (originalProductClass != null) {
            PsiClassType originalProductType = JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(originalProductClass);
            return psiType.isAssignableFrom((PsiType)originalProductType);
        }
        return false;
    }

    @Nullable
    private static PsiType getProductType(@Nullable PsiMember candidate) {
        if (candidate instanceof PsiField) {
            return ((PsiField)candidate).getType();
        }
        if (candidate instanceof PsiMethod) {
            return ((PsiMethod)candidate).getReturnType();
        }
        return null;
    }

    private static Set<? extends CdiBeanDescriptor<?>> resolvePsiClassBeans(@NotNull Module module, @NotNull PsiClass psiClass, PsiAnnotation[] bindings) {
        String qualifiedName;
        if (module == null) {
            CdiManager.$$$reportNull$$$0(28);
        }
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(29);
        }
        if ("java.lang.Object".equals(qualifiedName = psiClass.getQualifiedName())) {
            return CdiManager.resolveJavaLangObjectBeans(module, psiClass, bindings);
        }
        if (bindings.length == 0 && BUILD_IN_CLASSES.stream().map(aClass -> aClass.fqn(module)).collect(Collectors.toSet()).contains(qualifiedName) || CdiClassesConstants.INJECTION_POINT_CLASS.fqn(module).equals(qualifiedName)) {
            return Collections.singleton(CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass));
        }
        HashSet<PsiClass> candidates = new HashSet<PsiClass>();
        Processor processor2 = candidate -> {
            if (CdiCommonUtils.isAppropriateBeanCandidate(candidate) && CdiManager.hasAnnotated((PsiModifierListOwner)candidate, bindings)) {
                candidates.add((PsiClass)candidate);
            }
            return true;
        };
        processor2.process((Object)psiClass);
        Query classQuery = ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), (boolean)true);
        classQuery.forEach(processor2);
        if (bindings.length == 0 && CdiCommonUtils.isAppropriateBeanCandidate(psiClass)) {
            candidates.add(psiClass);
        }
        return ContainerUtil.map2SetNotNull(candidates, CdiDescriptorsFactory::createCdiBeanDescriptor);
    }

    private static Set<? extends CdiBeanDescriptor<?>> resolveJavaLangObjectBeans(@NotNull Module module, @NotNull PsiClass psiClass, PsiAnnotation[] bindings) {
        if (module == null) {
            CdiManager.$$$reportNull$$$0(30);
        }
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(31);
        }
        if (bindings.length == 0) {
            return Collections.singleton(CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass));
        }
        HashSet candidates = new HashSet();
        Processor processor2 = candidate -> {
            if (CdiCommonUtils.isAppropriateBeanCandidate(candidate) && InheritanceUtil.isInheritorOrSelf((PsiClass)candidate, (PsiClass)psiClass, (boolean)true) && CdiManager.hasAnnotated((PsiModifierListOwner)candidate, bindings)) {
                candidates.add(candidate);
            }
            return true;
        };
        PsiClass annotationClass = CdiManager.getAnnotationClass(bindings);
        if (annotationClass != null) {
            Query query = AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            query.forEach(processor2);
        }
        return ContainerUtil.map2SetNotNull(candidates, CdiDescriptorsFactory::createCdiBeanDescriptor);
    }

    @Nullable
    private static PsiClass getAnnotationClass(PsiAnnotation[] bindings) {
        for (PsiAnnotation binding : bindings) {
            PsiClass aClass;
            String qualifiedName = binding.getQualifiedName();
            if (qualifiedName == null || (aClass = JavaPsiFacade.getInstance((Project)binding.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)binding.getProject()))) == null) continue;
            return aClass;
        }
        return null;
    }

    public static boolean hasAnnotated(@Nullable PsiModifierListOwner candidate, PsiAnnotation[] bindings) {
        if (candidate == null) {
            return false;
        }
        if (CdiManager.isDefaultAnnotations(bindings)) {
            return CdiManager.hasImplicitDefaultAnnotation(candidate);
        }
        for (PsiAnnotation bindingAnnotation : bindings) {
            String qualifiedName = CdiCommonUtils.getQualifierBeanAnnotation(bindingAnnotation.getProject(), bindingAnnotation.getQualifiedName());
            if (qualifiedName == null) {
                return false;
            }
            if (CdiAnnoConstants.ANY_ANNOTATION.isFqn(qualifiedName)) continue;
            PsiAnnotation candidateAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)candidate, (String[])new String[]{qualifiedName});
            if (candidateAnnotation == null) {
                return false;
            }
            if (CdiAnnoConstants.NAMED_ANNOTATION.isFqn(qualifiedName)) {
                if (CdiManager.getNamedValueOrDefault(bindingAnnotation).equals(CdiManager.getNamedValueOrDefault(candidateAnnotation))) continue;
                return false;
            }
            for (Pair<String, PsiAnnotationMemberValue> pair : CdiManager.getNonBindingAttributes(bindingAnnotation)) {
                if (CdiManager.hasAttributeValue(candidateAnnotation, (String)pair.getFirst(), (PsiAnnotationMemberValue)pair.getSecond())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static String getNamedValueOrDefault(@NotNull PsiAnnotation psiAnnotation) {
        String value;
        if (psiAnnotation == null) {
            CdiManager.$$$reportNull$$$0(32);
        }
        if (StringUtil.isNotEmpty((String)(value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)psiAnnotation, (String)"value")))) {
            String string = value;
            if (string == null) {
                CdiManager.$$$reportNull$$$0(33);
            }
            return string;
        }
        PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMember.class);
        if (psiMember == null) {
            return "";
        }
        String memberName = psiMember.getName();
        return memberName != null ? StringUtil.decapitalize((String)memberName) : "";
    }

    private static boolean isDefaultAnnotations(PsiAnnotation[] bindings) {
        for (PsiAnnotation binding : bindings) {
            if (IGNORED_BINDING_ANNOTATIONS.contains(binding.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Set<Pair<String, PsiAnnotationMemberValue>> getNonBindingAttributes(PsiAnnotation annotation) {
        PsiElement resolved;
        HashSet<Pair<String, PsiAnnotationMemberValue>> pairs = new HashSet<Pair<String, PsiAnnotationMemberValue>>();
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = ((PsiClass)resolved).getMethods()) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)psiMethod) || CdiAnnoConstants.NON_BINDING_ANNOTATION.isAnnotated((PsiModifierListOwner)psiMethod, 0) || CdiAnnoConstants.NONBINDING_ANNOTATION.isAnnotated((PsiModifierListOwner)psiMethod, 0)) continue;
                String attributeName = psiMethod.getName();
                pairs.add((Pair<String, PsiAnnotationMemberValue>)Pair.create((Object)attributeName, (Object)annotation.findAttributeValue(attributeName)));
            }
        }
        HashSet<Pair<String, PsiAnnotationMemberValue>> hashSet = pairs;
        if (hashSet == null) {
            CdiManager.$$$reportNull$$$0(34);
        }
        return hashSet;
    }

    private static boolean hasAttributeValue(@NotNull PsiAnnotation candidateAnnotation, @Nullable String name, @Nullable PsiAnnotationMemberValue value) {
        if (candidateAnnotation == null) {
            CdiManager.$$$reportNull$$$0(35);
        }
        PsiAnnotationMemberValue candidateValue = candidateAnnotation.findAttributeValue(name);
        if (value instanceof PsiReference) {
            if (candidateValue instanceof PsiReference) {
                PsiElement element1 = ((PsiReference)value).resolve();
                PsiElement element2 = ((PsiReference)candidateValue).resolve();
                return element1 != null && element2 != null && element1.equals(element2);
            }
        } else {
            Object attrValue = JamCommonUtil.getObjectValue((PsiElement)value, Object.class);
            Object candidateAttrValue = JamCommonUtil.getObjectValue((PsiElement)candidateValue, Object.class);
            return attrValue != null && candidateAttrValue != null && attrValue.equals(candidateAttrValue);
        }
        return false;
    }

    private static boolean hasImplicitDefaultAnnotation(PsiModifierListOwner candidate) {
        PsiAnnotation[] qualifierAnnotations;
        for (PsiAnnotation binding : qualifierAnnotations = CdiCommonUtils.getQualifierAnnotations(candidate)) {
            String qualifiedName = binding.getQualifiedName();
            if (IGNORED_BINDING_ANNOTATIONS.contains(qualifiedName) || CdiAnnoConstants.NAMED_ANNOTATION.fqn((PsiElement)candidate).equals(qualifiedName)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/manager/CdiManager";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: 
            case 15: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoClass";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/manager/CdiManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBeanByType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBeanByClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveExtensionBeanDescriptors";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedValueOrDefault";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonBindingAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveBeanByType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 33: 
            case 34: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterDecoratorDescriptors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveBeanByClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveExtensionBeanDescriptors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSpecializes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterTypedCandidates";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveProducesBeans";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectImplicitProduces";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedAnnotatedMethods";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "searchAnnotatedMethods";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolvePsiClassBeans";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveJavaLangObjectBeans";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNamedValueOrDefault";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasAttributeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

