/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.jam.CdiSemContributor;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.jam.JamService;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class CdiJamModel {
    private final Module myModule;

    public static CdiJamModel getModel(@NotNull Module module) {
        if (module == null) {
            CdiJamModel.$$$reportNull$$$0(0);
        }
        return new CdiJamModel(module);
    }

    private CdiJamModel(@NotNull Module module) {
        if (module == null) {
            CdiJamModel.$$$reportNull$$$0(1);
        }
        this.myModule = module;
    }

    public List<CdiNamedBean<?>> getNamedBeans() {
        return this.getNamedBeans(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    public List<CdiNamedBean<?>> getNamedBeans(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(2);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList beanCdis = new ArrayList();
        String namedAnno = CdiAnnoConstants.NAMED_ANNOTATION.fqn(this.myModule);
        beanCdis.addAll(service.getJamClassElements(CdiSemContributor.NAMED_JAM_KEY, namedAnno, scope));
        beanCdis.addAll(service.getJamMethodElements(CdiSemContributor.NAMED_JAM_KEY, namedAnno, scope));
        beanCdis.addAll(service.getJamFieldElements(CdiSemContributor.NAMED_JAM_KEY, namedAnno, scope));
        Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(this.myModule, namedAnno);
        for (String annoFQN : CdiCommonUtils.getQualifiedNames(stereotypeAnnotationClasses)) {
            beanCdis.addAll(service.getJamClassElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
            beanCdis.addAll(service.getJamMethodElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
            beanCdis.addAll(service.getJamFieldElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
        }
        return beanCdis;
    }

    public Stream<PsiClass> findAnnotatedBeanClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(3);
        }
        ArrayList<PsiClass> scopeTypeClasses = new ArrayList<PsiClass>(CdiCommonUtils.getNormalScopeTypesClasses(this.myModule));
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        for (String extAnnotation : CdiCustomizationManager.getCustomBeanAnnotations(this.myModule.getProject())) {
            PsiClass extAnnotationClass = javaPsiFacade.findClass(extAnnotation, scope);
            if (extAnnotationClass == null) continue;
            scopeTypeClasses.add(extAnnotationClass);
        }
        return scopeTypeClasses.stream().flatMap(annotation -> {
            if (!annotation.isValid()) {
                return Stream.empty();
            }
            return AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotation, (SearchScope)scope).findAll().stream().filter(psiClass -> psiClass != null && psiClass.isValid());
        });
    }

    public Set<CdiObserves> getObserves() {
        return this.getObserves(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    public Set<CdiObserves> getObserves(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(4);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        JavaeeType javaeeType = JavaeeType.discover((Module)this.myModule, (JavaeeClass)CdiAnnoConstants.INJECT_ANNOTATION);
        HashSet<CdiObserves> observes = new HashSet<CdiObserves>();
        observes.addAll(service.getJamParameterElements(CdiObserves.OBSERVES_JAM_KEY, CdiAnnoConstants.OBSERVES_ANNOTATION.fqn(javaeeType), scope));
        observes.addAll(service.getJamParameterElements(CdiObserves.OBSERVES_JAM_KEY, CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.fqn(javaeeType), scope));
        return observes;
    }

    public List<CdiDispose> getDisposes(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(5);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        return service.getJamParameterElements(CdiDispose.META.getJamKey(), CdiAnnoConstants.DISPOSES_ANNOTATION.fqn(this.myModule), scope);
    }

    @NotNull
    public List<CdiInject<?>> getInjects(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(6);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList injects = new ArrayList();
        injects.addAll(service.getJamFieldElements(CdiInject.INJECT_JAM_KEY, CdiAnnoConstants.INJECT_ANNOTATION.fqn(this.myModule), scope));
        injects.addAll(service.getJamMethodElements(CdiInject.INJECT_JAM_KEY, CdiAnnoConstants.INJECT_ANNOTATION.fqn(this.myModule), scope));
        CdiCustomizationProvider customization = CdiCustomizationManager.getCustomization(this.myModule);
        if (customization != null && customization.isInjectByQualifierEnabled()) {
            Collection<String> qualifierAnnotations = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(this.myModule));
            for (String qualifierAnnotation : qualifierAnnotations) {
                injects.addAll(service.getJamFieldElements(CdiInject.INJECT_JAM_KEY, qualifierAnnotation, scope));
                injects.addAll(service.getJamMethodElements(CdiInject.INJECT_JAM_KEY, qualifierAnnotation, scope));
            }
        }
        ArrayList arrayList = injects;
        if (arrayList == null) {
            CdiJamModel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public List<CdiProduces<?>> getProduces() {
        List<CdiProduces<?>> list = this.getProduces(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (list == null) {
            CdiJamModel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<CdiProduces<?>> getProduces(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(9);
        }
        List<CdiProduces<?>> list = this.getProduces(scope, true, true);
        if (list == null) {
            CdiJamModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<CdiProduces<?>> getProduces(@NotNull GlobalSearchScope scope, boolean methods, boolean fields) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(11);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList produces = new ArrayList();
        String producesAnno = CdiAnnoConstants.PRODUCES_ANNOTATION.fqn(this.myModule);
        if (fields) {
            produces.addAll(service.getJamFieldElements(CdiProduces.FIELD_META, producesAnno, scope));
        }
        if (methods) {
            produces.addAll(service.getJamMethodElements(CdiProduces.METHOD_META, producesAnno, scope));
        }
        ArrayList arrayList = produces;
        if (arrayList == null) {
            CdiJamModel.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public List<CdiSpecializes<?>> getSpecializeses() {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        ArrayList specializeses = new ArrayList();
        String specializesAnno = CdiAnnoConstants.SPECIALIZES_ANNOTATION.fqn(this.myModule);
        specializeses.addAll(service.getJamClassElements(CdiSpecializes.CLASS_META, specializesAnno, scope));
        specializeses.addAll(service.getJamMethodElements(CdiSpecializes.METHOD_META, specializesAnno, scope));
        return specializeses;
    }

    public List<CdiSpecializes<?>> getSpecializes(PsiClass psiClass) {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        return service.getAnnotatedMembersList(psiClass, CdiSpecializes.SEM_KEY, 3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/jam/CdiJamModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/jam/CdiJamModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjects";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProduces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamedBeans";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotatedBeanClasses";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getObserves";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisposes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjects";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProduces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

