/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CdiTypedAnnotationInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiTypedAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiTypedAnnotationInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiTypedAnnotationInspection.$$$reportNull$$$0(2);
        }
        CdiTypedAnnotationInspection.checkPsiClassTypes(aClass, (PsiType)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass), holder);
        for (PsiMethod psiMethod : aClass.getMethods()) {
            CdiTypedAnnotationInspection.checkProducerMembers((PsiMember)psiMethod, psiMethod.getReturnType(), holder);
        }
        for (PsiMethod psiMethod : aClass.getFields()) {
            CdiTypedAnnotationInspection.checkProducerMembers((PsiMember)psiMethod, psiMethod.getType(), holder);
        }
    }

    private static void checkPsiClassTypes(PsiClass owner, PsiType psiType, ProblemsHolder holder) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{CdiAnnoConstants.TYPED_ANNOTATION.fqn((PsiElement)owner)});
        if (annotation != null) {
            CdiTypedAnnotationInspection.checkTypeCorrespondToBeanType(psiType, holder, annotation);
        }
    }

    private static void checkProducerMembers(PsiMember owner, PsiType psiType, ProblemsHolder holder) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{CdiAnnoConstants.TYPED_ANNOTATION.fqn((PsiElement)owner)});
        if (annotation != null) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)CdiAnnoConstants.PRODUCES_ANNOTATION.fqn((PsiElement)owner), (int)1)) {
                CdiTypedAnnotationInspection.checkTypeCorrespondToBeanType(psiType, holder, annotation);
            } else {
                holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiTypedAnnotationInspection.non.producer", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkTypeCorrespondToBeanType(PsiType psiType, ProblemsHolder holder, PsiAnnotation annotation) {
        boolean isAssignable = true;
        List values = AnnotationModelUtil.getPsiClassArrayValue((PsiAnnotation)annotation, (String)"value");
        for (AnnotationGenericValue genericValue : values) {
            PsiClassType type;
            PsiClass typedClass = (PsiClass)genericValue.getValue();
            if (typedClass == null || (type = JavaPsiFacade.getElementFactory((Project)typedClass.getProject()).createType(typedClass)).isAssignableFrom(psiType)) continue;
            isAssignable = false;
            break;
        }
        if (!isAssignable) {
            holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiTypedAnnotationInspection.incorrect.bean.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/cdi/highlighting/CdiTypedAnnotationInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

