/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ArrayUtilRt;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiSpecializesInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass psiClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiClass == null) {
            CdiSpecializesInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiSpecializesInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiSpecializesInspection.$$$reportNull$$$0(2);
        }
        List<CdiSpecializes<?>> specializeses = CdiJamModel.getModel(module).getSpecializes(psiClass);
        for (CdiSpecializes<?> specializes : specializeses) {
            if (specializes instanceof CdiSpecializes.ProducerMethodMapping) {
                CdiSpecializesInspection.checkSpecializesMethodNonStatic(holder, (CdiSpecializes.ProducerMethodMapping)specializes);
                CdiSpecializesInspection.checkSpecializesMethodIsProducerMethod(holder, (CdiSpecializes.ProducerMethodMapping)specializes);
                CdiSpecializesInspection.checkOverridesMethodOfSuperclass(holder, (CdiSpecializes.ProducerMethodMapping)specializes);
            }
            if (specializes instanceof CdiSpecializes.ClassMapping) {
                CdiSpecializesInspection.checkHasSpecializedBeans((CdiSpecializes.ClassMapping)specializes, holder);
            }
            CdiSpecializesInspection.checkMultipleSpecializedBeans(specializes, holder, module);
            CdiSpecializesInspection.checkDuplicateNamedAnnotations(specializes, holder);
        }
    }

    private static void checkOverridesMethodOfSuperclass(ProblemsHolder holder, CdiSpecializes.ProducerMethodMapping methodMapping) {
        PsiMethod specializedMember = methodMapping.getSpecializedMember();
        if (specializedMember == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)specializedMember, (String)CdiAnnoConstants.PRODUCES_ANNOTATION.fqn((PsiElement)specializedMember), (int)1)) {
            holder.registerProblem((PsiElement)methodMapping.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specializes.method.must.override.producer.of.superclass", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkDuplicateNamedAnnotations(CdiSpecializes<?> specializes, ProblemsHolder holder) {
        Object psiClass = specializes.getPsiElement();
        if (CdiSpecializesInspection.hasNamedAnno(psiClass) && CdiSpecializesInspection.hasNamedAnno(specializes.getSpecializedMember())) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specialized.class.has.duplicated.named.anno", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean hasNamedAnno(@Nullable PsiMember psiMember) {
        return psiMember != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)CdiAnnoConstants.NAMED_ANNOTATION.fqn((PsiElement)psiMember), (int)0);
    }

    private static void checkHasSpecializedBeans(CdiSpecializes.ClassMapping specializes, ProblemsHolder holder) {
        PsiClass specializedBean = specializes.getSpecializedMember();
        if (specializedBean == null || "java.lang.Object".equals(specializedBean.getQualifiedName())) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specialized.class.not.defined", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkMultipleSpecializedBeans(CdiSpecializes<?> specializes, ProblemsHolder holder, Module module) {
        Object specializedMember = specializes.getSpecializedMember();
        if (specializedMember == null) {
            return;
        }
        HashSet<String> brotherSpecializes = new HashSet<String>();
        for (CdiSpecializes<?> beansSpecializes : CdiJamModel.getModel(module).getSpecializeses()) {
            PsiClass containingClass;
            if (beansSpecializes.equals(specializes) || !specializedMember.equals(beansSpecializes.getSpecializedMember()) || (containingClass = beansSpecializes.getContainingClass()) == null) continue;
            brotherSpecializes.add(containingClass.getName());
        }
        if (brotherSpecializes.size() > 0) {
            String names = StringUtil.join((String[])ArrayUtilRt.toStringArray(brotherSpecializes), (String)",");
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specialized.class.has.multiple.specializes", names), new LocalQuickFix[0]);
        }
    }

    private static void checkSpecializesMethodIsProducerMethod(ProblemsHolder holder, CdiSpecializes.ProducerMethodMapping specializes) {
        PsiMethod specializesPsiElement = (PsiMethod)specializes.getPsiElement();
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)specializesPsiElement, (String)CdiAnnoConstants.PRODUCES_ANNOTATION.fqn((PsiElement)specializesPsiElement), (int)0)) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specializes.method.must.be.producer", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkSpecializesMethodNonStatic(ProblemsHolder holder, CdiSpecializes.ProducerMethodMapping specializes) {
        if (((PsiMethod)specializes.getPsiElement()).getModifierList().hasModifierProperty("static")) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specializes.method.must.be.non.static", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/cdi/highlighting/CdiSpecializesInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

