/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.List;

public class CdiInjectInspection
extends CdiBaseInspection {
    @Override
    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        CdiInjectInspection.checkInjectedConstructor(descriptor, holder);
        CdiInjectInspection.checkInjectedMethods(descriptor, holder);
        CdiInjectInspection.checkInjectedFields(descriptor, holder);
    }

    private static void checkInjectedMethods(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiMethod> methods = descriptor.getInjectedMethods();
        for (PsiMethod method : methods) {
            CdiInjectInspection.checkNonStatic(method, holder);
            CdiInjectInspection.checkNonAbstract(method, holder);
            CdiInjectInspection.checkWrongAnnotations(method, holder);
            CdiInjectInspection.checkWrongAnnotatedParameters(method, holder);
        }
    }

    private static void checkWrongAnnotatedParameters(PsiMethod method, ProblemsHolder holder) {
        String disposesAnno = CdiAnnoConstants.DISPOSES_ANNOTATION.fqn((PsiElement)method);
        String observesAsyncAnno = CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.fqn((PsiElement)method);
        String observesAnno = CdiAnnoConstants.OBSERVES_ANNOTATION.fqn((PsiElement)method);
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            CdiInjectInspection.checkWrongAnnotatedParameter(method, holder, disposesAnno, parameter);
            CdiInjectInspection.checkWrongAnnotatedParameter(method, holder, observesAnno, parameter);
            CdiInjectInspection.checkWrongAnnotatedParameter(method, holder, observesAsyncAnno, parameter);
        }
    }

    private static void checkWrongAnnotatedParameter(PsiMethod method, ProblemsHolder holder, String anno, PsiParameter parameter) {
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)anno, (int)0)) {
            holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiInjectInspection.injected.with.disposes.parameters", anno), new LocalQuickFix[0]);
        }
    }

    private static void checkNonStatic(PsiMethod method, ProblemsHolder holder) {
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier != null && method.getModifierList().hasModifierProperty("static")) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.injected.method.cannot.be.static", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkNonAbstract(PsiMethod method, ProblemsHolder holder) {
        if (CdiCustomizationManager.hasExtendedInjectionAnnotation((PsiModifierListOwner)method)) {
            return;
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier != null && method.getModifierList().hasModifierProperty("abstract")) {
            holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiInjectInspection.injected.method.cannot.be.abstract", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkWrongAnnotations(PsiMethod method, ProblemsHolder holder) {
        CdiInjectInspection.checkWrongAnnotation(method, CdiAnnoConstants.PRODUCES_ANNOTATION.fqn((PsiElement)method), holder);
    }

    private static void checkWrongAnnotation(PsiMethod method, String annotation, ProblemsHolder holder) {
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)annotation, (int)1)) {
            holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiInjectInspection.wrong.injected.method.annotation", annotation), new LocalQuickFix[0]);
        }
    }

    private static void checkInjectedConstructor(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiMethod> methods = descriptor.getInjectedConstructors();
        if (methods.size() > 1) {
            String injectedAnno = CdiAnnoConstants.INJECT_ANNOTATION.fqn(descriptor.getIdentifyingElement());
            for (PsiMethod method : methods) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{injectedAnno});
                if (annotation == null) continue;
                holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiInjectInspection.more.than.one.injected.constructor", methods.size()), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkInjectedFields(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiField> injectedFields = descriptor.getInjectedFields();
        String producesAnno = CdiAnnoConstants.PRODUCES_ANNOTATION.fqn(descriptor.getIdentifyingElement());
        for (PsiField field : injectedFields) {
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) continue;
            if (modifierList.hasModifierProperty("static")) {
                holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectionInspection.field.cannot.be.static", new Object[0]), new LocalQuickFix[0]);
            }
            if (modifierList.hasModifierProperty("final")) {
                holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectionInspection.field.cannot.be.final", new Object[0]), new LocalQuickFix[0]);
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)producesAnno, (int)0)) {
                holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.field.cannot.be.annotated.produces", new Object[0]), new LocalQuickFix[0]);
            }
            if (!field.hasInitializer()) continue;
            holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.field.should.not.be.initialized", new Object[0]), new LocalQuickFix[0]);
        }
    }
}

