/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import icons.JavaUltimateIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodCallExpressionCellRenderer
extends PsiElementListCellRenderer<PsiMethodCallExpression> {
    protected Icon getIcon(PsiElement element) {
        if (element instanceof PsiMethodCallExpression) {
            return JavaUltimateIcons.Cdi.Gutter.Publisher;
        }
        return super.getIcon(element);
    }

    public String getElementText(PsiMethodCallExpression element) {
        return PsiMethodCallExpressionCellRenderer.elementText(element);
    }

    public String getContainerText(PsiMethodCallExpression element, String name) {
        return PsiMethodCallExpressionCellRenderer.containerText(element);
    }

    @NlsSafe
    public static String elementText(PsiMethodCallExpression element) {
        String text = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)element);
        return text.replaceAll(" ", "").replaceAll("\n", "");
    }

    @Nullable
    public static String containerText(@NotNull PsiMethodCallExpression element) {
        String sb;
        PsiMethod psiMethod;
        if (element == null) {
            PsiMethodCallExpressionCellRenderer.$$$reportNull$$$0(0);
        }
        if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null && (sb = PsiMethodCallExpressionCellRenderer.getMethodText(psiMethod)) != null) {
            return sb;
        }
        return SymbolPresentationUtil.getSymbolContainerText((PsiElement)element);
    }

    @Nullable
    private static String getMethodText(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            PsiMethodCallExpressionCellRenderer.$$$reportNull$$$0(1);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        StringBuilder sb = new StringBuilder();
        if (containingClass != null) {
            sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass)).append(".");
            sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiMethod));
            return sb.toString();
        }
        return null;
    }

    protected int getIconFlags() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/gutter/PsiMethodCallExpressionCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containerText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

