/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.gutter.CdiBaseLineMarkerProvider;
import com.intellij.cdi.gutter.PsiMethodCallExpressionCellRenderer;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiEventObserves;
import com.intellij.cdi.jam.events.CdiEventObservesAsync;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.JamService;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.semantic.SemService;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiEventsModelClassAnnotator
extends CdiBaseLineMarkerProvider {
    private static final String FIRE_EVENT_METHOD = "fire";
    private static final String FIRE_ASYNC_EVENT_METHOD = "fireAsync";
    private static final List<String> OBSERVES_ANNOTATIONS = Arrays.asList(CdiAnnoConstants.OBSERVES_ANNOTATION.jakarta(), CdiAnnoConstants.OBSERVES_ANNOTATION.javax(), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.jakarta(), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.javax());
    private static final PsiElementListCellRenderer<PsiParameter> psiParameterListRenderer = new PsiElementListCellRenderer<PsiParameter>(){

        public String getElementText(PsiParameter element) {
            PsiMethod method = (PsiMethod)element.getParent().getParent();
            StringBuilder sb = new StringBuilder();
            sb.append(method.getName());
            sb.append("(");
            ArrayList<String> params = new ArrayList<String>();
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                if (psiParameter.equals(element)) {
                    params.add(element.getText());
                    continue;
                }
                params.add(psiParameter.getType().getPresentableText());
            }
            sb.append(StringUtil.join(params, (String)","));
            sb.append(")");
            return sb.toString();
        }

        protected Icon getIcon(PsiElement element) {
            return PlatformIcons.METHOD_ICON;
        }

        protected String getContainerText(PsiParameter element, String name) {
            return "(" + element.getContainingFile().getName() + ")";
        }
    };

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (psiElement == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(0);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(1);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof PsiIdentifier) {
            PsiMethodCallExpression methodCallExpression;
            String referenceName;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof PsiParameter) {
                PsiParameter psiParameter = (PsiParameter)parent;
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, OBSERVES_ANNOTATIONS, (int)0)) {
                    CdiEventsModelClassAnnotator.annotateObserves(psiParameter, result, module);
                }
            } else if (parent instanceof PsiField || parent instanceof PsiMethod) {
                PsiClassType eventType = CdiEventsModelClassAnnotator.getEventPsiType(module);
                if (eventType == null) {
                    return;
                }
                CdiInject cdiInject = (CdiInject)SemService.getSemService((Project)module.getProject()).getSemElement(CdiInject.INJECT_JAM_KEY, parent);
                if (cdiInject != null && CdiInjectionUtils.getInjectionPointOfType((PsiType)eventType, cdiInject).size() > 0) {
                    CdiEventsModelClassAnnotator.annotateEvents(cdiInject, result, module, CdiJamModel.getModel(module).getObserves());
                }
            } else if (parent instanceof PsiReferenceExpression && (FIRE_EVENT_METHOD.equals(referenceName = ((PsiReferenceExpression)parent).getReferenceName()) || FIRE_ASYNC_EVENT_METHOD.equals(referenceName)) && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethodCallExpression.class)) != null && CdiEventsModelClassAnnotator.isFireEventEventExpression(methodCallExpression)) {
                CdiEventsModelClassAnnotator.annotateFireEventExpression(methodCallExpression, result);
            }
        }
    }

    public static boolean isFireEventEventExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiElement element;
        PsiReferenceExpression methodExpression;
        String referenceName;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(3);
        }
        if ((FIRE_EVENT_METHOD.equals(referenceName = (methodExpression = methodCallExpression.getMethodExpression()).getReferenceName()) || FIRE_ASYNC_EVENT_METHOD.equals(referenceName)) && (element = methodExpression.resolve()) instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)CdiClassesConstants.EVENT.fqn(element));
        }
        return false;
    }

    private static void annotateFireEventExpression(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Set<CdiObserves> observes;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(4);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(5);
        }
        if ((observes = CdiEventsModelClassAnnotator.getObserves(methodCallExpression)).size() > 0) {
            PsiReferenceExpression expression = methodCallExpression.getMethodExpression();
            PsiElement referenceNameElement = expression.getReferenceNameElement();
            CdiEventsModelClassAnnotator.addGotoObservesIcon(result, (PsiElement)(referenceNameElement == null ? expression : referenceNameElement), (NotNullLazyValue<Collection<? extends PsiElement>>)NotNullLazyValue.lazy(() -> ContainerUtil.mapNotNull((Collection)observes, cdiObserves -> cdiObserves.getPsiElement())));
        }
    }

    @NotNull
    private static Set<CdiObserves> getObserves(@NotNull PsiMethodCallExpression methodCallExpression) {
        Module module;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)methodCallExpression)) == null) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<CdiObserves> allObservesList = CdiJamModel.getModel(module).getObserves();
        if (allObservesList.size() == 0) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(8);
            }
            return set;
        }
        Set<CdiObserves> observes = CdiEventsModelClassAnnotator.getObserves(methodCallExpression, module, allObservesList);
        if (observes.size() == 0) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(9);
            }
            return set;
        }
        boolean isAsyncMethodCall = FIRE_ASYNC_EVENT_METHOD.equals(methodCallExpression.getMethodExpression().getReferenceName());
        if (isAsyncMethodCall) {
            Set<CdiObserves> set = observes.stream().filter(async -> async instanceof CdiEventObservesAsync).collect(Collectors.toSet());
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<CdiObserves> set = observes.stream().filter(notAsync -> notAsync instanceof CdiEventObserves).collect(Collectors.toSet());
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static Set<CdiObserves> getObserves(@NotNull PsiMethodCallExpression methodCallExpression, Module module, Set<? extends CdiObserves> allObservesList) {
        CdiInject<?> injectedEvent;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(12);
        }
        if ((injectedEvent = CdiEventsModelClassAnnotator.getInjectedEvent(methodCallExpression)) == null) {
            return CdiEventsModelClassAnnotator.collectObserves(CdiEventsModelClassAnnotator.getHandledEventType(methodCallExpression), allObservesList);
        }
        return CdiEventsModelClassAnnotator.collectObserves(injectedEvent, allObservesList, module);
    }

    @Nullable
    private static CdiInject<?> getInjectedEvent(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiElement resolve;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(13);
        }
        if ((qualifierExpression = (methodExpression = methodCallExpression.getMethodExpression()).getQualifierExpression()) == null) {
            return null;
        }
        if (qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField) {
            JamService jamService = JamService.getJamService((Project)qualifierExpression.getProject());
            return (CdiInject)jamService.getJamElement(CdiInject.INJECT_JAM_KEY, resolve);
        }
        return null;
    }

    @Nullable
    private static PsiType getHandledEventType(@NotNull PsiMethodCallExpression expression) {
        PsiExpression[] expressions;
        if (expression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(14);
        }
        return (expressions = expression.getArgumentList().getExpressions()).length > 0 ? expressions[0].getType() : null;
    }

    @Nullable
    private static PsiClassType getEventPsiType(@NotNull Module module) {
        JavaPsiFacade psiFacade;
        PsiClass eventPsiClass;
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(15);
        }
        if ((eventPsiClass = (psiFacade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass(CdiClassesConstants.EVENT.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            return psiFacade.getElementFactory().createType(eventPsiClass);
        }
        return null;
    }

    private static void annotateObserves(@NotNull PsiParameter psiParameter, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull Module module) {
        if (psiParameter == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(16);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(17);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(18);
        }
        CdiEventsModelClassAnnotator.addGotoFiresIcon(result, psiParameter, (NotNullLazyValue<Collection<? extends PsiElement>>)NotNullLazyValue.lazy(() -> ContainerUtil.mapNotNull(CdiEventsModelClassAnnotator.getFireEventPoints(psiParameter, module), firePoint -> ((PsiElement)firePoint.first).isValid() ? (PsiElement)firePoint.first : null)));
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventPoints(@NotNull PsiParameter psiParameter, @NotNull Module module) {
        if (psiParameter == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(19);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(20);
        }
        JavaeeType javaeeType = JavaeeType.discover((Module)module, (JavaeeClass)CdiAnnoConstants.OBSERVES_ANNOTATION);
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)CdiAnnoConstants.OBSERVES_ANNOTATION.fqn(javaeeType), (int)0)) {
            return CdiEventsModelClassAnnotator.getFireEventExpressions(psiParameter.getType(), module, scope);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.fqn(javaeeType), (int)0)) {
            return CdiEventsModelClassAnnotator.getFireAsyncEventExpressions(psiParameter.getType(), module, scope);
        }
        Set<Pair<PsiElement, PsiType>> set = Collections.emptySet();
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(21);
        }
        return set;
    }

    private static void annotateEvents(CdiInject<? extends PsiMember> event, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, Module module, Set<? extends CdiObserves> allObservesList) {
        Set<CdiObserves> observes;
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(22);
        }
        if ((observes = CdiEventsModelClassAnnotator.collectObserves(event, allObservesList, module)).size() > 0) {
            CdiEventsModelClassAnnotator.addGotoObservesIcon(result, (PsiElement)event.getPsiElement(), (NotNullLazyValue<Collection<? extends PsiElement>>)NotNullLazyValue.lazy(() -> ContainerUtil.mapNotNull((Collection)observes, cdiObserves -> cdiObserves.getPsiElement())));
        }
    }

    private static void addGotoObservesIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(23);
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)JavaUltimateIcons.Cdi.Gutter.Listener).setCellRenderer(psiParameterListRenderer).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.observes", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.observes", new Object[0]));
        result.add(builder.createLineMarkerInfo(CdiEventsModelClassAnnotator.getLeafElement(psiIdentifier)));
    }

    @NotNull
    private static PsiElement getLeafElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(24);
        }
        PsiIdentifier nameIdentifier = null;
        if (psiElement instanceof PsiVariable) {
            nameIdentifier = ((PsiVariable)psiElement).getNameIdentifier();
        } else if (psiElement instanceof PsiMethod) {
            nameIdentifier = ((PsiMethod)psiElement).getNameIdentifier();
        }
        Object object = nameIdentifier == null ? psiElement : nameIdentifier;
        if (object == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(25);
        }
        return object;
    }

    private static void addGotoFiresIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, PsiParameter psiParameter, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(26);
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)JavaUltimateIcons.Cdi.Gutter.Publisher).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.fires", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.fires", new Object[0])).setCellRenderer(CdiEventsModelClassAnnotator.getEventFirePointRenderer());
        result.add(builder.createLineMarkerInfo(CdiEventsModelClassAnnotator.getLeafElement((PsiElement)psiParameter)));
    }

    private static Set<CdiObserves> collectObserves(CdiInject<? extends PsiMember> event, Set<? extends CdiObserves> allObservesList, Module module) {
        PsiType eventType = CdiEventsModelClassAnnotator.getEventType(event, CdiEventsModelClassAnnotator.getEventPsiType(module));
        if (eventType != null) {
            PsiAnnotation[] eventQualifierAnnotations = event.getQualifierAnnotations();
            return allObservesList.stream().filter(observes -> {
                PsiType type = observes.getType();
                return type != null && type.isAssignableFrom(eventType) && CdiEventsModelClassAnnotator.isQualifiersAssignable(eventQualifierAnnotations, (PsiModifierListOwner)observes.getPsiElement());
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Set<CdiObserves> collectObserves(@Nullable PsiType handledEventType, @NotNull Set<? extends CdiObserves> allObservesList) {
        if (allObservesList == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(27);
        }
        if (handledEventType != null) {
            return allObservesList.stream().filter(observes -> {
                PsiType type = observes.getType();
                return type != null && type.isAssignableFrom(handledEventType);
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Nullable
    private static PsiType getEventType(CdiInject<? extends PsiMember> event, PsiClassType eventPsiType) {
        String eventAnno = CdiClassesConstants.EVENT.fqn((PsiElement)event.getPsiElement());
        for (InjectionPointDescriptor pair : event.getInjectionPoints()) {
            PsiType injectionPointType = pair.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom((PsiType)eventPsiType)) continue;
            return PsiUtil.substituteTypeParameter((PsiType)injectionPointType, (String)eventAnno, (int)0, (boolean)false);
        }
        return null;
    }

    private static boolean isQualifiersAssignable(PsiAnnotation[] qualifierAnnotation, PsiModifierListOwner candidate) {
        return CdiManager.hasAnnotated(candidate, qualifierAnnotation);
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> searchAndCacheFireEventExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(28);
        }
        if (searchScope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(29);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)fireEventMethod, () -> CachedValueProvider.Result.create(CdiEventsModelClassAnnotator.searchFireEventExpressions(fireEventMethod, searchScope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(30);
        }
        return set;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> searchFireEventExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(31);
        }
        if (searchScope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(32);
        }
        @NotNull LinkedHashSet<Pair<PsiElement, PsiType>> set = new LinkedHashSet<Pair<PsiElement, PsiType>>();
        MethodReferencesSearch.search((PsiMethod)fireEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiExpression[] expressions;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0) {
                PsiExpression expression = expressions[0];
                set.add(Pair.create((Object)methodCallExpression, (Object)expression.getType()));
            }
            return true;
        });
        LinkedHashSet<Pair<PsiElement, PsiType>> linkedHashSet = set;
        if (linkedHashSet == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(33);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventExpressions(@NotNull PsiType handledType, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (handledType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(34);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(35);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(36);
        }
        return CdiEventsModelClassAnnotator.filter(CdiEventsModelClassAnnotator.getFireEventExpressions(FIRE_EVENT_METHOD, module, scope), handledType);
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireAsyncEventExpressions(@NotNull PsiType handledType, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (handledType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(37);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(39);
        }
        return CdiEventsModelClassAnnotator.filter(CdiEventsModelClassAnnotator.getFireEventExpressions(FIRE_ASYNC_EVENT_METHOD, module, scope), handledType);
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventExpressions(@NotNull String methodName, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (methodName == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(40);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(42);
        }
        LinkedHashSet<Pair<PsiElement, PsiType>> firePoints = new LinkedHashSet<Pair<PsiElement, PsiType>>();
        for (PsiMethod fireEventMethod : CdiEventsModelClassAnnotator.getFireEventMethods(module, methodName)) {
            firePoints.addAll(CdiEventsModelClassAnnotator.searchAndCacheFireEventExpressions(fireEventMethod, (SearchScope)scope));
        }
        LinkedHashSet<Pair<PsiElement, PsiType>> linkedHashSet = firePoints;
        if (linkedHashSet == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(43);
        }
        return linkedHashSet;
    }

    private static PsiMethod[] getFireEventMethods(@NotNull Module module, @NotNull String fireMethod) {
        PsiClass eventClass;
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(44);
        }
        if (fireMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(45);
        }
        if ((eventClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(CdiClassesConstants.EVENT.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            return eventClass.findMethodsByName(fireMethod, false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> filter(@NotNull Set<? extends Pair<PsiElement, PsiType>> firePoints, @NotNull PsiType eventType) {
        if (firePoints == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(46);
        }
        if (eventType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(47);
        }
        Set<Pair<PsiElement, PsiType>> set = firePoints.stream().filter(firePoint -> {
            PsiType firedEventType = (PsiType)firePoint.second;
            return firedEventType != null && eventType.isAssignableFrom(firedEventType);
        }).collect(Collectors.toSet());
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(48);
        }
        return set;
    }

    @NotNull
    private static PsiElementListCellRenderer<PsiMethodCallExpression> getEventFirePointRenderer() {
        return new PsiMethodCallExpressionCellRenderer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 43: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 43: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 15: 
            case 18: 
            case 20: 
            case 35: 
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 17: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allObservesList";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireEventMethod";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledType";
                break;
            }
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireMethod";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firePoints";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getObserves";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFireEventPoints";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafElement";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "searchAndCacheFireEventExpressions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "searchFireEventExpressions";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFireEventExpressions";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFireEventEventExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotateFireEventExpression";
                break;
            }
            case 6: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getObserves";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 43: 
            case 48: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEvent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHandledEventType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEventPsiType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "annotateObserves";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventPoints";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "annotateEvents";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addGotoObservesIcon";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLeafElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addGotoFiresIcon";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectObserves";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "searchAndCacheFireEventExpressions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "searchFireEventExpressions";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventExpressions";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFireAsyncEventExpressions";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventMethods";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 43: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

