/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.gutter.group.CdiGroupMergeableLineMarkerInfo;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.toolWindow.CdiView;
import com.intellij.cdi.toolWindow.tree.CdiViewPathUtils;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastUtils;

public final class CdiAnnotationsLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @GutterName
    public String getName() {
        return CdiBundle.message("cdi.annotations.gutter.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Cdi.Cdi;
        if (icon == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        PsiElement element;
        if (elements == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((element = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        Project project = element.getProject();
        if (CdiAnnotationsLineMarkerProvider.getToolWindow(project) == null) {
            return;
        }
        for (PsiElement psiElement : elements) {
            PsiElement uastAnchorPsi;
            UElement uastAnchor;
            UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
            if (!(uParent instanceof UClass)) continue;
            UClass uClass = (UClass)uParent;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null || !CdiCommonUtils.isCdiInstalled(module) || !CdiAnnotationsLineMarkerProvider.isRelevantPsiClass(uClass, module) || (uastAnchor = uClass.getUastAnchor()) == null || (uastAnchorPsi = uastAnchor.getSourcePsi()) == null) continue;
            result.add(CdiAnnotationsLineMarkerProvider.createLineMarker(uastAnchorPsi, project, module, this));
        }
    }

    private static boolean isRelevantPsiClass(@NotNull UClass uClass, @NotNull Module module) {
        PsiClass psiClass;
        if (uClass == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (module == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if ((psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null) {
            return false;
        }
        return ContainerUtil.exists((Object[])psiClass.getAnnotations(), anno -> CdiAnnotationsLineMarkerProvider.isRelevantAnnotation(anno, module));
    }

    private static boolean isRelevantAnnotation(@NotNull PsiAnnotation annotation, @Nullable Module module) {
        if (annotation == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (!(annotation.getOwner() instanceof PsiModifierList)) {
            return false;
        }
        PsiModifierList modifierList = (PsiModifierList)annotation.getOwner();
        if (!(modifierList.getParent() instanceof PsiClass)) {
            return false;
        }
        PsiClass owner = (PsiClass)modifierList.getParent();
        if (owner.isAnnotationType() || owner.isEnum() || owner.isRecord() || owner.isInterface()) {
            return false;
        }
        return CdiCommonUtils.isBeanDeclaringAnnotation(owner, annotation.getQualifiedName(), module, annotation.getProject());
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(@NotNull PsiElement psiElement, @NotNull Project project, @Nullable Module module, @NotNull LineMarkerProviderDescriptor lineMarkerProviderDescriptor) {
        if (psiElement == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (lineMarkerProviderDescriptor == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(9);
        }
        return new CdiGroupMergeableLineMarkerInfo(psiElement, psiElement.getTextRange(), JavaUltimateIcons.Cdi.Gutter.Cdi, (Function1<? super PsiElement, String>)((Function1)el -> CdiBundle.message("cdi.open.tool.window", new Object[0])), (Function1<? super PsiElement, String>)((Function1)el -> CdiBundle.message("cdi.open.tool.window.title", new Object[0])), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)(e, elt) -> {
            ToolWindow toolWindow = CdiAnnotationsLineMarkerProvider.getToolWindow(project);
            if (toolWindow != null) {
                toolWindow.activate(() -> ReadAction.nonBlocking(() -> CdiViewPathUtils.getTreePath(psiElement, module, project)).finishOnUiThread(ModalityState.any(), treePath -> CdiView.select(project, true, treePath)).coalesceBy(new Object[]{toolWindow, lineMarkerProviderDescriptor}).inSmartMode(project).submit((Executor)AppExecutorUtil.getAppExecutorService()));
            }
        }), (Function0<String>)((Function0)() -> CdiBundle.message("cdi.open.tool.window", new Object[0])));
    }

    @Nullable
    public static ToolWindow getToolWindow(Project project) {
        return ToolWindowManager.getInstance((Project)project).getToolWindow("CDI");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/gutter/CdiAnnotationsLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineMarkerProviderDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/gutter/CdiAnnotationsLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantPsiClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantAnnotation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

