/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.gutter;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.diagram.gutter.CdiDiagramDependenciesLineMarkerProvider;
import com.intellij.cdi.diagram.gutter.CdiShowDependenciesGraphAction;
import com.intellij.cdi.diagram.gutter.CdiShowDependenciesGraphInPopupAction;
import com.intellij.cdi.gutter.group.CdiGroupMergeableLineMarkerInfo;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.core.actions.ShowDiagramBase;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u001a\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J&\u0010\u001e\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/cdi/diagram/gutter/CdiDiagramDependenciesLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "createLineMarkerInfo", "uElement", "Lorg/jetbrains/uast/UElement;", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getLineMarkerInfo", "element", "getName", "isRelevantUClass", "", "uClass", "Lorg/jetbrains/uast/UClass;", "module", "Lcom/intellij/openapi/module/Module;", "injectionPoints", "", "Lcom/intellij/cdi/beans/InjectionPointDescriptor;", "isRelevantUElement", "isRelevantUMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "PsiElementGutterIconNavigationHandler", "intellij.javaee.cdi"})
public final class CdiDiagramDependenciesLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getId() {
        return "CdiDiagramDependenciesLineMarkerProvider";
    }

    @NotNull
    public String getName() {
        String string = CdiBundle.message("gutter.dependencies.diagram", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CdiBundle.message(\"gutter.dependencies.diagram\")");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.FileTypes.Diagram;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.FileTypes.Diagram");
        return icon;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement firstElement = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)firstElement);
        if (module == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026t(firstElement) ?: return");
        Module module2 = module;
        if (!CdiCommonUtils.isCdiInstalled(module2)) {
            return;
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(module2);
        for (PsiElement psiElement2 : elements) {
            UElement uElement;
            if (UastUtils.getUParentForIdentifier((PsiElement)psiElement2) == null) {
                continue;
            }
            Set<InjectionPointDescriptor> set = injectionPoints;
            Intrinsics.checkNotNullExpressionValue(set, (String)"injectionPoints");
            if (!this.isRelevantUElement(uElement, module2, (Collection<? extends InjectionPointDescriptor>)set)) continue;
            ContainerUtil.addIfNotNull(result, this.createLineMarkerInfo(uElement));
        }
    }

    private final boolean isRelevantUElement(UElement uElement, Module module, Collection<? extends InjectionPointDescriptor> injectionPoints) {
        UElement uElement2 = uElement;
        return uElement2 instanceof UClass ? this.isRelevantUClass((UClass)uElement, module, injectionPoints) : (uElement2 instanceof UMethod ? this.isRelevantUMethod((UMethod)uElement) : false);
    }

    private final boolean isRelevantUClass(UClass uClass, Module module, Collection<? extends InjectionPointDescriptor> injectionPoints) {
        boolean bl;
        block9: {
            boolean $i$f$any;
            PsiAnnotation[] $this$any$iv;
            PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)((UElement)uClass), PsiClass.class);
            if (psiClass == null) {
                return false;
            }
            PsiClass psiClass2 = psiClass;
            if (psiClass2.isAnnotationType() || psiClass2.isEnum() || psiClass2.isRecord() || psiClass2.isInterface()) {
                return false;
            }
            PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)psiClass2);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"PsiTypesUtil.getClassType(psiClass)");
            PsiClassType psiClassType2 = psiClassType;
            if (CdiInjectionUtils.canBeInjected(psiClass2, module)) {
                boolean bl2;
                block8: {
                    $this$any$iv = (PsiAnnotation[])injectionPoints;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object e : $this$any$iv) {
                            InjectionPointDescriptor it = (InjectionPointDescriptor)e;
                            boolean bl3 = false;
                            PsiType psiType = it.getType();
                            if (!(psiType != null && psiType.isAssignableFrom((PsiType)psiClassType2))) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return true;
                }
            }
            PsiAnnotation[] psiAnnotationArray = psiClass2.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"psiClass.annotations");
            $this$any$iv = psiAnnotationArray;
            $i$f$any = false;
            PsiAnnotation[] psiAnnotationArray2 = $this$any$iv;
            int n = psiAnnotationArray2.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv;
                Object it = element$iv = psiAnnotationArray2[i];
                boolean bl4 = false;
                Object object = it;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
                if (!CdiCommonUtils.isBeanDeclaringAnnotation(psiClass2, object.getQualifiedName(), module, psiClass2.getProject())) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isRelevantUMethod(UMethod uMethod) {
        PsiMethod psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)((UElement)uMethod), PsiMethod.class);
        if (psiMethod == null) {
            return false;
        }
        PsiMethod psiMethod2 = psiMethod;
        return CdiInjectionUtils.isProducer((PsiModifierListOwner)psiMethod2) || CdiInjectionUtils.isImplicitProducerMethod(psiMethod2);
    }

    private final LineMarkerInfo<PsiElement> createLineMarkerInfo(UElement uElement) {
        UClass uClass;
        UElement uElement2 = uElement;
        if (!(uElement2 instanceof UDeclaration)) {
            uElement2 = null;
        }
        UDeclaration uDeclaration = (UDeclaration)uElement2;
        if (uDeclaration == null) {
            return null;
        }
        UDeclaration uDeclaration2 = uDeclaration;
        UElement uElement3 = uElement;
        if (!(uElement3 instanceof UClass)) {
            uElement3 = null;
        }
        if ((uClass = (UClass)uElement3) == null) {
            UElement $this$getParentOfType$iv = uElement;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UClass.class, (boolean)strict$iv);
        }
        if (uClass == null) {
            return null;
        }
        UClass uClass2 = uClass;
        PsiElement psiElement = uClass2.getSourcePsi();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        PsiElement psiElement2 = UDeclarationKt.getAnchorPsi((UDeclaration)uDeclaration2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement psiAnchor = psiElement2;
        TextRange textRange = psiAnchor.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"psiAnchor.textRange");
        Icon icon = AllIcons.FileTypes.Diagram;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.FileTypes.Diagram");
        return (LineMarkerInfo)new CdiGroupMergeableLineMarkerInfo(psiAnchor, textRange, icon, (Function1<? super PsiElement, String>)((Function1)createLineMarkerInfo.1.INSTANCE), (Function1<? super PsiElement, String>)((Function1)createLineMarkerInfo.2.INSTANCE), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)new PsiElementGutterIconNavigationHandler(psiClass2)), (Function0<String>)((Function0)createLineMarkerInfo.3.INSTANCE));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/cdi/diagram/gutter/CdiDiagramDependenciesLineMarkerProvider$PsiElementGutterIconNavigationHandler;", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "origin", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "myActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "navigate", "", "e", "Ljava/awt/event/MouseEvent;", "elt", "intellij.javaee.cdi"})
    public static final class PsiElementGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final List<AnAction> myActions;

        public void navigate(@NotNull MouseEvent e, @Nullable PsiElement elt) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DefaultActionGroup group = new DefaultActionGroup();
            group.addAll((Collection)this.myActions);
            DataContext dataContext = DataManager.getInstance().getDataContext(e.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026tDataContext(e.component)");
            DataContext context = dataContext;
            JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(new RelativePoint(e));
        }

        public PsiElementGutterIconNavigationHandler(@NotNull PsiClass origin) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Iterable iterable = CollectionsKt.listOf((Object[])new ShowDiagramBase[]{(ShowDiagramBase)new CdiShowDependenciesGraphAction(origin), (ShowDiagramBase)new CdiShowDependenciesGraphInPopupAction(origin)});
            Comparator comparator = Comparator.comparing(myActions.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"Comparator.comparing { a\u2026mplatePresentation.text }");
            this.myActions = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        }
    }
}

