/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies.renderers;

import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.cdi.dependencies.nodes.CdiProducerDescriptorNode;
import com.intellij.diagram.DiagramColors;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CdiProducerNodeRenderer
extends AbstractColoredNodeCellRenderer {
    GraphBuilder<CdiNode<?>, CdiEdge<?>> myBuilder;

    public CdiProducerNodeRenderer(@NotNull GraphBuilder<CdiNode<?>, CdiEdge<?>> builder, ModificationTracker modificationTracker) {
        if (builder == null) {
            CdiProducerNodeRenderer.$$$reportNull$$$0(0);
        }
        super(modificationTracker);
        this.myBuilder = builder;
    }

    public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
        Node node = realizer.getNode();
        CdiNode beansNode = (CdiNode)this.myBuilder.getNodeObject(node);
        if (beansNode instanceof CdiProducerDescriptorNode) {
            CdiProducerDescriptorNode producerDescriptorNode = (CdiProducerDescriptorNode)beansNode;
            PsiMember element = producerDescriptorNode.getIdentifyingElement();
            if (!element.isValid()) {
                return;
            }
            PsiClass containingClass = element.getContainingClass();
            assert (containingClass != null);
            JLabel nameLabel = new JLabel(containingClass.getName(), containingClass.getIcon(0), 0);
            nameLabel.setBorder(JBUI.Borders.empty((int)3));
            nameLabel.setHorizontalAlignment(2);
            JBPanel namePanel = new JBPanel((LayoutManager)new BorderLayout()).withBackground(DiagramColors.NODE_BACKGROUND.getDefaultColor());
            namePanel.add((Component)nameLabel, (Object)"Center");
            namePanel.setBorder(BorderFactory.createLineBorder((Color)JBColor.WHITE, 1));
            nameLabel.setForeground(JBColor.foreground());
            wrapper.add((Component)namePanel, "North");
            CellRendererPanel propertiesPanel = new CellRendererPanel((LayoutManager)new GridBagLayout());
            ProducerBeanDescriptor descriptor = (ProducerBeanDescriptor)((CdiProducerDescriptorNode)beansNode).getBeanDescriptor();
            nameLabel.setFont(nameLabel.getFont().deriveFont(0));
            Object member = descriptor.getAnnotatedItem();
            PsiType propertyType = descriptor.getType();
            JLabel memberNameLabel = CdiProducerNodeRenderer.getPsiMemberNameLabel(member);
            JLabel typeLabel = new JLabel(propertyType == null ? "" : propertyType.getPresentableText());
            memberNameLabel.setHorizontalAlignment(2);
            typeLabel.setHorizontalAlignment(4);
            propertiesPanel.add((Component)memberNameLabel, (Object)new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 21, 1, (Insets)JBUI.insets((int)2), 0, 0));
            propertiesPanel.add((Component)typeLabel, (Object)new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 22, 1, (Insets)JBUI.insets((int)2), 0, 0));
            Dimension preferredSize = propertiesPanel.getPreferredSize();
            propertiesPanel.setPreferredSize(new Dimension((int)preferredSize.getWidth() + 20, (int)preferredSize.getHeight()));
            propertiesPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
            propertiesPanel.setForcedBackground(DiagramColors.NODE_BACKGROUND.getDefaultColor());
            wrapper.add((Component)propertiesPanel, "Center");
        }
    }

    private static JLabel getPsiMemberNameLabel(@NotNull PsiMember member) {
        if (member == null) {
            CdiProducerNodeRenderer.$$$reportNull$$$0(1);
        }
        String name = member instanceof PsiMethod ? PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)member), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2) : member.getName();
        return new JLabel(name, member.getIcon(0), 0);
    }

    protected String getNodeTitle(CdiNode pointer) {
        return this.myBuilder.getNodeName((Object)pointer);
    }

    protected int getSelectionBorderWidth() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/dependencies/renderers/CdiProducerNodeRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiMemberNameLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

