/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.CdiAnnotationsProvider;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiCustomizationManager {
    private static final ExtensionPointName<CdiCustomizationProvider> CUSTOMIZATION_EP_NAME = ExtensionPointName.create((String)"com.intellij.cdi.customizationProvider");
    private static final ExtensionPointName<CdiAnnotationsProvider> ANNOTATIONS_EP_NAME = ExtensionPointName.create((String)"com.intellij.cdi.annotationsProvider");

    @Nullable
    public static CdiCustomizationProvider getCustomization(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CdiCustomizationManager.$$$reportNull$$$0(0);
        }
        return (CdiCustomizationProvider)CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            return CachedValueProvider.Result.create((Object)CdiCustomizationManager.getCustomization(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)psiElement.getProject())});
        });
    }

    @Nullable
    public static CdiCustomizationProvider getCustomization(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (CdiCustomizationProvider)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)CdiCustomizationManager.findCustomization(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    @Nullable
    private static CdiCustomizationProvider findCustomization(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (CdiCustomizationProvider)CUSTOMIZATION_EP_NAME.findFirstSafe(provider -> provider.isInstalled(module));
    }

    @NotNull
    public static List<String> getCustomBeanAnnotations(@NotNull Project project) {
        if (project == null) {
            CdiCustomizationManager.$$$reportNull$$$0(1);
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{dumbService});
            }
            List<String> availableAnnotations = CdiCustomizationManager.getAvailableCustomAnnotations(project, GlobalSearchScope.allScope((Project)project));
            return CachedValueProvider.Result.createSingleDependency(availableAnnotations, (Object)ProjectRootManager.getInstance((Project)project));
        });
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<String> getCustomBeanAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCustomizationManager.$$$reportNull$$$0(3);
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            DumbService dumbService = DumbService.getInstance((Project)module.getProject());
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.createSingleDependency(Collections.emptyList(), (Object)dumbService);
            }
            List<String> availableAnnotations = CdiCustomizationManager.getAvailableCustomAnnotations(module.getProject(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.createSingleDependency(availableAnnotations, (Object)ProjectRootManager.getInstance((Project)module.getProject()));
        });
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<String> getAvailableCustomAnnotations(Project project, GlobalSearchScope scope) {
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)project);
        List<String> list = ANNOTATIONS_EP_NAME.getExtensionList().stream().flatMap(provider -> provider.getCustomBeanAnnotations().stream()).filter(annotation -> javaPsi.findClass(annotation, scope) != null).collect(Collectors.toList());
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<String> getCustomAlternativeAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCustomizationManager.$$$reportNull$$$0(6);
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            DumbService dumbService = DumbService.getInstance((Project)module.getProject());
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{dumbService});
            }
            JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)module.getProject());
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            List availableAnnotations = ANNOTATIONS_EP_NAME.getExtensionList().stream().flatMap(provider -> {
                String annotation = provider.getCustomAlternativeAnnotation();
                return Stream.ofNullable(annotation);
            }).filter(annotation -> javaPsi.findClass(annotation, scope) != null).collect(Collectors.toList());
            return CachedValueProvider.Result.createSingleDependency(availableAnnotations, (Object)ProjectRootManager.getInstance((Project)module.getProject()));
        });
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public static String getQualifierBeanAnnotation(@NotNull Project project, String qualifierAnnotation) {
        if (project == null) {
            CdiCustomizationManager.$$$reportNull$$$0(8);
        }
        Map customMappings = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashMap<String, String> mappings = new HashMap<String, String>();
            for (CdiAnnotationsProvider provider : ANNOTATIONS_EP_NAME.getExtensionList()) {
                mappings.putAll(provider.getCustomQualifierMappings());
            }
            return CachedValueProvider.Result.createSingleDependency(mappings, (Object)ProjectRootManager.getInstance((Project)project));
        });
        return (String)customMappings.get(qualifierAnnotation);
    }

    public static boolean hasDefaultBeanAnnotation(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            CdiCustomizationManager.$$$reportNull$$$0(9);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)element, CdiCustomizationManager.getDefaultAnnotations(element.getProject()), (int)0);
    }

    public static boolean hasMockAnnotation(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            CdiCustomizationManager.$$$reportNull$$$0(10);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)element, CdiCustomizationManager.getMockAnnotations(element.getProject()), (int)0);
    }

    public static boolean hasExtendedInjectionAnnotation(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            CdiCustomizationManager.$$$reportNull$$$0(11);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)element, CdiCustomizationManager.getExtendedInjectionQualifiers(element.getProject()), (int)0);
    }

    private static List<String> getDefaultAnnotations(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set defaultAnnotations = ContainerUtil.map2SetNotNull((Collection)ANNOTATIONS_EP_NAME.getExtensionList(), CdiAnnotationsProvider::getDefaultAnnotation);
            return CachedValueProvider.Result.createSingleDependency(CdiCustomizationManager.filterExistingAnnotations(project, defaultAnnotations), (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    private static List<String> getMockAnnotations(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set mockAnnotations = ContainerUtil.map2SetNotNull((Collection)ANNOTATIONS_EP_NAME.getExtensionList(), CdiAnnotationsProvider::getMockAnnotation);
            return CachedValueProvider.Result.createSingleDependency(CdiCustomizationManager.filterExistingAnnotations(project, mockAnnotations), (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    private static List<String> getExtendedInjectionQualifiers(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set<String> customAnnotations = ANNOTATIONS_EP_NAME.getExtensionList().stream().flatMap(ext -> ext.getExtendedInjectionQualifiers().stream()).collect(Collectors.toSet());
            return CachedValueProvider.Result.createSingleDependency(CdiCustomizationManager.filterExistingAnnotations(project, customAnnotations), (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    @NotNull
    private static List<String> filterExistingAnnotations(@NotNull Project project, @NotNull Set<String> defaultAnnotations) {
        if (project == null) {
            CdiCustomizationManager.$$$reportNull$$$0(12);
        }
        if (defaultAnnotations == null) {
            CdiCustomizationManager.$$$reportNull$$$0(13);
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        List list = ContainerUtil.filter(defaultAnnotations, a -> javaPsi.findClass(a, scope) != null);
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/beans/CdiCustomizationManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/beans/CdiCustomizationManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomBeanAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableCustomAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomAlternativeAnnotations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExistingAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomization";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomBeanAnnotations";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomAlternativeAnnotations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierBeanAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultBeanAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasMockAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasExtendedInjectionAnnotation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

