/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.remote.docker;

import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathMapper;
import com.intellij.util.net.NetUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/gradle/ext/remote/docker/GradleInDockerExecutionAware;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware;", "()V", "getEnvironmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "runConfiguration", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "", "isPreviewMode", "", "isRemoteRun", "prepareExecution", "", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "externalProjectPath", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "DockerEnvironmentConfigurationProvider", "intellij.gradle.ext"})
@ApiStatus.Internal
final class GradleInDockerExecutionAware
implements GradleExecutionAware {
    public void prepareExecution(@NotNull ExternalSystemTask task, @NotNull String externalProjectPath, boolean isPreviewMode, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = new LocalGradleExecutionAware().getEnvironmentConfigurationProvider(runConfiguration, project);
        if (targetEnvironmentConfigurationProvider == null) {
            return null;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
        if (!(environmentConfigurationProvider.getEnvironmentConfiguration() instanceof DockerTargetEnvironmentConfiguration)) {
            return null;
        }
        return (TargetEnvironmentConfigurationProvider)new DockerEnvironmentConfigurationProvider(environmentConfigurationProvider);
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull String projectPath, boolean isPreviewMode, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = new LocalGradleExecutionAware().getEnvironmentConfigurationProvider(projectPath, isPreviewMode, project);
        if (targetEnvironmentConfigurationProvider == null) {
            return null;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
        if (!(environmentConfigurationProvider.getEnvironmentConfiguration() instanceof DockerTargetEnvironmentConfiguration)) {
            return null;
        }
        return (TargetEnvironmentConfigurationProvider)new DockerEnvironmentConfigurationProvider(environmentConfigurationProvider);
    }

    public boolean isRemoteRun(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = new LocalGradleExecutionAware().getEnvironmentConfigurationProvider(runConfiguration, project);
        if (targetEnvironmentConfigurationProvider == null) {
            return false;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
        TargetEnvironmentConfiguration environmentConfiguration = environmentConfigurationProvider.getEnvironmentConfiguration();
        return environmentConfiguration instanceof DockerTargetEnvironmentConfiguration;
    }

    @Nullable
    public BuildLayoutParameters getBuildLayoutParameters(@NotNull Project project, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return GradleExecutionAware.DefaultImpls.getBuildLayoutParameters((GradleExecutionAware)this, (Project)project, (String)projectPath);
    }

    @Nullable
    public BuildLayoutParameters getDefaultBuildLayoutParameters(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradleExecutionAware.DefaultImpls.getDefaultBuildLayoutParameters((GradleExecutionAware)this, (Project)project);
    }

    public boolean isGradleInstallationHomeDir(@NotNull Project project, @NotNull String homePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        return GradleExecutionAware.DefaultImpls.isGradleInstallationHomeDir((GradleExecutionAware)this, (Project)project, (String)homePath);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/gradle/ext/remote/docker/GradleInDockerExecutionAware$DockerEnvironmentConfigurationProvider;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;", "environmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "(Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;)V", "environmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getEnvironmentConfiguration", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "pathMapper", "Lcom/intellij/util/PathMapper;", "getPathMapper", "()Lcom/intellij/util/PathMapper;", "getClientCommunicationAddress", "Lcom/intellij/execution/target/HostPort;", "targetEnvironmentConfiguration", "gradleServerHostPort", "getServerBindingAddress", "intellij.gradle.ext"})
    private static final class DockerEnvironmentConfigurationProvider
    implements GradleServerConfigurationProvider {
        private final TargetEnvironmentConfigurationProvider environmentConfigurationProvider;

        @NotNull
        public TargetEnvironmentConfiguration getEnvironmentConfiguration() {
            return this.environmentConfigurationProvider.getEnvironmentConfiguration();
        }

        @Nullable
        public PathMapper getPathMapper() {
            return this.environmentConfigurationProvider.getPathMapper();
        }

        @NotNull
        public HostPort getServerBindingAddress(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            String address = "";
            int port = NetUtils.tryToFindAvailableSocketPort((int)123458);
            return new HostPort(address, port);
        }

        @NotNull
        public HostPort getClientCommunicationAddress(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration, @NotNull HostPort gradleServerHostPort) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            Intrinsics.checkNotNullParameter((Object)gradleServerHostPort, (String)"gradleServerHostPort");
            String string = NetUtils.getLocalHostString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NetUtils.getLocalHostString()");
            return new HostPort(string, gradleServerHostPort.getPort());
        }

        public DockerEnvironmentConfigurationProvider(@NotNull TargetEnvironmentConfigurationProvider environmentConfigurationProvider) {
            Intrinsics.checkNotNullParameter((Object)environmentConfigurationProvider, (String)"environmentConfigurationProvider");
            this.environmentConfigurationProvider = environmentConfigurationProvider;
        }
    }
}

