/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.profiler;

import com.intellij.build.events.StartEvent;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.NewProcessStartedFromExternalSystemCommunicator;
import com.intellij.profiler.ultimate.async.StartedFromExternalSystemProcess;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.gradle.ext.profiler.GradleRunConfigurationExtensionKt;
import org.jetbrains.idea.gradle.ext.profiler.OnTaskStartedListener;
import org.jetbrains.idea.gradle.ext.profiler.model.JavaTaskData;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.GradleTasksUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u0015H\u0002\u001aL\u0010\u0017\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180\u00192\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0011\u001a\u00020\u001b2\u001e\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001dH\u0000\u001a\f\u0010\"\u001a\u00020\u0002*\u00020#H\u0002\"'\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"'\u0010\u0007\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\b0\b0\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006\u00a8\u0006$"}, d2={"noJavaTaskDataInfo", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getNoJavaTaskDataInfo", "()Lcom/intellij/openapi/util/Key;", "targetTaskFqnKey", "", "getTargetTaskFqnKey", "doProcessGradleTasks", "runConfiguration", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "findTargetTask", "javaTaskDataAvailable", "onTaskStarted", "", "handler", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler;", "targetTask", "onTaskStartedCallback", "Lkotlin/Function1;", "Lcom/intellij/build/events/StartEvent;", "doAttachToGradleProcess", "T", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/intellij/execution/process/ProcessHandler;", "profilerProcessFactory", "Lkotlin/Function2;", "Lcom/intellij/profiler/ultimate/NewProcessStartedFromExternalSystemCommunicator;", "", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/ultimate/async/StartedFromExternalSystemProcess;", "isJavaExec", "Lorg/jetbrains/plugins/gradle/util/GradleTaskData;", "intellij.gradle.ext"})
public final class GradleRunConfigurationExtensionKt {
    @NotNull
    private static final Key<String> targetTaskFqnKey;
    @NotNull
    private static final Key<Boolean> noJavaTaskDataInfo;

    @NotNull
    public static final Key<String> getTargetTaskFqnKey() {
        return targetTaskFqnKey;
    }

    @NotNull
    public static final Key<Boolean> getNoJavaTaskDataInfo() {
        return noJavaTaskDataInfo;
    }

    public static final boolean doProcessGradleTasks(@NotNull GradleRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        if (GradleRunConfigurationExtensionKt.javaTaskDataAvailable(runConfiguration)) {
            String string = GradleRunConfigurationExtensionKt.findTargetTask(runConfiguration);
            if (string == null) {
                return false;
            }
            String targetTask = string;
            runConfiguration.putUserData(targetTaskFqnKey, (Object)targetTask);
        } else {
            runConfiguration.putUserData(noJavaTaskDataInfo, (Object)true);
        }
        return true;
    }

    private static final boolean javaTaskDataAvailable(GradleRunConfiguration runConfiguration) {
        boolean bl;
        block5: {
            ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = runConfiguration.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"runConfiguration.settings");
            String gradleProjectPath = externalSystemTaskExecutionSettings.getExternalProjectPath();
            Project project = runConfiguration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runConfiguration.project");
            Object object = (MultiMap)GradleTasksUtilKt.getGradleTasks((Project)project).get(gradleProjectPath);
            if (object != null && (object = object.values()) != null) {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GradleTaskData it = (GradleTaskData)element$iv;
                        boolean bl2 = false;
                        GradleTaskData gradleTaskData = it;
                        Intrinsics.checkNotNullExpressionValue((Object)gradleTaskData, (String)"it");
                        if (!GradleRunConfigurationExtensionKt.isJavaExec(gradleTaskData)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final String findTargetTask(GradleRunConfiguration runConfiguration) {
        v0 = runConfiguration.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"runConfiguration.settings");
        gradleProjectPath = v0.getExternalProjectPath();
        v1 = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"runConfiguration.project");
        v2 = (MultiMap)GradleTasksUtilKt.getGradleTasks((Project)v1).get(gradleProjectPath);
        if (v2 == null) {
            return null;
        }
        allKnownTasks = v2;
        v3 = allKnownTasks.values();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"allKnownTasks.values()");
        $this$map$iv = v3;
        $i$f$map = false;
        var6_6 = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            var11_19 = (GradleTaskData)item$iv$iv;
            var34_16 = destination$iv$iv /* !! */ ;
            $i$a$-map-GradleRunConfigurationExtensionKt$findTargetTask$fqnTasks$1 = false;
            var35_17 = TuplesKt.to((Object)it.getFqnTaskName(), (Object)it);
            var34_16.add(var35_17);
        }
        fqnTasks = (List)destination$iv$iv /* !! */ ;
        $this$filter$iv = fqnTasks;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            $dstr$_u24__u24$task = (Pair)element$iv$iv;
            $i$a$-filter-GradleRunConfigurationExtensionKt$findTargetTask$suitableTasks$1 = false;
            task = (GradleTaskData)$dstr$_u24__u24$task.component2();
            if (task.isTest()) ** GOTO lbl-1000
            v4 = task;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"task");
            if (GradleRunConfigurationExtensionKt.isJavaExec(v4)) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suitableTasks = (List)destination$iv$iv;
        v6 = runConfiguration.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"runConfiguration.settings");
        v7 = v6.getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"runConfiguration.settings.taskNames");
        candidates = v7;
        $this$mapNotNull$iv = candidates;
        $i$f$mapNotNull = false;
        $i$f$filterTo = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_26 = $this$forEach$iv$iv$iv.iterator();
        while (var14_26.hasNext()) {
            block7: {
                element$iv$iv = element$iv$iv$iv = var14_26.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                name = (String)element$iv$iv;
                $i$a$-mapNotNull-GradleRunConfigurationExtensionKt$findTargetTask$suitableCandidates$1 = false;
                var20_32 = suitableTasks;
                var21_33 = false;
                var22_34 = var20_32;
                var23_35 = false;
                for (T var25_37 : var22_34) {
                    $dstr$fqnTaskName$_u24__u24 = (Pair)var25_37;
                    $i$a$-find-GradleRunConfigurationExtensionKt$findTargetTask$suitableCandidates$1$1 = false;
                    fqnTaskName = (String)$dstr$fqnTaskName$_u24__u24.component1();
                    v8 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"name");
                    if (!StringsKt.endsWith$default((String)fqnTaskName, (String)v8, (boolean)false, (int)2, null)) continue;
                    v9 = var25_37;
                    break block7;
                }
                v9 = null;
            }
            v10 = v9;
            if ((v10 != null ? (String)v10.getFirst() : null) == null) continue;
            var29_41 = var29_41;
            var30_42 = false;
            var31_43 = false;
            it$iv$iv = var29_41;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        suitableCandidates = (List)destination$iv$iv;
        return (String)CollectionsKt.firstOrNull((List)suitableCandidates);
    }

    public static final <T> void doAttachToGradleProcess(@NotNull JavaProfilerConfigurationExtension<T> $this$doAttachToGradleProcess, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull ProcessHandler handler, @NotNull Function2<? super NewProcessStartedFromExternalSystemCommunicator, ? super Long, ? extends ProfilerProcess<StartedFromExternalSystemProcess>> profilerProcessFactory) {
        Intrinsics.checkNotNullParameter($this$doAttachToGradleProcess, (String)"$this$doAttachToGradleProcess");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(profilerProcessFactory, (String)"profilerProcessFactory");
        if (!(handler instanceof ExternalSystemProcessHandler) || !(runConfiguration instanceof GradleRunConfiguration)) {
            return;
        }
        if (Intrinsics.areEqual((Object)((GradleRunConfiguration)runConfiguration).getUserData(noJavaTaskDataInfo), (Object)true)) {
            ((GradleRunConfiguration)runConfiguration).putUserData(noJavaTaskDataInfo, null);
            $this$doAttachToGradleProcess.openToolWindowAndReportStart((ProfilerProcess)profilerProcessFactory.invoke((Object)new NewProcessStartedFromExternalSystemCommunicator((ExternalSystemProcessHandler)handler), (Object)System.currentTimeMillis()), runConfiguration);
            return;
        }
        String string = (String)((GradleRunConfiguration)runConfiguration).getUserData(targetTaskFqnKey);
        if (string == null) {
            return;
        }
        String targetTask = string;
        ((GradleRunConfiguration)runConfiguration).putUserData(targetTaskFqnKey, null);
        boolean $i$f$service = false;
        Class<ExternalSystemProgressNotificationManager> serviceClass$iv = ExternalSystemProgressNotificationManager.class;
        if (ApplicationManager.getApplication().getService(serviceClass$iv) == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        GradleRunConfigurationExtensionKt.onTaskStarted((ExternalSystemProcessHandler)handler, targetTask, (Function1<? super StartEvent, Unit>)((Function1)new Function1<StartEvent, Unit>($this$doAttachToGradleProcess, profilerProcessFactory, handler, runConfiguration){
            final /* synthetic */ JavaProfilerConfigurationExtension $this_doAttachToGradleProcess;
            final /* synthetic */ Function2 $profilerProcessFactory;
            final /* synthetic */ ProcessHandler $handler;
            final /* synthetic */ RunConfigurationBase $runConfiguration;

            public final void invoke(@NotNull StartEvent startEvent) {
                Intrinsics.checkNotNullParameter((Object)startEvent, (String)"startEvent");
                this.$this_doAttachToGradleProcess.openToolWindowAndReportStart((ProfilerProcess)this.$profilerProcessFactory.invoke((Object)new NewProcessStartedFromExternalSystemCommunicator((ExternalSystemProcessHandler)this.$handler), (Object)startEvent.getEventTime()), this.$runConfiguration);
            }
            {
                this.$this_doAttachToGradleProcess = javaProfilerConfigurationExtension;
                this.$profilerProcessFactory = function2;
                this.$handler = processHandler;
                this.$runConfiguration = runConfigurationBase;
                super(1);
            }
        }));
    }

    private static final void onTaskStarted(ExternalSystemProcessHandler handler, String targetTask, Function1<? super StartEvent, Unit> onTaskStartedCallback) {
        ExternalSystemTask externalSystemTask = handler.getTask();
        if (externalSystemTask == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTask, (String)"handler.task ?: return");
        ExternalSystemTask buildTask = externalSystemTask;
        ExternalSystemProgressNotificationManager notificationManager = (ExternalSystemProgressNotificationManager)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class);
        OnTaskStartedListener taskListener2 = new OnTaskStartedListener(onTaskStartedCallback, notificationManager, targetTask, targetTask){
            final /* synthetic */ Function1 $onTaskStartedCallback;
            final /* synthetic */ ExternalSystemProgressNotificationManager $notificationManager;
            final /* synthetic */ String $targetTask;

            public void onTaskStarted(@NotNull StartEvent startEvent) {
                Intrinsics.checkNotNullParameter((Object)startEvent, (String)"startEvent");
                this.$onTaskStartedCallback.invoke((Object)startEvent);
                this.$notificationManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
            }
            {
                this.$onTaskStartedCallback = $captured_local_variable$0;
                this.$notificationManager = $captured_local_variable$1;
                this.$targetTask = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        notificationManager.addNotificationListener(buildTask.getId(), (ExternalSystemTaskNotificationListener)taskListener2);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(notificationManager, taskListener2){
            final /* synthetic */ ExternalSystemProgressNotificationManager $notificationManager;
            final /* synthetic */ onTaskStarted.taskListener.1 $taskListener;

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$notificationManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this.$taskListener);
            }
            {
                this.$notificationManager = $captured_local_variable$0;
                this.$taskListener = $captured_local_variable$1;
            }
        });
    }

    private static final boolean isJavaExec(GradleTaskData $this$isJavaExec) {
        JavaTaskData javaTaskData = (JavaTaskData)$this$isJavaExec.find(JavaTaskData.KEY);
        return javaTaskData != null ? javaTaskData.isJavaExec() : false;
    }

    static {
        Key key = Key.create((String)"profiler.gradle.configuration.target.task.name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<String>(\"prof\u2026ration.target.task.name\")");
        targetTaskFqnKey = key;
        Key key2 = Key.create((String)"profiler.gradle.configuration.no.java.task.data.info");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<Boolean>(\"pro\u2026.no.java.task.data.info\")");
        noJavaTaskDataInfo = key2;
    }
}

