/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jms;

import com.intellij.jam.JavaLibraryUtils;
import com.intellij.javaee.constants.JavaeeExtensionsConstants;
import com.intellij.microservices.uast.callsites.ArgumentCallSite;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javaee/jms/JmsMQUtils;", "", "()V", "isActiveAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "isAmazonSqsAvailable", "isJmsAvailable", "isKafkaAvailable", "isRabbitAvailable", "isRabbitQueue", "isQueueArg", "Lorg/jetbrains/uast/UExpression;", "isRabbitQueueDeclaration", "callSite", "Lcom/intellij/microservices/uast/callsites/ArgumentCallSite;", "isRabbitQueueExpression", "call", "Lorg/jetbrains/uast/UCallExpression;", "intellij.javaee.extensions"})
public final class JmsMQUtils {
    @NotNull
    public static final JmsMQUtils INSTANCE;

    public final boolean isJmsAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)JavaeeExtensionsConstants.JMS_SESSION.javax()) || JavaLibraryUtils.hasLibraryClass((Project)project, (String)JavaeeExtensionsConstants.JMS_SESSION.jakarta());
    }

    public final boolean isActiveAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.apache.activemq.command.ActiveMQQueue");
    }

    public final boolean isRabbitAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"com.rabbitmq.jms.admin.RMQDestination");
    }

    public final boolean isAmazonSqsAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"com.amazonaws.services.sqs.AmazonSQS");
    }

    public final boolean isKafkaAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.apache.kafka.clients.producer.ProducerRecord");
    }

    private final boolean isRabbitQueue(UExpression isQueueArg) {
        return isQueueArg != null && Intrinsics.areEqual((Object)isQueueArg.evaluate(), (Object)true);
    }

    public final boolean isRabbitQueueDeclaration(@NotNull ArgumentCallSite callSite) {
        UCallExpression call;
        Intrinsics.checkNotNullParameter((Object)callSite, (String)"callSite");
        PsiElement psiElement = callSite.getPsiElement();
        UCallExpression uCallExpression = call = psiElement != null ? (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)psiElement, UCallExpression.class, (boolean)false) : null;
        UExpression arg = uCallExpression != null ? uCallExpression.getArgumentForParameter(1) : null;
        return this.isRabbitQueue(arg);
    }

    public final boolean isRabbitQueueExpression(@Nullable UCallExpression call) {
        UCallExpression uCallExpression = call;
        UExpression arg = uCallExpression != null ? uCallExpression.getArgumentForParameter(1) : null;
        return this.isRabbitQueue(arg);
    }

    private JmsMQUtils() {
    }

    static {
        JmsMQUtils jmsMQUtils;
        INSTANCE = jmsMQUtils = new JmsMQUtils();
    }
}

