/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.batch;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.PairProcessor;
import java.util.LinkedHashMap;
import java.util.Map;

final class EnableCachingModelProvider
extends LocalAnnotationModelDependentModelsProvider {
    private static final Map<String, String> CACHE_CONFIGURATION;

    EnableCachingModelProvider() {
    }

    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<? super LocalModel, ? super LocalModelDependency> processor) {
        Module module = localAnnotationModel.getModule();
        if ("org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration.CacheConfigurationImportSelector".equals(localAnnotationModel.getConfig().getQualifiedName())) {
            for (Map.Entry<String, String> classNames : CACHE_CONFIGURATION.entrySet()) {
                PsiClass cacheConfiguration;
                if (SpringCommonUtils.findLibraryClass((Module)module, (String)classNames.getValue()) == null || (cacheConfiguration = SpringCommonUtils.findLibraryClass((Module)module, (String)classNames.getKey())) == null) continue;
                LocalAnnotationModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(cacheConfiguration, module, localAnnotationModel.getActiveProfiles());
                return processor.process((Object)model, (Object)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)cacheConfiguration));
            }
        }
        return true;
    }

    static {
        LinkedHashMap<String, String> cacheConfigurations = new LinkedHashMap<String, String>();
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.CouchbaseCacheConfiguration", "com.couchbase.client.spring.cache.CouchbaseCacheManager");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.RedisCacheConfiguration", "org.springframework.data.redis.cache.RedisCacheManager");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.CaffeineCacheConfiguration", "com.github.benmanes.caffeine.cache.Caffeine");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.HazelcastCacheConfiguration", "com.hazelcast.spring.cache.HazelcastCacheManager");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.SimpleCacheConfiguration", "org.springframework.cache.CacheManager");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.GenericCacheConfiguration", "org.springframework.cache.Cache");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.JCacheCacheConfiguration", "org.springframework.cache.jcache.JCacheCacheManager");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.InfinispanCacheConfiguration", "org.infinispan.spring.provider.SpringEmbeddedCacheManager");
        cacheConfigurations.put("org.springframework.boot.autoconfigure.cache.EhCacheCacheConfiguration", "org.springframework.cache.Cache");
        CACHE_CONFIGURATION = cacheConfigurations;
    }
}

