/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.util;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.ws.jam.SpringWebServiceEndpoint;
import com.intellij.spring.ws.model.ws.Namespace;
import com.intellij.spring.ws.model.ws.XpathEndpoints;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringWebServiceJamUtil {
    private static final Key<CachedValue<Map<String, VirtualFile>>> SCHEMAS_KEY = Key.create((String)"spring ws schemas");

    private SpringWebServiceJamUtil() {
    }

    @Nullable
    public static SpringWebServiceEndpoint getEndpoint(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(0);
        }
        return (SpringWebServiceEndpoint)JamService.getJamService((Project)aClass.getProject()).getJamElement((PsiElement)aClass, new JamMemberMeta[]{SpringWebServiceEndpoint.META});
    }

    @NotNull
    public static List<SpringWebServiceEndpoint> findEndpoints(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(2);
        }
        List list = JamService.getJamService((Project)module.getProject()).getJamClassElements(SpringWebServiceEndpoint.META, "org.springframework.ws.server.endpoint.annotation.Endpoint", scope);
        if (list == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static boolean isEndpoint(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(4);
        }
        return SpringWebServiceJamUtil.getEndpoint(aClass) != null;
    }

    @NotNull
    public static Map<String, VirtualFile> getSchemas(@NotNull Module module) {
        Project project;
        CachedValuesManager manager;
        Map bundle;
        if (module == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(5);
        }
        Map map = (bundle = (Map)(manager = CachedValuesManager.getManager((Project)(project = module.getProject()))).getCachedValue((UserDataHolder)module, SCHEMAS_KEY, () -> SpringWebServiceJamUtil.computeSchemas(module), false)) == null ? Collections.emptyMap() : bundle;
        if (map == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    private static CachedValueProvider.Result<Map<String, VirtualFile>> computeSchemas(@NotNull Module module) {
        if (module == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(7);
        }
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
        dependencies.add(VirtualFileManager.getInstance());
        List resources = XmlNamespaceIndex.getAllResources((Module)module, (Project)module.getProject());
        for (IndexedRelevantResource resource : resources) {
            VirtualFile file = resource.getFile();
            String namespace = ((XsdNamespaceBuilder)resource.getValue()).getNamespace();
            if (file == null || StringUtil.isEmptyOrSpaces((String)namespace)) continue;
            map.put(namespace, file);
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
            if (psiFile == null) continue;
            dependencies.add(psiFile);
        }
        return new CachedValueProvider.Result(map, dependencies.toArray());
    }

    public static Map<String, GenericAttributeValue<String>> getXPathNamespacePrefixes(@NotNull Module module) {
        if (module == null) {
            SpringWebServiceJamUtil.$$$reportNull$$$0(8);
        }
        HashMap<String, GenericAttributeValue<String>> prefixes = new HashMap<String, GenericAttributeValue<String>>();
        PsiClass xPathParamEndPointAdapter = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.ws.server.endpoint.adapter.XPathParamAnnotationMethodEndpointAdapter");
        if (xPathParamEndPointAdapter == null) {
            return prefixes;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)xPathParamEndPointAdapter).withInheritors();
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
        for (SpringModel model : models) {
            List pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
            for (SpringBeanPointer pointer : pointers) {
                CommonSpringBean bean = pointer.getSpringBean();
                if (bean instanceof SpringBean) {
                    SpringPropertyDefinition springProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"namespaces");
                    if (!(springProperty instanceof SpringProperty)) continue;
                    for (Prop prop : ((SpringProperty)springProperty).getProps().getProps()) {
                        String prefix = prop.getKey().getStringValue();
                        String uri = prop.getStringValue();
                        if (StringUtil.isEmptyOrSpaces((String)prefix) || StringUtil.isEmptyOrSpaces((String)uri)) continue;
                        prefixes.put(uri, (GenericAttributeValue<String>)prop.getKey());
                    }
                    continue;
                }
                if (!(bean instanceof XpathEndpoints)) continue;
                for (Namespace namespace : ((XpathEndpoints)bean).getNamespaces()) {
                    String prefix = namespace.getPrefix().getStringValue();
                    String uri = namespace.getUri().getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)prefix) || StringUtil.isEmptyOrSpaces((String)uri)) continue;
                    prefixes.put(uri, namespace.getPrefix());
                }
            }
        }
        return prefixes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/ws/util/SpringWebServiceJamUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/ws/util/SpringWebServiceJamUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findEndpoints";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEndpoint";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findEndpoints";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEndpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSchemas";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeSchemas";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getXPathNamespacePrefixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

