/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.microservices;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.ws.jam.SpringWebServiceEndpoint;
import com.intellij.spring.ws.jam.SpringWebServiceEndpointMethod;
import com.intellij.spring.ws.util.SpringWebServiceJamUtil;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaUltimateIcons;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringWebServiceEndpointProvider
implements EndpointsProvider<SpringWebServiceEndpoint, SpringWebServiceEndpointMethod> {
    private final SourceTestLibSearcher<SpringWebServiceEndpoint> wsSearcher = new SourceTestLibSearcher("SPRING_WS_CLASSES", SpringWebServiceJamUtil::findEndpoints);

    SpringWebServiceEndpointProvider() {
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.XML_WEB_SERVICE_TYPE;
        if (endpointType == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(0);
        }
        return endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return new FrameworkPresentation("Spring-WS", "Spring Web Services", SpringApiIcons.SpringWeb);
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                SpringWebServiceEndpointProvider.$$$reportNull$$$0(2);
            }
            return status;
        }
        if (!SpringWebServicesUtil.hasSpringWebServicesLibrary(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                SpringWebServiceEndpointProvider.$$$reportNull$$$0(3);
            }
            return status;
        }
        if (SpringCommonUtils.hasSpringFacets((Project)project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
            if (status == null) {
                SpringWebServiceEndpointProvider.$$$reportNull$$$0(4);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.AVAILABLE;
        if (status == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(5);
        }
        return status;
    }

    @NotNull
    public Iterable<SpringWebServiceEndpoint> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(7);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringWebServiceEndpointProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        ModuleEndpointsFilter moduleFilter = (ModuleEndpointsFilter)filter;
        Module module = moduleFilter.getModule();
        if (!SpringWebServicesUtil.hasSpringWebServicesLibrary(module)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringWebServiceEndpointProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        Iterable iterable = this.wsSearcher.iterable(module, moduleFilter.getFromTests(), moduleFilter.getFromLibraries());
        if (iterable == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(10);
        }
        return iterable;
    }

    @NotNull
    public Iterable<SpringWebServiceEndpointMethod> getEndpoints(@NotNull SpringWebServiceEndpoint group) {
        if (group == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.concat(group.getPayloadRoots(), (List)group.getActions());
        if (list == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SpringWebServiceEndpoint group, @NotNull SpringWebServiceEndpointMethod endpoint) {
        if (group == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(13);
        }
        if (endpoint == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(14);
        }
        PsiMethod psiMethod = endpoint.getPsiElement();
        String className = group.getPsiElement().getName();
        String parameters = Arrays.stream(psiMethod.getParameterList().getParameters()).map(p -> p.getName()).collect(Collectors.joining(", "));
        return new PresentationData(String.format("%s.%s(%s)", className, psiMethod.getName(), parameters), group.getPsiElement().getName(), JavaUltimateIcons.Web.XmlService, null);
    }

    @Nullable
    public Object getEndpointData(@NotNull SpringWebServiceEndpoint group, @NotNull SpringWebServiceEndpointMethod endpoint, @NotNull String dataId) {
        if (group == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(15);
        }
        if (endpoint == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(16);
        }
        if (dataId == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(17);
        }
        return EndpointsViewUtils.getCommonEndpointValue((PsiElement)endpoint.getPsiElement(), (String)dataId);
    }

    public boolean isValidEndpoint(@NotNull SpringWebServiceEndpoint group, @NotNull SpringWebServiceEndpointMethod endpoint) {
        if (group == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(18);
        }
        if (endpoint == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(19);
        }
        return endpoint.isPsiValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(20);
        }
        ModificationTracker modificationTracker = SpringModificationTrackersManager.getInstance((Project)project).getEndpointsModificationTracker();
        if (modificationTracker == null) {
            SpringWebServiceEndpointProvider.$$$reportNull$$$0(21);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/ws/microservices/SpringWebServiceEndpointProvider";
                break;
            }
            case 1: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/ws/microservices/SpringWebServiceEndpointProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEndpoints";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointData";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

