/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.jam;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.ws.util.SpringWebServiceJamUtil;
import com.intellij.spring.ws.util.XsdUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringWebServiceXPathReferenceSet
extends ReferenceSetBase<PsiReference> {
    public SpringWebServiceXPathReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            SpringWebServiceXPathReferenceSet.$$$reportNull$$$0(0);
        }
        super(ElementManipulators.getValueText((PsiElement)element), element, ElementManipulators.getOffsetInElement((PsiElement)element), '/');
    }

    protected List<PsiReference> createReferences(TextRange range, int prefixWithValueIndex) {
        final PsiElement element = this.getElement();
        String string = SpringWebServiceXPathReferenceSet.getText(range, element);
        ReferenceSetBase<PsiReference> referenceSet = new ReferenceSetBase<PsiReference>(string, element, range.getStartOffset(), ':'){

            protected PsiReference createReference(TextRange range, int index) {
                return index == 0 ? new XPathPrefixReference(element, range, this, index) : new XPathValueReference(element, range, this, index);
            }
        };
        return referenceSet.getReferences();
    }

    private static String getText(@NotNull TextRange range, @NotNull PsiElement element) {
        if (range == null) {
            SpringWebServiceXPathReferenceSet.$$$reportNull$$$0(1);
        }
        if (element == null) {
            SpringWebServiceXPathReferenceSet.$$$reportNull$$$0(2);
        }
        return range.substring(element.getText());
    }

    public boolean isSoft() {
        return false;
    }

    public abstract XmlFile getNamespaceFile();

    @Nullable
    public abstract String getNamespace();

    public abstract String getLocalPart();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/ws/jam/SpringWebServiceXPathReferenceSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class XPathValueReference
    extends PsiReferenceBase<PsiElement> {
        private final ReferenceSetBase<PsiReference> myReferenceSetBase;
        private final int myIndex;

        XPathValueReference(PsiElement element, TextRange range, ReferenceSetBase<PsiReference> referenceSetBase, int index) {
            super(element, range, false);
            this.myReferenceSetBase = referenceSetBase;
            this.myIndex = index;
        }

        @Nullable
        public XmlTag getParentTag() {
            XPathValueReference lastReference = this.getPreviousReference();
            if (lastReference == null) {
                String namespace = SpringWebServiceXPathReferenceSet.this.getNamespace();
                XmlFile xmlFile = SpringWebServiceXPathReferenceSet.this.getNamespaceFile();
                String localPart = SpringWebServiceXPathReferenceSet.this.getLocalPart();
                if (xmlFile == null || StringUtil.isEmptyOrSpaces((String)localPart) || StringUtil.isEmptyOrSpaces((String)namespace)) {
                    return null;
                }
                XsdUtil.XsdElement element = XsdUtil.findXsdElement((XmlElement)xmlFile, namespace, localPart);
                return element == null ? null : element.getDeclaration();
            }
            PsiElement parentTagElement = lastReference.resolve();
            if (parentTagElement instanceof XmlTag) {
                return (XmlTag)parentTagElement;
            }
            return null;
        }

        @Nullable
        private XPathValueReference getPreviousReference() {
            XPathValueReference previousReference = null;
            for (PsiReference psiReference : SpringWebServiceXPathReferenceSet.this.getPsiReferences()) {
                if (psiReference.equals((Object)this)) {
                    return previousReference;
                }
                if (!(psiReference instanceof XPathValueReference)) continue;
                previousReference = (XPathValueReference)psiReference;
            }
            return null;
        }

        public PsiElement resolve() {
            XsdUtil.XsdElement xsdElement;
            String value = this.getValue();
            String namespace = SpringWebServiceXPathReferenceSet.this.getNamespace();
            XmlTag parentTag = this.getParentTag();
            if (parentTag != null && namespace != null && (xsdElement = XsdUtil.getChildrenElements((XmlElement)parentTag, namespace).get(value)) != null) {
                return xsdElement.getDeclaration();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            String namespace = SpringWebServiceXPathReferenceSet.this.getNamespace();
            XmlTag parentTag = this.getParentTag();
            if (parentTag != null && namespace != null) {
                Set<String> children = XsdUtil.getChildrenElements((XmlElement)parentTag, namespace).keySet();
                Object[] objectArray = ArrayUtil.toObjectArray(children);
                if (objectArray == null) {
                    XPathValueReference.$$$reportNull$$$0(0);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                XPathValueReference.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/jam/SpringWebServiceXPathReferenceSet$XPathValueReference", "getVariants"));
        }
    }

    public class XPathPrefixReference
    extends PsiReferenceBase<PsiElement> {
        private final ReferenceSetBase<PsiReference> myReferenceSetBase;
        private final int myIndex;

        public XPathPrefixReference(PsiElement element, TextRange range, ReferenceSetBase<PsiReference> referenceSetBase, int index) {
            super(element, range, false);
            this.myReferenceSetBase = referenceSetBase;
            this.myIndex = index;
        }

        public PsiElement resolve() {
            Map<String, GenericAttributeValue<String>> attributeValueMap;
            GenericAttributeValue<String> keyValue;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module != null && (keyValue = (attributeValueMap = SpringWebServiceJamUtil.getXPathNamespacePrefixes(module)).get(SpringWebServiceXPathReferenceSet.this.getNamespace())) != null && this.getValue().equals(keyValue.getStringValue())) {
                return keyValue.getXmlAttribute();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            String prefix;
            Map<String, GenericAttributeValue<String>> attributeValueMap;
            GenericAttributeValue<String> keyValue;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module != null && (keyValue = (attributeValueMap = SpringWebServiceJamUtil.getXPathNamespacePrefixes(module)).get(SpringWebServiceXPathReferenceSet.this.getNamespace())) != null && !StringUtil.isEmptyOrSpaces((String)(prefix = keyValue.getStringValue()))) {
                Object[] objectArray = new String[]{prefix};
                if (objectArray == null) {
                    XPathPrefixReference.$$$reportNull$$$0(0);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                XPathPrefixReference.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/jam/SpringWebServiceXPathReferenceSet$XPathPrefixReference", "getVariants"));
        }
    }
}

